/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.hash;

import java.util.Map;
import jetbrains.exodus.core.dataStructures.hash.AbstractHashMap;
import jetbrains.exodus.core.dataStructures.hash.HashUtil;
import jetbrains.exodus.util.MathUtil;

public class LinkedHashMap<K, V>
extends AbstractHashMap<K, V> {
    private Entry<K, V>[] table;
    private Entry<K, V> top;
    private Entry<K, V> back;
    private int capacity;
    private final float loadFactor;
    private int mask;

    public LinkedHashMap() {
        this(0);
    }

    public LinkedHashMap(int capacity) {
        this(capacity, 1.0f);
    }

    public LinkedHashMap(int capacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.init(capacity);
    }

    @Override
    public V put(K key, V value) {
        Entry<K, V>[] table = this.table;
        int hash = key.hashCode();
        int index = HashUtil.indexFor(hash, table.length, this.mask);
        Entry e = table[index];
        while (e != null) {
            Object entryKey = e.key;
            if (entryKey == key || entryKey.equals(key)) {
                this.moveToTop(e);
                return e.setValue(value);
            }
            e = e.hashNext;
        }
        e = new Entry(key, value);
        e.hashNext = (Entry)table[index];
        table[index] = e;
        Entry<K, V> top = this.top;
        e.next = (Entry)top;
        if (top != null) {
            ((Entry)top).previous = e;
        } else {
            this.back = e;
        }
        this.top = e;
        ++this._size;
        if (this.removeEldestEntry(this.back)) {
            this.remove(this.eldestKey());
        } else if (this._size > this.capacity) {
            this.rehash(HashUtil.nextCapacity(this.capacity));
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        Entry<K, V>[] table = this.table;
        int hash = key.hashCode();
        int index = HashUtil.indexFor(hash, table.length, this.mask);
        Entry e = table[index];
        if (e == null) {
            return null;
        }
        Object entryKey = e.key;
        if (entryKey == key || entryKey.equals(key)) {
            table[index] = e.hashNext;
        } else {
            Entry last;
            do {
                last = e;
                if ((e = e.hashNext) != null) continue;
                return null;
            } while ((entryKey = e.key) != key && !entryKey.equals(key));
            last.hashNext = e.hashNext;
        }
        this.unlink(e);
        --this._size;
        return (V)e.value;
    }

    public V removeEldest() {
        return this.remove(this.eldestKey());
    }

    private K eldestKey() {
        return (K)((Entry)this.back).key;
    }

    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return false;
    }

    @Override
    protected Map.Entry<K, V> getEntry(Object key) {
        Entry<K, V>[] table = this.table;
        int hash = key.hashCode();
        int index = HashUtil.indexFor(hash, table.length, this.mask);
        Entry e = table[index];
        while (e != null) {
            Object entryKey = e.key;
            if (entryKey == key || entryKey.equals(key)) {
                this.moveToTop(e);
                return e;
            }
            e = e.hashNext;
        }
        return null;
    }

    @Override
    protected void init(int capacity) {
        if (capacity < 4) {
            capacity = 4;
        }
        this.allocateTable(HashUtil.getCeilingPrime((int)((float)capacity / this.loadFactor)));
        this.back = null;
        this.top = null;
        this.capacity = capacity;
        this._size = 0;
    }

    @Override
    protected AbstractHashMap.HashMapIterator hashIterator() {
        return new HashIterator();
    }

    private void allocateTable(int length) {
        this.table = new Entry[length];
        this.mask = (1 << MathUtil.integerLogarithm(this.table.length)) - 1;
    }

    private void moveToTop(Entry<K, V> e) {
        Entry<K, V> top = this.top;
        if (top != e) {
            Entry prev = ((Entry)e).previous;
            Entry next = ((Entry)e).next;
            prev.next = next;
            if (next != null) {
                next.previous = prev;
            } else {
                this.back = prev;
            }
            ((Entry)top).previous = (Entry)e;
            ((Entry)e).next = (Entry)top;
            ((Entry)e).previous = null;
            this.top = e;
        }
    }

    private void unlink(Entry<K, V> e) {
        Entry prev = ((Entry)e).previous;
        Entry next = ((Entry)e).next;
        if (prev != null) {
            prev.next = next;
        } else {
            this.top = next;
        }
        if (next != null) {
            next.previous = prev;
        } else {
            this.back = prev;
        }
    }

    private void rehash(int capacity) {
        int length = HashUtil.getCeilingPrime((int)((float)capacity / this.loadFactor));
        this.capacity = capacity;
        if (length != this.table.length) {
            this.allocateTable(length);
            Entry<K, V>[] table = this.table;
            int mask = this.mask;
            Entry e = this.back;
            while (e != null) {
                int index = HashUtil.indexFor(e.key.hashCode(), length, mask);
                e.hashNext = (Entry)table[index];
                table[index] = e;
                e = e.previous;
            }
        }
    }

    private final class HashIterator
    extends AbstractHashMap.HashMapIterator {
        private Entry<K, V> e;
        private Entry<K, V> last;

        private HashIterator() {
            this.e = LinkedHashMap.this.top;
        }

        @Override
        public boolean hasNext() {
            return this.e != null;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            LinkedHashMap.this.remove(this.last.key);
            this.last = null;
        }

        protected Entry<K, V> nextEntry() {
            this.last = this.e;
            Entry result = this.last;
            this.e = result.next;
            return result;
        }
    }

    private static class Entry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;
        private Entry<K, V> next;
        private Entry<K, V> previous;
        private Entry<K, V> hashNext;

        private Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V result = this.value;
            this.value = value;
            return result;
        }
    }
}

