/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures;

import java.lang.ref.SoftReference;
import java.util.Arrays;
import jetbrains.exodus.core.dataStructures.LongObjectCacheBase;
import jetbrains.exodus.core.dataStructures.SoftObjectCacheBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SoftLongObjectCacheBase<V>
extends LongObjectCacheBase<V> {
    public static final int DEFAULT_SIZE = 4096;
    public static final int MIN_SIZE = 16;
    private final SoftReference<LongObjectCacheBase<V>>[] chunks;
    private final int chunkSize;

    public SoftLongObjectCacheBase() {
        this(4096);
    }

    public SoftLongObjectCacheBase(int cacheSize) {
        super(cacheSize);
        if (cacheSize < 16) {
            cacheSize = 16;
        }
        this.chunks = new SoftReference[SoftObjectCacheBase.computeNumberOfChunks(cacheSize)];
        this.chunkSize = cacheSize / this.chunks.length;
        this.clear();
    }

    @Override
    public void clear() {
        Arrays.fill(this.chunks, null);
    }

    @Override
    public void lock() {
    }

    @Override
    public void unlock() {
    }

    @Override
    public V tryKey(long key) {
        V result;
        this.incAttempts();
        LongObjectCacheBase<V> chunk = this.getChunk(key, false);
        V v = result = chunk == null ? null : (V)chunk.tryKeyLocked(key);
        if (result != null) {
            this.incHits();
        }
        return result;
    }

    @Override
    public V getObject(long key) {
        LongObjectCacheBase<V> chunk = this.getChunk(key, false);
        if (chunk == null) {
            return null;
        }
        return chunk.getObjectLocked(key);
    }

    @Override
    public V cacheObject(long key, @NotNull V value) {
        LongObjectCacheBase<V> chunk = this.getChunk(key, true);
        if (chunk == null) {
            throw new NullPointerException();
        }
        return chunk.cacheObjectLocked(key, value);
    }

    @Override
    public V remove(long key) {
        LongObjectCacheBase<V> chunk = this.getChunk(key, false);
        if (chunk == null) {
            return null;
        }
        return chunk.removeLocked(key);
    }

    @Override
    public int count() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected abstract LongObjectCacheBase<V> newChunk(int var1);

    @Nullable
    private LongObjectCacheBase<V> getChunk(long key, boolean create) {
        LongObjectCacheBase<V> result;
        int chunkIndex = (int)((key & Long.MAX_VALUE) % (long)this.chunks.length);
        SoftReference<LongObjectCacheBase<V>> ref = this.chunks[chunkIndex];
        LongObjectCacheBase<V> longObjectCacheBase = result = ref == null ? null : ref.get();
        if (result == null && create) {
            result = this.newChunk(this.chunkSize);
            this.chunks[chunkIndex] = new SoftReference<LongObjectCacheBase<V>>(result);
        }
        return result;
    }
}

