/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.Chars;
import io.questdb.std.Unsafe;
import io.questdb.std.str.AbstractCharSequence;
import io.questdb.std.str.LPSZ;
import java.io.Closeable;

public final class CharSequenceZ
extends AbstractCharSequence
implements Closeable,
LPSZ {
    private int capacity;
    private int len;
    private long ptr = 0L;

    public CharSequenceZ(CharSequence str) {
        int l = str.length();
        this.alloc(l);
        this.cpyz(str, l);
    }

    @Override
    public long address() {
        return this.ptr;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public char charAt(int index) {
        return (char)Unsafe.getUnsafe().getByte(this.ptr + (long)index);
    }

    @Override
    public void close() {
        if (this.ptr != 0L) {
            Unsafe.free(this.ptr, this.capacity + 1, 1);
            this.ptr = 0L;
        }
    }

    @Override
    public int length() {
        return this.len;
    }

    private void alloc(int len) {
        this.capacity = len;
        this.ptr = Unsafe.malloc(this.capacity + 1, 1);
    }

    private void cpyz(CharSequence str, int len) {
        Chars.asciiStrCpy(str, len, this.ptr);
        Unsafe.getUnsafe().putByte(this.ptr + (long)len, (byte)0);
        this.len = len;
    }
}

