/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.DataFrameCursorFactory;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.Misc;

abstract class AbstractDataFrameRecordCursorFactory
extends AbstractRecordCursorFactory {
    protected final DataFrameCursorFactory dataFrameCursorFactory;

    public AbstractDataFrameRecordCursorFactory(RecordMetadata metadata, DataFrameCursorFactory dataFrameCursorFactory) {
        super(metadata);
        this.dataFrameCursorFactory = dataFrameCursorFactory;
    }

    @Override
    public String getBaseColumnName(int idx) {
        return this.dataFrameCursorFactory.getMetadata().getColumnName(idx);
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        DataFrameCursor dataFrameCursor = this.dataFrameCursorFactory.getCursor(executionContext, 2);
        try {
            return this.getCursorInstance(dataFrameCursor, executionContext);
        }
        catch (Throwable e) {
            dataFrameCursor.close();
            throw e;
        }
    }

    @Override
    public boolean supportsUpdateRowId(TableToken tableToken) {
        return this.dataFrameCursorFactory.supportTableRowId(tableToken);
    }

    @Override
    protected void _close() {
        Misc.free(this.dataFrameCursorFactory);
    }

    protected abstract RecordCursor getCursorInstance(DataFrameCursor var1, SqlExecutionContext var2) throws SqlException;
}

