/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.groupby.InterpolationGroupByFunction;
import io.questdb.std.BinarySequence;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;

public class SplitVirtualRecord
implements Record {
    private final ObjList<? extends Function> functionsA;
    private final ObjList<? extends Function> functionsB;
    private final ObjList<InterpolationGroupByFunction> interpolations = new ObjList();
    private Record base;
    private ObjList<? extends Function> current;

    public SplitVirtualRecord(ObjList<? extends Function> functionsA, ObjList<? extends Function> functionsB) {
        this.current = functionsA;
        this.functionsA = functionsA;
        this.functionsB = functionsB;
        int n = functionsB.size();
        for (int i = 0; i < n; ++i) {
            Function f = functionsB.get(i);
            if (!(f instanceof InterpolationGroupByFunction)) continue;
            this.interpolations.add((InterpolationGroupByFunction)f);
        }
    }

    @Override
    public BinarySequence getBin(int col) {
        return this.getFunction(col).getBin(this.base);
    }

    @Override
    public long getBinLen(int col) {
        BinarySequence sequence = this.getBin(col);
        if (sequence == null) {
            return -1L;
        }
        return sequence.length();
    }

    @Override
    public boolean getBool(int col) {
        return this.getFunction(col).getBool(this.base);
    }

    @Override
    public byte getByte(int col) {
        return this.getFunction(col).getByte(this.base);
    }

    @Override
    public char getChar(int col) {
        return this.getFunction(col).getChar(this.base);
    }

    @Override
    public long getDate(int col) {
        return this.getFunction(col).getDate(this.base);
    }

    @Override
    public double getDouble(int col) {
        return this.getFunction(col).getDouble(this.base);
    }

    @Override
    public float getFloat(int col) {
        return this.getFunction(col).getFloat(this.base);
    }

    @Override
    public byte getGeoByte(int col) {
        return this.getFunction(col).getGeoByte(this.base);
    }

    @Override
    public int getGeoInt(int col) {
        return this.getFunction(col).getGeoInt(this.base);
    }

    @Override
    public long getGeoLong(int col) {
        return this.getFunction(col).getGeoLong(this.base);
    }

    @Override
    public short getGeoShort(int col) {
        return this.getFunction(col).getGeoShort(this.base);
    }

    @Override
    public int getInt(int col) {
        return this.getFunction(col).getInt(this.base);
    }

    @Override
    public long getLong(int col) {
        return this.getFunction(col).getLong(this.base);
    }

    @Override
    public long getLong128Hi(int col) {
        return this.getFunction(col).getLong128Hi(this.base);
    }

    @Override
    public long getLong128Lo(int col) {
        return this.getFunction(col).getLong128Lo(this.base);
    }

    @Override
    public Record getRecord(int col) {
        return this.getFunction(col).getRecord(this.base);
    }

    @Override
    public long getRowId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getShort(int col) {
        return this.getFunction(col).getShort(this.base);
    }

    @Override
    public CharSequence getStr(int col) {
        return this.getFunction(col).getStr(this.base);
    }

    @Override
    public void getStr(int col, CharSink sink) {
        this.getFunction(col).getStr(this.base, sink);
    }

    @Override
    public CharSequence getStrB(int col) {
        return this.getFunction(col).getStrB(this.base);
    }

    @Override
    public int getStrLen(int col) {
        return this.getFunction(col).getStrLen(this.base);
    }

    @Override
    public CharSequence getSym(int col) {
        return this.getFunction(col).getSymbol(this.base);
    }

    @Override
    public CharSequence getSymB(int col) {
        return this.getFunction(col).getSymbolB(this.base);
    }

    @Override
    public long getTimestamp(int col) {
        return this.getFunction(col).getTimestamp(this.base);
    }

    public void setActiveA() {
        this.current = this.functionsA;
        int n = this.interpolations.size();
        for (int i = 0; i < n; ++i) {
            this.interpolations.get(i).stopInterpolating();
        }
    }

    public void setActiveB() {
        this.current = this.functionsB;
    }

    public void setActiveB(long startTime, long currentTime, long endTime) {
        this.current = this.functionsB;
        int n = this.interpolations.size();
        for (int i = 0; i < n; ++i) {
            this.interpolations.get(i).startInterpolating(startTime, currentTime, endTime);
        }
    }

    public void setTarget(Record target) {
        int n = this.interpolations.size();
        for (int i = 0; i < n; ++i) {
            this.interpolations.get(i).setTarget(target);
        }
    }

    private Function getFunction(int columnIndex) {
        return this.current.getQuick(columnIndex);
    }

    void of(Record record) {
        this.base = record;
    }
}

