/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.str;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.constants.StrConstant;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;
import org.jetbrains.annotations.NotNull;

public class ReplaceStrFunctionFactory
implements FunctionFactory {
    private static final String SIGNATURE = "replace(SSS)";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        int len;
        Function value;
        Function withWhat = args.getQuick(2);
        if (withWhat.isConstant() && withWhat.getStrLen(null) < 0) {
            return StrConstant.NULL;
        }
        Function term = args.getQuick(1);
        if (term.isConstant()) {
            if (term.getStrLen(null) < 0) {
                return StrConstant.NULL;
            }
            if (term.getStrLen(null) == 0) {
                return args.getQuick(0);
            }
        }
        if ((value = args.getQuick(0)).isConstant() && (len = value.getStrLen(null)) < 1) {
            return value;
        }
        int maxLength = configuration.getStrFunctionMaxBufferLength();
        return new Func(value, term, withWhat, maxLength);
    }

    private static class Func
    extends StrFunction {
        private final int maxLength;
        private final Function newSubStr;
        private final Function oldSubStr;
        private final StringSink sink = new StringSink();
        private final StringSink sinkB = new StringSink();
        private final Function value;

        public Func(Function value, Function oldSubStr, Function newSubStr, int maxLength) {
            this.value = value;
            this.oldSubStr = oldSubStr;
            this.newSubStr = newSubStr;
            this.maxLength = maxLength;
        }

        @Override
        public CharSequence getStr(Record rec) {
            CharSequence value = this.value.getStr(rec);
            if (value != null) {
                this.sink.clear();
                return (CharSequence)((Object)this.replace(value, this.oldSubStr.getStr(rec), this.newSubStr.getStr(rec), this.sink));
            }
            return null;
        }

        @Override
        public void getStr(Record rec, CharSink sink) {
            CharSequence value = this.value.getStrB(rec);
            if (value != null) {
                this.replace(value, this.oldSubStr.getStr(rec), this.newSubStr.getStr(rec), sink);
            }
        }

        @Override
        public CharSequence getStrB(Record rec) {
            CharSequence value = this.value.getStrB(rec);
            if (value != null) {
                this.sinkB.clear();
                return (CharSequence)((Object)this.replace(value, this.oldSubStr.getStrB(rec), this.newSubStr.getStrB(rec), this.sinkB));
            }
            return null;
        }

        @Override
        public boolean isConstant() {
            return this.value.isConstant() && this.oldSubStr.isConstant() && this.newSubStr.isConstant();
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("replace(").val(this.value).val(',').val(this.oldSubStr).val(',').val(this.newSubStr).val(')');
        }

        private void checkLengthLimit(int length) {
            if (length > this.maxLength) {
                throw CairoException.nonCritical().put("breached memory limit set for ").put(ReplaceStrFunctionFactory.SIGNATURE).put(" [maxLength=").put(this.maxLength).put(", requiredLength=").put(length).put(']');
            }
        }

        private CharSink replace(@NotNull CharSequence value, CharSequence term, CharSequence withWhat, CharSink sink) throws CairoException {
            int valueLen = value.length();
            if (valueLen < 1) {
                return sink;
            }
            if (term == null || withWhat == null) {
                return null;
            }
            this.checkLengthLimit(valueLen);
            int termLen = term.length();
            if (termLen < 1) {
                sink.put(value);
                return sink;
            }
            int replLen = withWhat.length();
            int curLen = 0;
            block0: for (int i = 0; i < valueLen; ++i) {
                char c = value.charAt(i);
                if (c == term.charAt(0)) {
                    if (valueLen - i < termLen) {
                        this.checkLengthLimit(++curLen);
                        sink.put(value, i, valueLen);
                        break;
                    }
                    for (int k = 1; k < termLen; ++k) {
                        if (value.charAt(i + k) == term.charAt(k)) continue;
                        this.checkLengthLimit(++curLen);
                        sink.put(c);
                        continue block0;
                    }
                    this.checkLengthLimit(curLen += replLen);
                    sink.put(withWhat);
                    i += termLen - 1;
                    continue;
                }
                this.checkLengthLimit(++curLen);
                sink.put(c);
            }
            return sink;
        }
    }
}

