/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class SubLongFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "-(LL)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration1, SqlExecutionContext sqlExecutionContext) {
        return new SubtractIntVVFunc(args.getQuick(0), args.getQuick(1));
    }

    private static class SubtractIntVVFunc
    extends LongFunction
    implements BinaryFunction {
        final Function left;
        final Function right;

        public SubtractIntVVFunc(Function left, Function right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public long getLong(Record rec) {
            long l = this.left.getLong(rec);
            long r = this.right.getLong(rec);
            if (l != Long.MIN_VALUE && r != Long.MIN_VALUE) {
                return l - r;
            }
            return Long.MIN_VALUE;
        }

        @Override
        public Function getRight() {
            return this.right;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.left).val('-').val(this.right);
        }
    }
}

