/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class CursorDereferenceFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return ".(Rs)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        CharSequence columnName;
        Function cursorFunction = args.getQuick(0);
        Function columnNameFunction = args.getQuick(1);
        RecordMetadata metadata = cursorFunction.getMetadata();
        int columnIndex = metadata.getColumnIndexQuiet(columnName = columnNameFunction.getStr(null));
        if (columnIndex == -1) {
            throw SqlException.invalidColumn(argPositions.getQuick(1), columnName);
        }
        int columnType = metadata.getColumnType(columnIndex);
        if (ColumnType.isInt(columnType)) {
            return new IntColumnFunction(cursorFunction, columnNameFunction, columnIndex);
        }
        throw SqlException.$(argPositions.getQuick(1), "unsupported column type: ").put(ColumnType.nameOf(columnType));
    }

    private static class IntColumnFunction
    extends IntFunction
    implements BinaryFunction {
        private final int columnIndex;
        private final Function columnNameFunction;
        private final Function cursorFunction;

        public IntColumnFunction(Function cursorFunction, Function columnNameFunction, int columnIndex) {
            this.cursorFunction = cursorFunction;
            this.columnNameFunction = columnNameFunction;
            this.columnIndex = columnIndex;
        }

        @Override
        public int getInt(Record rec) {
            return this.cursorFunction.getRecord(rec).getInt(this.columnIndex);
        }

        @Override
        public Function getLeft() {
            return this.cursorFunction;
        }

        @Override
        public String getName() {
            return ".";
        }

        @Override
        public Function getRight() {
            return this.columnNameFunction;
        }

        @Override
        public boolean isOperator() {
            return true;
        }
    }
}

