/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToLong256Function;
import io.questdb.std.IntList;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;

public class CastSymbolToLong256FunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Kh)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(args.getQuick(0));
    }

    static void appendLong256(CharSequence value, Long256Impl long256Builder, CharSink sink) {
        if (Numbers.extractLong256(value, value.length(), long256Builder)) {
            Numbers.appendLong256(long256Builder.getLong0(), long256Builder.getLong1(), long256Builder.getLong2(), long256Builder.getLong3(), sink);
        }
    }

    private static class Func
    extends AbstractCastToLong256Function {
        private final Long256Impl long256a = new Long256Impl();
        private final Long256Impl long256b = new Long256Impl();
        private final Long256Impl long256builder = new Long256Impl();

        public Func(Function arg) {
            super(arg);
        }

        @Override
        public void getLong256(Record rec, CharSink sink) {
            CharSequence value = this.arg.getSymbol(rec);
            if (value != null) {
                CastSymbolToLong256FunctionFactory.appendLong256(value, this.long256builder, sink);
            }
        }

        @Override
        public Long256 getLong256A(Record rec) {
            CharSequence value = this.arg.getSymbol(rec);
            if (value == null) {
                return Long256Impl.NULL_LONG256;
            }
            return Numbers.parseLong256(value, value.length(), this.long256a);
        }

        @Override
        public Long256 getLong256B(Record rec) {
            CharSequence value = this.arg.getSymbol(rec);
            if (value == null) {
                return Long256Impl.NULL_LONG256;
            }
            return Numbers.parseLong256(value, value.length(), this.long256b);
        }
    }
}

