/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.std.IntList;
import io.questdb.std.LongLongHashSet;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.Uuid;

public final class InUuidFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "in(Zv)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        int n = args.size();
        LongLongHashSet set = new LongLongHashSet(n - 1, 0.6, Long.MIN_VALUE, LongLongHashSet.UUID_STRATEGY);
        block6: for (int i = 1; i < n; ++i) {
            Function func = args.getQuick(i);
            switch (ColumnType.tagOf(func.getType())) {
                case 11: 
                case 12: 
                case 29: {
                    CharSequence value = func.getStr(null);
                    if (value == null) {
                        throw SqlException.$(argPositions.getQuick(i), "NULL is not allowed in IN list");
                    }
                    try {
                        Uuid.checkDashesAndLength(value);
                        set.add(Uuid.parseLo(value), Uuid.parseHi(value));
                    }
                    catch (NumericException numericException) {}
                    continue block6;
                }
                case 19: {
                    long lo = func.getLong128Lo(null);
                    long hi = func.getLong128Hi(null);
                    if (hi == Long.MIN_VALUE && lo == Long.MIN_VALUE) {
                        throw SqlException.$(argPositions.getQuick(i), "NULL is not allowed in IN list");
                    }
                    set.add(lo, hi);
                    continue block6;
                }
                default: {
                    throw SqlException.$(argPositions.getQuick(i), "STRING or UUID constant expected in IN list");
                }
            }
        }
        Function var = args.getQuick(0);
        if (var.isConstant()) {
            long hi;
            long lo = var.getLong128Lo(null);
            if (Uuid.isNull(lo, hi = var.getLong128Hi(null))) {
                return BooleanConstant.FALSE;
            }
            return BooleanConstant.of(set.contains(lo, hi));
        }
        return new Func(var, set);
    }

    private static class Func
    extends BooleanFunction
    implements UnaryFunction {
        private final Function arg;
        private final LongLongHashSet set;

        public Func(Function arg, LongLongHashSet set) {
            this.arg = arg;
            this.set = set;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            long hi;
            long lo = this.arg.getLong128Lo(rec);
            if (Uuid.isNull(lo, hi = this.arg.getLong128Hi(rec))) {
                return false;
            }
            return this.set.contains(lo, hi);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arg).val(" in ").val(this.set);
        }
    }
}

