/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.Chars;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class InSymbolCursorFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "in(KC)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Record.CharSequenceFunction func;
        SymbolFunction symbolFunction = (SymbolFunction)args.getQuick(0);
        Function cursorFunction = args.getQuick(1);
        int zeroColumnType = cursorFunction.getRecordCursorFactory().getMetadata().getColumnType(0);
        if (!ColumnType.isSymbolOrString(zeroColumnType)) {
            throw SqlException.position(position).put("supported column types are STRING and SYMBOL, found: ").put(ColumnType.nameOf(zeroColumnType));
        }
        Record.CharSequenceFunction charSequenceFunction = func = ColumnType.isString(zeroColumnType) ? Record.GET_STR : Record.GET_SYM;
        if (symbolFunction.isSymbolTableStatic()) {
            return new SymbolInCursorFunction(symbolFunction, cursorFunction, func);
        }
        return new StrInCursorFunction(symbolFunction, cursorFunction, func);
    }

    private static class SymbolInCursorFunction
    extends BooleanFunction
    implements BinaryFunction {
        private final Function cursorArg;
        private final Record.CharSequenceFunction func;
        private final IntHashSet symbolKeys = new IntHashSet();
        private final SymbolFunction valueArg;

        public SymbolInCursorFunction(SymbolFunction valueArg, Function cursorArg, Record.CharSequenceFunction func) {
            this.valueArg = valueArg;
            this.cursorArg = cursorArg;
            this.func = func;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.symbolKeys.keyIndex(this.valueArg.getInt(rec) + 1) < 0;
        }

        @Override
        public Function getLeft() {
            return this.valueArg;
        }

        @Override
        public Function getRight() {
            return this.cursorArg;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            this.valueArg.init(symbolTableSource, executionContext);
            this.cursorArg.init(symbolTableSource, executionContext);
            this.symbolKeys.clear();
            StaticSymbolTable symbolTable = this.valueArg.getStaticSymbolTable();
            assert (symbolTable != null);
            RecordCursorFactory factory = this.cursorArg.getRecordCursorFactory();
            try (RecordCursor cursor = factory.getCursor(executionContext);){
                Record record = cursor.getRecord();
                while (cursor.hasNext()) {
                    int key = symbolTable.keyOf(this.func.get(record, 0));
                    if (key == -2) continue;
                    this.symbolKeys.add(key + 1);
                }
            }
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.valueArg).val(" in ").val(this.cursorArg);
        }
    }

    private static class StrInCursorFunction
    extends BooleanFunction
    implements BinaryFunction {
        private final Function cursorArg;
        private final Record.CharSequenceFunction func;
        private final Function valueArg;
        private final CharSequenceHashSet valueSetA = new CharSequenceHashSet();
        private final CharSequenceHashSet valueSetB = new CharSequenceHashSet();
        private CharSequenceHashSet valueSet;

        public StrInCursorFunction(Function valueArg, Function cursorArg, Record.CharSequenceFunction func) {
            this.valueArg = valueArg;
            this.cursorArg = cursorArg;
            this.valueSet = this.valueSetA;
            this.func = func;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.valueSet.contains(this.valueArg.getSymbol(rec));
        }

        @Override
        public Function getLeft() {
            return this.valueArg;
        }

        @Override
        public Function getRight() {
            return this.cursorArg;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            this.valueArg.init(symbolTableSource, executionContext);
            this.cursorArg.init(symbolTableSource, executionContext);
            CharSequenceHashSet valueSet = this.valueSet == this.valueSetA ? this.valueSetB : this.valueSetA;
            valueSet.clear();
            RecordCursorFactory factory = this.cursorArg.getRecordCursorFactory();
            try (RecordCursor cursor = factory.getCursor(executionContext);){
                Record record = cursor.getRecord();
                while (cursor.hasNext()) {
                    CharSequence value = this.func.get(record, 0);
                    if (value == null) {
                        valueSet.addNull();
                        continue;
                    }
                    int toIndex = valueSet.keyIndex(value);
                    if (toIndex <= -1) continue;
                    int index = this.valueSet.keyIndex(value);
                    if (index < 0) {
                        valueSet.addAt(toIndex, this.valueSet.keyAt(index));
                        continue;
                    }
                    valueSet.addAt(toIndex, Chars.toString(value));
                }
            }
            this.valueSet = valueSet;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.valueArg).val(" in ").val(this.cursorArg);
        }
    }
}

