/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text.types;

import io.questdb.cairo.TableWriter;
import io.questdb.cutlass.text.types.AbstractTypeAdapter;
import io.questdb.std.NumericException;
import io.questdb.std.Uuid;
import io.questdb.std.str.DirectByteCharSequence;

public final class UuidAdapter
extends AbstractTypeAdapter {
    public static final UuidAdapter INSTANCE = new UuidAdapter();

    private UuidAdapter() {
    }

    @Override
    public int getType() {
        return 19;
    }

    @Override
    public boolean probe(DirectByteCharSequence text) {
        try {
            Uuid.checkDashesAndLength(text);
            Uuid.parseHi(text);
            Uuid.parseLo(text);
        }
        catch (NumericException e) {
            return false;
        }
        return true;
    }

    @Override
    public void write(TableWriter.Row row, int column, DirectByteCharSequence value) throws Exception {
        row.putUuid(column, value);
    }
}

