/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.pgwire;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CairoSecurityContext;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.GeoHashes;
import io.questdb.cairo.ImplicitCastException;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.TableWriterAPI;
import io.questdb.cairo.pool.WriterSource;
import io.questdb.cairo.security.AllowAllCairoSecurityContext;
import io.questdb.cairo.sql.BindVariableService;
import io.questdb.cairo.sql.NetworkSqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.OperationFuture;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.TableRecordMetadata;
import io.questdb.cairo.sql.TableReferenceOutOfDateException;
import io.questdb.cutlass.pgwire.AuthenticationException;
import io.questdb.cutlass.pgwire.BadProtocolException;
import io.questdb.cutlass.pgwire.PGAuthenticator;
import io.questdb.cutlass.pgwire.PGBasicAuthenticator;
import io.questdb.cutlass.pgwire.PGOids;
import io.questdb.cutlass.pgwire.PGWireConfiguration;
import io.questdb.cutlass.pgwire.TypesAndInsert;
import io.questdb.cutlass.pgwire.TypesAndSelect;
import io.questdb.cutlass.pgwire.TypesAndUpdate;
import io.questdb.cutlass.text.TextLoader;
import io.questdb.cutlass.text.types.TypeManager;
import io.questdb.griffin.BatchCallback;
import io.questdb.griffin.CharacterStore;
import io.questdb.griffin.CharacterStoreEntry;
import io.questdb.griffin.CompiledQuery;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContextImpl;
import io.questdb.griffin.SqlTimeoutException;
import io.questdb.griffin.engine.functions.bind.BindVariableServiceImpl;
import io.questdb.griffin.engine.ops.UpdateOperation;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.SCSequence;
import io.questdb.network.AbstractMutableIOContext;
import io.questdb.network.IODispatcher;
import io.questdb.network.Net;
import io.questdb.network.NetworkFacade;
import io.questdb.network.NoSpaceLeftInResponseBufferException;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.network.PeerIsSlowToWriteException;
import io.questdb.network.QueryPausedException;
import io.questdb.network.SuspendEvent;
import io.questdb.std.AssociativeCache;
import io.questdb.std.BinarySequence;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.DirectBinarySequence;
import io.questdb.std.IntList;
import io.questdb.std.Long256;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.ObjObjHashMap;
import io.questdb.std.ObjectPool;
import io.questdb.std.Rnd;
import io.questdb.std.Unsafe;
import io.questdb.std.Uuid;
import io.questdb.std.Vect;
import io.questdb.std.WeakMutableObjectPool;
import io.questdb.std.WeakSelfReturningObjectPool;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.datetime.millitime.DateFormatUtils;
import io.questdb.std.str.AbstractCharSink;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.DirectByteCharSequence;
import io.questdb.std.str.DirectCharSink;
import io.questdb.std.str.Path;
import io.questdb.std.str.StdoutSink;
import java.util.Iterator;
import org.jetbrains.annotations.Nullable;

public class PGConnectionContext
extends AbstractMutableIOContext<PGConnectionContext>
implements WriterSource {
    public static final char STATUS_IDLE = 'I';
    public static final char STATUS_IN_ERROR = 'E';
    public static final char STATUS_IN_TRANSACTION = 'T';
    public static final String TAG_BEGIN = "BEGIN";
    public static final String TAG_COMMIT = "COMMIT";
    public static final String TAG_COPY = "COPY";
    public static final String TAG_CTAS = "CTAS";
    public static final String TAG_DEALLOCATE = "DEALLOCATE";
    public static final String TAG_EXPLAIN = "EXPLAIN";
    public static final String TAG_INSERT = "INSERT";
    public static final String TAG_OK = "OK";
    public static final String TAG_ROLLBACK = "ROLLBACK";
    public static final String TAG_SELECT = "SELECT";
    public static final String TAG_SET = "SET";
    public static final String TAG_UPDATE = "UPDATE";
    private static final int COMMIT_TRANSACTION = 2;
    private static final int ERROR_TRANSACTION = 3;
    private static final int INIT_CANCEL_REQUEST = 80877102;
    private static final int INIT_GSS_REQUEST = 80877104;
    private static final int INIT_SSL_REQUEST = 80877103;
    private static final int INIT_STARTUP_MESSAGE = 196608;
    private static final int INT_BYTES_X = Numbers.bswap(4);
    private static final int INT_NULL_X = Numbers.bswap(-1);
    private static final int IN_TRANSACTION = 1;
    private static final Log LOG = LogFactory.getLog(PGConnectionContext.class);
    private static final byte MESSAGE_TYPE_BIND_COMPLETE = 50;
    private static final byte MESSAGE_TYPE_CLOSE_COMPLETE = 51;
    private static final byte MESSAGE_TYPE_COMMAND_COMPLETE = 67;
    private static final byte MESSAGE_TYPE_COPY_IN_RESPONSE = 71;
    private static final byte MESSAGE_TYPE_DATA_ROW = 68;
    private static final byte MESSAGE_TYPE_EMPTY_QUERY = 73;
    private static final byte MESSAGE_TYPE_ERROR_RESPONSE = 69;
    private static final byte MESSAGE_TYPE_LOGIN_RESPONSE = 82;
    private static final byte MESSAGE_TYPE_NO_DATA = 110;
    private static final byte MESSAGE_TYPE_PARAMETER_DESCRIPTION = 116;
    private static final byte MESSAGE_TYPE_PARAMETER_STATUS = 83;
    private static final byte MESSAGE_TYPE_PARSE_COMPLETE = 49;
    private static final byte MESSAGE_TYPE_PORTAL_SUSPENDED = 115;
    private static final byte MESSAGE_TYPE_READY_FOR_QUERY = 90;
    private static final byte MESSAGE_TYPE_ROW_DESCRIPTION = 84;
    private static final int NO_TRANSACTION = 0;
    private static final int PREFIXED_MESSAGE_HEADER_LEN = 5;
    private static final int PROTOCOL_TAIL_COMMAND_LENGTH = 64;
    private static final int ROLLING_BACK_TRANSACTION = 4;
    private static final int SYNC_BIND = 3;
    private static final int SYNC_DESCRIBE = 2;
    private static final int SYNC_DESCRIBE_PORTAL = 4;
    private static final int SYNC_PARSE = 1;
    private static final String WRITER_LOCK_REASON = "pgConnection";
    private final PGAuthenticator authenticator;
    private final BatchCallback batchCallback;
    private final ObjectPool<DirectBinarySequence> binarySequenceParamsPool;
    private final IntList bindSelectColumnFormats;
    private final IntList bindVariableTypes = new IntList();
    private final CharacterStore characterStore;
    private final NetworkSqlExecutionCircuitBreaker circuitBreaker;
    private final DirectByteCharSequence dbcs = new DirectByteCharSequence();
    private final boolean dumpNetworkTraffic;
    private final CairoEngine engine;
    private final int maxBlobSizeOnQuery;
    private final CharSequenceObjHashMap<Portal> namedPortalMap;
    private final WeakMutableObjectPool<Portal> namedPortalPool;
    private final CharSequenceObjHashMap<NamedStatementWrapper> namedStatementMap;
    private final WeakMutableObjectPool<NamedStatementWrapper> namedStatementWrapperPool;
    private final NetworkFacade nf;
    private final Path path = new Path();
    private final ObjObjHashMap<TableToken, TableWriterAPI> pendingWriters;
    private final int recvBufferSize;
    private final ResponseAsciiSink responseAsciiSink = new ResponseAsciiSink();
    @Nullable
    private final PGAuthenticator roUserAuthenticator;
    private final IntList selectColumnTypes = new IntList();
    private final int sendBufferSize;
    private final String serverVersion;
    private final IntList syncActions = new IntList(4);
    private final SCSequence tempSequence = new SCSequence();
    private final TypeManager typeManager;
    private final AssociativeCache<TypesAndInsert> typesAndInsertCache;
    private final WeakSelfReturningObjectPool<TypesAndInsert> typesAndInsertPool;
    private final DirectCharSink utf8Sink;
    private IntList activeBindVariableTypes;
    private IntList activeSelectColumnTypes;
    private boolean authenticationRequired = true;
    private BindVariableService bindVariableService;
    private int bufferRemainingOffset = 0;
    private int bufferRemainingSize = 0;
    private boolean completed = true;
    private RecordCursor currentCursor = null;
    private RecordCursorFactory currentFactory = null;
    private boolean isEmptyQuery = false;
    private boolean isPausedQuery = false;
    private long maxRows;
    private int parsePhaseBindVariableCount;
    private CharSequence queryTag;
    private CharSequence queryText;
    private long recvBuffer;
    private long recvBufferReadOffset = 0L;
    private long recvBufferWriteOffset = 0L;
    private boolean requireInitialMessage = true;
    private PGResumeProcessor resumeProcessor;
    private Rnd rnd;
    private long rowCount;
    private long sendBuffer;
    private long sendBufferLimit;
    private long sendBufferPtr;
    private final PGResumeProcessor resumeCommandCompleteRef = this::resumeCommandComplete;
    private boolean sendParameterDescription;
    private boolean sendRNQ = true;
    private SqlExecutionContextImpl sqlExecutionContext;
    private long statementTimeout = -1L;
    private SuspendEvent suspendEvent;
    private long totalReceived = 0L;
    private int transactionState = 0;
    private final PGResumeProcessor resumeQueryCompleteRef = this::resumeQueryComplete;
    private final PGResumeProcessor resumeCursorQueryRef = this::resumeCursorQuery;
    private TypesAndInsert typesAndInsert = null;
    private TypesAndSelect typesAndSelect = null;
    private AssociativeCache<TypesAndSelect> typesAndSelectCache;
    private boolean typesAndSelectIsCached = true;
    private WeakSelfReturningObjectPool<TypesAndSelect> typesAndSelectPool;
    private TypesAndUpdate typesAndUpdate = null;
    private AssociativeCache<TypesAndUpdate> typesAndUpdateCache;
    private boolean typesAndUpdateIsCached = false;
    private final PGResumeProcessor resumeCursorExecuteRef = this::resumeCursorExecute;
    private WeakSelfReturningObjectPool<TypesAndUpdate> typesAndUpdatePool;
    private CharSequence username;
    private NamedStatementWrapper wrapper;

    public PGConnectionContext(CairoEngine engine, PGWireConfiguration configuration, SqlExecutionContextImpl sqlExecutionContext) {
        this.engine = engine;
        this.utf8Sink = new DirectCharSink(engine.getConfiguration().getTextConfiguration().getUtf8SinkSize());
        this.typeManager = new TypeManager(engine.getConfiguration().getTextConfiguration(), this.utf8Sink);
        this.nf = configuration.getNetworkFacade();
        this.bindVariableService = new BindVariableServiceImpl(engine.getConfiguration());
        this.recvBufferSize = Numbers.ceilPow2(configuration.getRecvBufferSize());
        this.sendBufferSize = Numbers.ceilPow2(configuration.getSendBufferSize());
        this.characterStore = new CharacterStore(configuration.getCharacterStoreCapacity(), configuration.getCharacterStorePoolCapacity());
        this.maxBlobSizeOnQuery = configuration.getMaxBlobSizeOnQuery();
        this.dumpNetworkTraffic = configuration.getDumpNetworkTraffic();
        this.serverVersion = configuration.getServerVersion();
        this.authenticator = new PGBasicAuthenticator(configuration.getDefaultUsername(), configuration.getDefaultPassword(), configuration.readOnlySecurityContext());
        this.roUserAuthenticator = configuration.isReadOnlyUserEnabled() ? new PGBasicAuthenticator(configuration.getReadOnlyUsername(), configuration.getReadOnlyPassword(), true) : null;
        this.sqlExecutionContext = sqlExecutionContext;
        this.rnd = configuration.getRandom();
        this.sqlExecutionContext.setRandom(this.rnd);
        this.namedStatementWrapperPool = new WeakMutableObjectPool<NamedStatementWrapper>(NamedStatementWrapper::new, configuration.getNamesStatementPoolCapacity());
        this.namedPortalPool = new WeakMutableObjectPool<Portal>(Portal::new, configuration.getNamesStatementPoolCapacity());
        this.namedStatementMap = new CharSequenceObjHashMap(configuration.getNamedStatementCacheCapacity());
        this.pendingWriters = new ObjObjHashMap(configuration.getPendingWritersCacheSize());
        this.namedPortalMap = new CharSequenceObjHashMap(configuration.getNamedStatementCacheCapacity());
        this.binarySequenceParamsPool = new ObjectPool<DirectBinarySequence>(DirectBinarySequence::new, configuration.getBinParamCountCapacity());
        this.circuitBreaker = new NetworkSqlExecutionCircuitBreaker(configuration.getCircuitBreakerConfiguration(), 32);
        this.typesAndInsertPool = new WeakSelfReturningObjectPool<TypesAndInsert>(TypesAndInsert::new, configuration.getInsertPoolCapacity());
        boolean enableInsertCache = configuration.isInsertCacheEnabled();
        int insertBlockCount = enableInsertCache ? configuration.getInsertCacheBlockCount() : 1;
        int insertRowCount = enableInsertCache ? configuration.getInsertCacheRowCount() : 1;
        this.typesAndInsertCache = new AssociativeCache(insertBlockCount, insertRowCount);
        this.batchCallback = new PGConnectionBatchCallback();
        this.bindSelectColumnFormats = new IntList();
        this.queryTag = TAG_OK;
    }

    public static int getInt(long address, long msgLimit, CharSequence errorMessage) throws BadProtocolException {
        if (address + 4L <= msgLimit) {
            return PGConnectionContext.getIntUnsafe(address);
        }
        LOG.error().$(errorMessage).$();
        throw BadProtocolException.INSTANCE;
    }

    public static long getLongUnsafe(long address) {
        return Numbers.bswap(Unsafe.getUnsafe().getLong(address));
    }

    public static short getShort(long address, long msgLimit, CharSequence errorMessage) throws BadProtocolException {
        if (address + 2L <= msgLimit) {
            return PGConnectionContext.getShortUnsafe(address);
        }
        LOG.error().$(errorMessage).$();
        throw BadProtocolException.INSTANCE;
    }

    public static long getStringLength(long x, long limit, CharSequence errorMessage) throws BadProtocolException {
        long len;
        long l = len = Unsafe.getUnsafe().getByte(x) == 0 ? x : PGConnectionContext.getStringLengthTedious(x, limit);
        if (len > -1L) {
            return len;
        }
        LOG.error().$(errorMessage).$();
        throw BadProtocolException.INSTANCE;
    }

    public static long getStringLengthTedious(long x, long limit) {
        for (long i = x; i < limit; ++i) {
            if (Unsafe.getUnsafe().getByte(i) != 0) continue;
            return i;
        }
        return -1L;
    }

    public static void putInt(long address, int value) {
        Unsafe.getUnsafe().putInt(address, Numbers.bswap(value));
    }

    public static void putLong(long address, long value) {
        Unsafe.getUnsafe().putLong(address, Numbers.bswap(value));
    }

    public static void putShort(long address, short value) {
        Unsafe.getUnsafe().putShort(address, Numbers.bswap(value));
    }

    @Override
    public void clear() {
        this.sendBufferPtr = this.sendBuffer;
        this.requireInitialMessage = true;
        this.bufferRemainingOffset = 0;
        this.bufferRemainingSize = 0;
        this.responseAsciiSink.reset();
        this.prepareForNewQuery();
        this.authenticationRequired = true;
        this.username = null;
        this.typeManager.clear();
        this.clearWriters();
        this.clearRecvBuffer();
        this.typesAndInsertCache.clear();
        this.evictNamedStatementWrappersAndClear();
        this.namedPortalMap.clear();
        this.bindVariableService.clear();
        this.bindVariableTypes.clear();
        this.binarySequenceParamsPool.clear();
        this.resumeProcessor = null;
        this.completed = true;
        this.clearCursorAndFactory();
        this.totalReceived = 0L;
        this.typesAndSelectIsCached = true;
        this.typesAndUpdateIsCached = false;
        this.statementTimeout = -1L;
        this.circuitBreaker.resetMaxTimeToDefault();
        this.circuitBreaker.unsetTimer();
        this.isPausedQuery = false;
        this.isEmptyQuery = false;
        this.clearSuspendEvent();
    }

    @Override
    public void clearSuspendEvent() {
        this.suspendEvent = Misc.free(this.suspendEvent);
    }

    public void clearWriters() {
        this.closePendingWriters(false);
        this.pendingWriters.clear();
    }

    @Override
    public void close() {
        this.typesAndSelectIsCached = false;
        this.typesAndUpdateIsCached = false;
        this.clear();
        this.fd = -1;
        this.sqlExecutionContext.with(AllowAllCairoSecurityContext.INSTANCE, null, null, -1L, null);
        Misc.free(this.path);
        Misc.free(this.utf8Sink);
        Misc.free(this.circuitBreaker);
        this.freeBuffers();
    }

    @Override
    public SuspendEvent getSuspendEvent() {
        return this.suspendEvent;
    }

    @Override
    public TableWriterAPI getTableWriterAPI(CairoSecurityContext context, TableToken tableToken, String lockReason) {
        int index = this.pendingWriters.keyIndex(tableToken);
        if (index < 0) {
            return this.pendingWriters.valueAt(index);
        }
        return this.engine.getTableWriterAPI(context, tableToken, lockReason);
    }

    public void handleClientOperation(SqlCompiler compiler, AssociativeCache<TypesAndSelect> selectAndTypesCache, WeakSelfReturningObjectPool<TypesAndSelect> selectAndTypesPool, AssociativeCache<TypesAndUpdate> typesAndUpdateCache, WeakSelfReturningObjectPool<TypesAndUpdate> typesAndUpdatePool, int operation) throws PeerDisconnectedException, PeerIsSlowToReadException, PeerIsSlowToWriteException, QueryPausedException, BadProtocolException {
        this.typesAndSelectCache = selectAndTypesCache;
        this.typesAndSelectPool = selectAndTypesPool;
        this.typesAndUpdateCache = typesAndUpdateCache;
        this.typesAndUpdatePool = typesAndUpdatePool;
        try {
            if (this.isPausedQuery) {
                this.isPausedQuery = false;
                if (this.resumeProcessor != null) {
                    this.resumeProcessor.resume(true);
                }
            } else if (this.bufferRemainingSize > 0) {
                this.doSend(this.bufferRemainingOffset, this.bufferRemainingSize);
                if (this.resumeProcessor != null) {
                    this.resumeProcessor.resume(false);
                }
            }
            boolean keepReceiving = true;
            block5: do {
                if (operation == 1 && this.recv() == 0) {
                    keepReceiving = false;
                }
                if (!keepReceiving) continue;
                do {
                    long readOffsetBeforeParse = this.recvBufferReadOffset;
                    this.totalReceived += this.recvBufferWriteOffset - this.recvBufferReadOffset;
                    this.parse(this.recvBuffer + this.recvBufferReadOffset, (int)(this.recvBufferWriteOffset - this.recvBufferReadOffset), compiler);
                    if (readOffsetBeforeParse != this.recvBufferReadOffset) continue;
                    if (readOffsetBeforeParse <= 0L) continue block5;
                    this.shiftReceiveBuffer(readOffsetBeforeParse);
                    continue block5;
                } while (this.recvBufferReadOffset < this.recvBufferWriteOffset);
                this.clearRecvBuffer();
            } while (keepReceiving && operation == 1);
        }
        catch (SqlException e) {
            this.reportNonCriticalError(e.getPosition(), e.getFlyweightMessage());
        }
        catch (ImplicitCastException e) {
            this.reportNonCriticalError(-1, e.getFlyweightMessage());
        }
        catch (CairoException e) {
            if (e.isInterruption()) {
                this.reportQueryCancelled(e.getFlyweightMessage());
            } else {
                this.reportError(e);
            }
        }
        catch (AuthenticationException e) {
            this.prepareNonCriticalError(-1, e.getMessage());
            this.sendAndReset();
            this.clearRecvBuffer();
        }
    }

    @Override
    public PGConnectionContext of(int fd, IODispatcher<PGConnectionContext> dispatcher) {
        PGConnectionContext r = (PGConnectionContext)super.of(fd, dispatcher);
        this.sqlExecutionContext.with(fd);
        if (fd == -1) {
            this.freeBuffers();
        } else {
            if (this.recvBuffer == 0L) {
                this.recvBuffer = Unsafe.malloc(this.recvBufferSize, 12);
            }
            if (this.sendBuffer == 0L) {
                this.sendBufferPtr = this.sendBuffer = Unsafe.malloc(this.sendBufferSize, 12);
                this.sendBufferLimit = this.sendBuffer + (long)this.sendBufferSize;
            }
        }
        return r;
    }

    public void setBinBindVariable(int index, long address, int valueLen) throws SqlException {
        this.bindVariableService.setBin(index, (BinarySequence)this.binarySequenceParamsPool.next().of(address, valueLen));
    }

    public void setBooleanBindVariable(int index, int valueLen) throws SqlException {
        if (valueLen != 4 && valueLen != 5) {
            throw SqlException.$(0, "bad value for BOOLEAN parameter [index=").put(index).put(", valueLen=").put(valueLen).put(']');
        }
        this.bindVariableService.setBoolean(index, valueLen == 4);
    }

    public void setCharBindVariable(int index, long address, int valueLen) throws BadProtocolException, SqlException {
        CharacterStoreEntry e = this.characterStore.newEntry();
        if (!Chars.utf8Decode(address, address + (long)valueLen, e)) {
            LOG.error().$("invalid char UTF8 bytes [index=").$(index).$(']').$();
            throw BadProtocolException.INSTANCE;
        }
        this.bindVariableService.setChar(index, this.characterStore.toImmutable().charAt(0));
    }

    public void setDateBindVariable(int index, long address, int valueLen) throws SqlException {
        this.dbcs.of(address, address + (long)valueLen);
        this.bindVariableService.define(index, 7, 0);
        this.bindVariableService.setStr(index, (CharSequence)this.dbcs);
    }

    public void setDoubleBindVariable(int index, long address, int valueLen) throws BadProtocolException, SqlException {
        PGConnectionContext.ensureValueLength(index, 8, valueLen);
        this.bindVariableService.setDouble(index, Double.longBitsToDouble(PGConnectionContext.getLongUnsafe(address)));
    }

    public void setFloatBindVariable(int index, long address, int valueLen) throws BadProtocolException, SqlException {
        PGConnectionContext.ensureValueLength(index, 4, valueLen);
        this.bindVariableService.setFloat(index, Float.intBitsToFloat(PGConnectionContext.getIntUnsafe(address)));
    }

    public void setIntBindVariable(int index, long address, int valueLen) throws BadProtocolException, SqlException {
        PGConnectionContext.ensureValueLength(index, 4, valueLen);
        this.bindVariableService.setInt(index, PGConnectionContext.getIntUnsafe(address));
    }

    public void setLongBindVariable(int index, long address, int valueLen) throws BadProtocolException, SqlException {
        PGConnectionContext.ensureValueLength(index, 8, valueLen);
        this.bindVariableService.setLong(index, PGConnectionContext.getLongUnsafe(address));
    }

    public void setShortBindVariable(int index, long address, int valueLen) throws BadProtocolException, SqlException {
        PGConnectionContext.ensureValueLength(index, 2, valueLen);
        this.bindVariableService.setShort(index, PGConnectionContext.getShortUnsafe(address));
    }

    public void setStrBindVariable(int index, long address, int valueLen) throws BadProtocolException, SqlException {
        CharacterStoreEntry e = this.characterStore.newEntry();
        if (!Chars.utf8Decode(address, address + (long)valueLen, e)) {
            LOG.error().$("invalid str UTF8 bytes [index=").$(index).$(']').$();
            throw BadProtocolException.INSTANCE;
        }
        this.bindVariableService.setStr(index, this.characterStore.toImmutable());
    }

    public void setSuspendEvent(SuspendEvent suspendEvent) {
        this.suspendEvent = suspendEvent;
    }

    public void setTimestampBindVariable(int index, long address, int valueLen) throws BadProtocolException, SqlException {
        PGConnectionContext.ensureValueLength(index, 8, valueLen);
        this.bindVariableService.setTimestamp(index, PGConnectionContext.getLongUnsafe(address) + 946684800000000L);
    }

    private static void bindParameterFormats(long lo, long msgLimit, short parameterFormatCount, IntList bindVariableTypes) throws BadProtocolException {
        if (lo + (long)(2 * parameterFormatCount) <= msgLimit) {
            LOG.debug().$("processing bind formats [count=").$(parameterFormatCount).$(']').$();
            for (int i = 0; i < parameterFormatCount; ++i) {
                short code = PGConnectionContext.getShortUnsafe(lo + (long)(i * 2));
                bindVariableTypes.setQuick(i, PGOids.toParamBinaryType(code, bindVariableTypes.getQuick(i)));
            }
        } else {
            LOG.error().$("invalid format code count [value=").$(parameterFormatCount).$(']').$();
            throw BadProtocolException.INSTANCE;
        }
    }

    private static void bindSingleFormatForAll(long lo, long msgLimit, IntList activeBindVariableTypes) throws BadProtocolException {
        short code = PGConnectionContext.getShort(lo, msgLimit, "could not read parameter formats");
        int n = activeBindVariableTypes.size();
        for (int i = 0; i < n; ++i) {
            activeBindVariableTypes.setQuick(i, PGOids.toParamBinaryType(code, activeBindVariableTypes.getQuick(i)));
        }
    }

    private static void ensureValueLength(int index, int required, int actual) throws BadProtocolException {
        if (required == actual) {
            return;
        }
        LOG.error().$("bad parameter value length [required=").$(required).$(", actual=").$(actual).$(", index=").$(index).I$();
        throw BadProtocolException.INSTANCE;
    }

    private static int getIntUnsafe(long address) {
        return Numbers.bswap(Unsafe.getUnsafe().getInt(address));
    }

    private static short getShortUnsafe(long address) {
        return Numbers.bswap(Unsafe.getUnsafe().getShort(address));
    }

    private static void prepareParams(ResponseAsciiSink sink, String name, String value) {
        sink.put((byte)83);
        long addr = sink.skip();
        sink.encodeUtf8Z(name);
        sink.encodeUtf8Z(value);
        sink.putLen(addr);
    }

    private static void setupBindVariables(long lo, IntList bindVariableTypes, int count) {
        bindVariableTypes.setPos(count);
        for (int i = 0; i < count; ++i) {
            bindVariableTypes.setQuick(i, Unsafe.getUnsafe().getInt(lo + (long)i * 4L));
        }
    }

    private void appendBinColumn(Record record, int i) throws SqlException {
        BinarySequence sequence = record.getBin(i);
        if (sequence == null) {
            this.responseAsciiSink.setNullValue();
        } else {
            long blobSize = sequence.length();
            if (blobSize < (long)this.maxBlobSizeOnQuery) {
                this.responseAsciiSink.put(sequence);
            } else {
                throw SqlException.position(0).put("blob is too large [blobSize=").put(blobSize).put(", max=").put(this.maxBlobSizeOnQuery).put(", columnIndex=").put(i).put(']');
            }
        }
    }

    private void appendBooleanColumn(Record record, int columnIndex) {
        this.responseAsciiSink.putNetworkInt(1);
        this.responseAsciiSink.put(record.getBool(columnIndex) ? (char)'t' : 'f');
    }

    private void appendBooleanColumnBin(Record record, int columnIndex) {
        this.responseAsciiSink.putNetworkInt(1);
        this.responseAsciiSink.put(record.getBool(columnIndex) ? (byte)1 : 0);
    }

    private void appendByteColumn(Record record, int columnIndex) {
        long a = this.responseAsciiSink.skip();
        this.responseAsciiSink.put((int)record.getByte(columnIndex));
        this.responseAsciiSink.putLenEx(a);
    }

    private void appendByteColumnBin(Record record, int columnIndex) {
        byte value = record.getByte(columnIndex);
        this.responseAsciiSink.putNetworkInt(2);
        this.responseAsciiSink.putNetworkShort(value);
    }

    private void appendCharColumn(Record record, int columnIndex) {
        char charValue = record.getChar(columnIndex);
        if (charValue == '\u0000') {
            this.responseAsciiSink.setNullValue();
        } else {
            long a = this.responseAsciiSink.skip();
            this.responseAsciiSink.putUtf8(charValue);
            this.responseAsciiSink.putLenEx(a);
        }
    }

    private void appendDateColumn(Record record, int columnIndex) {
        long longValue = record.getDate(columnIndex);
        if (longValue != Long.MIN_VALUE) {
            long a = this.responseAsciiSink.skip();
            DateFormatUtils.PG_DATE_MILLI_TIME_Z_PRINT_FORMAT.format(longValue, null, null, this.responseAsciiSink);
            this.responseAsciiSink.putLenEx(a);
        } else {
            this.responseAsciiSink.setNullValue();
        }
    }

    private void appendDateColumnBin(Record record, int columnIndex) {
        long longValue = record.getLong(columnIndex);
        if (longValue != Long.MIN_VALUE) {
            this.responseAsciiSink.putNetworkInt(8);
            this.responseAsciiSink.putNetworkLong(longValue * 1000L - 946684800000000L);
        } else {
            this.responseAsciiSink.setNullValue();
        }
    }

    private void appendDoubleColumn(Record record, int columnIndex) {
        double doubleValue = record.getDouble(columnIndex);
        if (doubleValue == doubleValue) {
            long a = this.responseAsciiSink.skip();
            this.responseAsciiSink.put(doubleValue);
            this.responseAsciiSink.putLenEx(a);
        } else {
            this.responseAsciiSink.setNullValue();
        }
    }

    private void appendDoubleColumnBin(Record record, int columnIndex) {
        double value = record.getDouble(columnIndex);
        if (value == value) {
            this.responseAsciiSink.putNetworkInt(8);
            this.responseAsciiSink.putNetworkDouble(value);
        } else {
            this.responseAsciiSink.setNullValue();
        }
    }

    private void appendFloatColumn(Record record, int columnIndex) {
        float floatValue = record.getFloat(columnIndex);
        if (floatValue == floatValue) {
            long a = this.responseAsciiSink.skip();
            this.responseAsciiSink.put(floatValue, 3);
            this.responseAsciiSink.putLenEx(a);
        } else {
            this.responseAsciiSink.setNullValue();
        }
    }

    private void appendFloatColumnBin(Record record, int columnIndex) {
        float value = record.getFloat(columnIndex);
        if (value == value) {
            this.responseAsciiSink.putNetworkInt(4);
            this.responseAsciiSink.putNetworkFloat(value);
        } else {
            this.responseAsciiSink.setNullValue();
        }
    }

    private void appendIntCol(Record record, int i) {
        int intValue = record.getInt(i);
        if (intValue != Integer.MIN_VALUE) {
            long a = this.responseAsciiSink.skip();
            this.responseAsciiSink.put(intValue);
            this.responseAsciiSink.putLenEx(a);
        } else {
            this.responseAsciiSink.setNullValue();
        }
    }

    private void appendIntColumnBin(Record record, int columnIndex) {
        int value = record.getInt(columnIndex);
        if (value != Integer.MIN_VALUE) {
            this.responseAsciiSink.ensureCapacity(8);
            this.responseAsciiSink.putIntUnsafe(0L, INT_BYTES_X);
            this.responseAsciiSink.putIntUnsafe(4L, Numbers.bswap(value));
            this.responseAsciiSink.bump(8);
        } else {
            this.responseAsciiSink.setNullValue();
        }
    }

    private void appendLong256Column(Record record, int columnIndex) {
        Long256 long256Value = record.getLong256A(columnIndex);
        if (long256Value.getLong0() == Long.MIN_VALUE && long256Value.getLong1() == Long.MIN_VALUE && long256Value.getLong2() == Long.MIN_VALUE && long256Value.getLong3() == Long.MIN_VALUE) {
            this.responseAsciiSink.setNullValue();
        } else {
            long a = this.responseAsciiSink.skip();
            Numbers.appendLong256(long256Value.getLong0(), long256Value.getLong1(), long256Value.getLong2(), long256Value.getLong3(), this.responseAsciiSink);
            this.responseAsciiSink.putLenEx(a);
        }
    }

    private void appendLongColumn(Record record, int columnIndex) {
        long longValue = record.getLong(columnIndex);
        if (longValue != Long.MIN_VALUE) {
            long a = this.responseAsciiSink.skip();
            this.responseAsciiSink.put(longValue);
            this.responseAsciiSink.putLenEx(a);
        } else {
            this.responseAsciiSink.setNullValue();
        }
    }

    private void appendLongColumnBin(Record record, int columnIndex) {
        long longValue = record.getLong(columnIndex);
        if (longValue != Long.MIN_VALUE) {
            this.responseAsciiSink.putNetworkInt(8);
            this.responseAsciiSink.putNetworkLong(longValue);
        } else {
            this.responseAsciiSink.setNullValue();
        }
    }

    private void appendRecord(Record record, int columnCount) throws SqlException {
        this.responseAsciiSink.put((byte)68);
        long offset = this.responseAsciiSink.skip();
        this.responseAsciiSink.putNetworkShort((short)columnCount);
        block32: for (int i = 0; i < columnCount; ++i) {
            int type = this.activeSelectColumnTypes.getQuick(2 * i);
            short columnBinaryFlag = PGOids.getColumnBinaryFlag(type);
            short typeTag = ColumnType.tagOf(type);
            int tagWithFlag = PGOids.toColumnBinaryType(columnBinaryFlag, typeTag);
            switch (tagWithFlag) {
                case -2147483643: {
                    this.appendIntColumnBin(record, i);
                    continue block32;
                }
                case 5: {
                    this.appendIntCol(record, i);
                    continue block32;
                }
                case -2147483637: 
                case 11: {
                    this.appendStrColumn(record, i);
                    continue block32;
                }
                case -2147483636: 
                case 12: {
                    this.appendSymbolColumn(record, i);
                    continue block32;
                }
                case -2147483642: {
                    this.appendLongColumnBin(record, i);
                    continue block32;
                }
                case 6: {
                    this.appendLongColumn(record, i);
                    continue block32;
                }
                case 3: {
                    this.appendShortColumn(record, i);
                    continue block32;
                }
                case -2147483638: {
                    this.appendDoubleColumnBin(record, i);
                    continue block32;
                }
                case 10: {
                    this.appendDoubleColumn(record, i);
                    continue block32;
                }
                case -2147483639: {
                    this.appendFloatColumnBin(record, i);
                    continue block32;
                }
                case -2147483645: {
                    this.appendShortColumnBin(record, i);
                    continue block32;
                }
                case -2147483641: {
                    this.appendDateColumnBin(record, i);
                    continue block32;
                }
                case -2147483640: {
                    this.appendTimestampColumnBin(record, i);
                    continue block32;
                }
                case -2147483646: {
                    this.appendByteColumnBin(record, i);
                    continue block32;
                }
                case -2147483629: {
                    this.appendUuidColumnBin(record, i);
                    continue block32;
                }
                case 9: {
                    this.appendFloatColumn(record, i);
                    continue block32;
                }
                case 8: {
                    this.appendTimestampColumn(record, i);
                    continue block32;
                }
                case 7: {
                    this.appendDateColumn(record, i);
                    continue block32;
                }
                case 1: {
                    this.appendBooleanColumn(record, i);
                    continue block32;
                }
                case -2147483647: {
                    this.appendBooleanColumnBin(record, i);
                    continue block32;
                }
                case 2: {
                    this.appendByteColumn(record, i);
                    continue block32;
                }
                case -2147483630: 
                case 18: {
                    this.appendBinColumn(record, i);
                    continue block32;
                }
                case -2147483644: 
                case 4: {
                    this.appendCharColumn(record, i);
                    continue block32;
                }
                case -2147483635: 
                case 13: {
                    this.appendLong256Column(record, i);
                    continue block32;
                }
                case 14: {
                    this.putGeoHashStringByteValue(record, i, this.activeSelectColumnTypes.getQuick(2 * i + 1));
                    continue block32;
                }
                case 15: {
                    this.putGeoHashStringShortValue(record, i, this.activeSelectColumnTypes.getQuick(2 * i + 1));
                    continue block32;
                }
                case 16: {
                    this.putGeoHashStringIntValue(record, i, this.activeSelectColumnTypes.getQuick(2 * i + 1));
                    continue block32;
                }
                case 17: {
                    this.putGeoHashStringLongValue(record, i, this.activeSelectColumnTypes.getQuick(2 * i + 1));
                    continue block32;
                }
                case 29: {
                    this.responseAsciiSink.setNullValue();
                    continue block32;
                }
                case 19: {
                    this.appendUuidColumn(record, i);
                    continue block32;
                }
                default: {
                    assert (false);
                    continue block32;
                }
            }
        }
        this.responseAsciiSink.putLen(offset);
        ++this.rowCount;
    }

    private void appendShortColumn(Record record, int columnIndex) {
        long a = this.responseAsciiSink.skip();
        this.responseAsciiSink.put(record.getShort(columnIndex));
        this.responseAsciiSink.putLenEx(a);
    }

    private void appendShortColumnBin(Record record, int columnIndex) {
        short value = record.getShort(columnIndex);
        this.responseAsciiSink.putNetworkInt(2);
        this.responseAsciiSink.putNetworkShort(value);
    }

    private void appendSingleRecord(Record record, int columnCount) throws SqlException {
        try {
            this.appendRecord(record, columnCount);
        }
        catch (NoSpaceLeftInResponseBufferException e1) {
            LOG.error().$("not enough space in buffer for row data [buffer=").$(this.sendBufferSize).I$();
            this.responseAsciiSink.reset();
            this.freeFactory();
            throw CairoException.critical(0).put("server configuration error: not enough space in send buffer for row data");
        }
    }

    private void appendStrColumn(Record record, int columnIndex) {
        CharSequence strValue = record.getStr(columnIndex);
        if (strValue == null) {
            this.responseAsciiSink.setNullValue();
        } else {
            long a = this.responseAsciiSink.skip();
            this.responseAsciiSink.encodeUtf8(strValue);
            this.responseAsciiSink.putLenEx(a);
        }
    }

    private void appendSymbolColumn(Record record, int columnIndex) {
        CharSequence strValue = record.getSym(columnIndex);
        if (strValue == null) {
            this.responseAsciiSink.setNullValue();
        } else {
            long a = this.responseAsciiSink.skip();
            this.responseAsciiSink.encodeUtf8(strValue);
            this.responseAsciiSink.putLenEx(a);
        }
    }

    private void appendTimestampColumn(Record record, int i) {
        long longValue = record.getTimestamp(i);
        if (longValue == Long.MIN_VALUE) {
            this.responseAsciiSink.setNullValue();
        } else {
            long a = this.responseAsciiSink.skip();
            TimestampFormatUtils.PG_TIMESTAMP_FORMAT.format(longValue, null, null, this.responseAsciiSink);
            this.responseAsciiSink.putLenEx(a);
        }
    }

    private void appendTimestampColumnBin(Record record, int columnIndex) {
        long longValue = record.getLong(columnIndex);
        if (longValue == Long.MIN_VALUE) {
            this.responseAsciiSink.setNullValue();
        } else {
            this.responseAsciiSink.putNetworkInt(8);
            this.responseAsciiSink.putNetworkLong(longValue - 946684800000000L);
        }
    }

    private void appendUuidColumn(Record record, int columnIndex) {
        long hi;
        long lo = record.getLong128Lo(columnIndex);
        if (Uuid.isNull(lo, hi = record.getLong128Hi(columnIndex))) {
            this.responseAsciiSink.setNullValue();
        } else {
            long a = this.responseAsciiSink.skip();
            Numbers.appendUuid(lo, hi, this.responseAsciiSink);
            this.responseAsciiSink.putLenEx(a);
        }
    }

    private void appendUuidColumnBin(Record record, int columnIndex) {
        long hi;
        long lo = record.getLong128Lo(columnIndex);
        if (Uuid.isNull(lo, hi = record.getLong128Hi(columnIndex))) {
            this.responseAsciiSink.setNullValue();
        } else {
            this.responseAsciiSink.putNetworkInt(16);
            this.responseAsciiSink.putNetworkLong(hi);
            this.responseAsciiSink.putNetworkLong(lo);
        }
    }

    private void applyLatestBindColumnFormats() {
        for (int i = 0; i < this.bindSelectColumnFormats.size(); ++i) {
            int newValue = PGOids.toColumnBinaryType((short)this.bindSelectColumnFormats.get(i), PGOids.toColumnType(this.activeSelectColumnTypes.getQuick(2 * i)));
            this.activeSelectColumnTypes.setQuick(2 * i, newValue);
        }
    }

    private void assertTrue(boolean check, String message) throws BadProtocolException {
        if (check) {
            return;
        }
        LOG.error().$(message).$();
        throw BadProtocolException.INSTANCE;
    }

    private long bindValuesAsStrings(long lo, long msgLimit, short parameterValueCount) throws BadProtocolException, SqlException {
        for (int j = 0; j < parameterValueCount; ++j) {
            int valueLen = PGConnectionContext.getInt(lo, msgLimit, "malformed bind variable");
            if (valueLen != -1 && (lo += 4L) + (long)valueLen <= msgLimit) {
                this.setStrBindVariable(j, lo, valueLen);
                lo += (long)valueLen;
                continue;
            }
            if (valueLen == -1) continue;
            LOG.error().$("value length is outside of buffer [parameterIndex=").$(j).$(", valueLen=").$(valueLen).$(", messageRemaining=").$(msgLimit - lo).$(']').$();
            throw BadProtocolException.INSTANCE;
        }
        return lo;
    }

    private long bindValuesUsingSetters(long lo, long msgLimit, short parameterValueCount) throws BadProtocolException, SqlException {
        for (int j = 0; j < parameterValueCount; ++j) {
            int valueLen = PGConnectionContext.getInt(lo, msgLimit, "malformed bind variable");
            lo += 4L;
            if (valueLen == -1) continue;
            if (lo + (long)valueLen <= msgLimit) {
                switch (this.activeBindVariableTypes.getQuick(j)) {
                    case 0x17000001: {
                        this.setIntBindVariable(j, lo, valueLen);
                        break;
                    }
                    case 0x14000001: {
                        this.setLongBindVariable(j, lo, valueLen);
                        break;
                    }
                    case 1510211585: {
                        this.setTimestampBindVariable(j, lo, valueLen);
                        break;
                    }
                    case 0x15000001: {
                        this.setShortBindVariable(j, lo, valueLen);
                        break;
                    }
                    case -1123942399: {
                        this.setDoubleBindVariable(j, lo, valueLen);
                        break;
                    }
                    case -1140719615: {
                        this.setFloatBindVariable(j, lo, valueLen);
                        break;
                    }
                    case 0x12000001: {
                        this.setCharBindVariable(j, lo, valueLen);
                        break;
                    }
                    case 973340673: {
                        this.setDateBindVariable(j, lo, valueLen);
                        break;
                    }
                    case 0x10000001: {
                        this.setBooleanBindVariable(j, valueLen);
                        break;
                    }
                    case 0x11000001: {
                        this.setBinBindVariable(j, lo, valueLen);
                        break;
                    }
                    case -2046099455: {
                        this.setUuidBindVariable(j, lo, valueLen);
                        break;
                    }
                    default: {
                        this.setStrBindVariable(j, lo, valueLen);
                    }
                }
                this.typesAndUpdateIsCached = true;
                this.typesAndSelectIsCached = true;
                lo += (long)valueLen;
                continue;
            }
            LOG.error().$("value length is outside of buffer [parameterIndex=").$(j).$(", valueLen=").$(valueLen).$(", messageRemaining=").$(msgLimit - lo).$(']').$();
            throw BadProtocolException.INSTANCE;
        }
        return lo;
    }

    private void buildSelectColumnTypes() {
        RecordMetadata m = this.typesAndSelect.getFactory().getMetadata();
        int columnCount = m.getColumnCount();
        this.activeSelectColumnTypes.setPos(2 * columnCount);
        for (int i = 0; i < columnCount; ++i) {
            int columnType = m.getColumnType(i);
            int flags = GeoHashes.getBitFlags(columnType);
            this.activeSelectColumnTypes.setQuick(2 * i, columnType);
            this.activeSelectColumnTypes.setQuick(2 * i + 1, flags);
        }
    }

    private void clearCursorAndFactory() {
        this.resumeProcessor = null;
        this.currentCursor = Misc.free(this.currentCursor);
        this.currentFactory = null;
        if (this.typesAndSelect != null) {
            if (this.typesAndSelectIsCached) {
                this.typesAndSelectCache.put(this.queryText, this.typesAndSelect);
                this.typesAndSelect = null;
            } else {
                this.typesAndSelect = Misc.free(this.typesAndSelect);
            }
        }
        if (this.typesAndUpdate != null) {
            if (this.typesAndUpdateIsCached) {
                assert (this.queryText != null);
                this.typesAndUpdateCache.put(this.queryText, this.typesAndUpdate);
                this.typesAndUpdate = null;
            } else {
                this.typesAndUpdate = Misc.free(this.typesAndUpdate);
            }
        }
    }

    private void closePendingWriters(boolean commit) {
        Iterator<ObjObjHashMap.Entry<TableToken, TableWriterAPI>> iterator = this.pendingWriters.iterator();
        while (iterator.hasNext()) {
            TableWriterAPI m = (TableWriterAPI)iterator.next().value;
            if (commit) {
                m.commit();
            } else {
                m.rollback();
            }
            Misc.free(m);
        }
    }

    private boolean compileQuery(SqlCompiler compiler) throws SqlException {
        if (this.queryText != null && this.queryText.length() > 0) {
            this.typesAndInsert = this.typesAndInsertCache.peek(this.queryText);
            if (this.typesAndInsert != null) {
                this.typesAndInsert.defineBindVariables(this.bindVariableService);
                this.queryTag = TAG_INSERT;
                return false;
            }
            this.typesAndUpdate = this.typesAndUpdateCache.poll(this.queryText);
            if (this.typesAndUpdate != null) {
                this.typesAndUpdate.defineBindVariables(this.bindVariableService);
                this.queryTag = TAG_UPDATE;
                this.typesAndUpdateIsCached = true;
                return false;
            }
            this.typesAndSelect = this.typesAndSelectCache.poll(this.queryText);
            if (this.typesAndSelect != null) {
                LOG.info().$("query cache used [fd=").$(this.fd).I$();
                this.bindVariableService.clear();
                this.typesAndSelect.defineBindVariables(this.bindVariableService);
                this.queryTag = TAG_SELECT;
                return false;
            }
            CompiledQuery cc = compiler.compile(this.queryText, this.sqlExecutionContext);
            this.processCompiledQuery(cc);
        } else {
            this.isEmptyQuery = true;
        }
        return true;
    }

    private void configureContextFromNamedStatement(CharSequence statementName, @Nullable SqlCompiler compiler) throws BadProtocolException, SqlException {
        boolean bl = this.sendParameterDescription = statementName != null;
        if (this.wrapper != null) {
            LOG.debug().$("reusing existing wrapper").$();
            return;
        }
        if (statementName != null) {
            LOG.debug().$("named statement [name=").$(statementName).$(']').$();
            this.wrapper = this.namedStatementMap.get(statementName);
            if (this.wrapper != null) {
                this.setupVariableSettersFromWrapper(this.wrapper, compiler);
            } else {
                LOG.error().$("statement does not exist [name=").$(statementName).$(']').$();
                throw BadProtocolException.INSTANCE;
            }
        }
    }

    private void configurePortal(CharSequence portalName, CharSequence statementName) throws BadProtocolException {
        int index = this.namedPortalMap.keyIndex(portalName);
        if (index <= -1) {
            LOG.error().$("duplicate portal [name=").$(portalName).$(']').$();
            throw BadProtocolException.INSTANCE;
        }
        Portal portal = (Portal)this.namedPortalPool.pop();
        portal.statementName = statementName;
        this.namedPortalMap.putAt(index, Chars.toString(portalName), portal);
    }

    private void configurePreparedStatement(CharSequence statementName) throws BadProtocolException {
        int index = this.namedStatementMap.keyIndex(statementName);
        if (index <= -1) {
            LOG.error().$("duplicate statement [name=").$(statementName).$(']').$();
            throw BadProtocolException.INSTANCE;
        }
        this.wrapper = (NamedStatementWrapper)this.namedStatementWrapperPool.pop();
        this.wrapper.queryText = Chars.toString(this.queryText);
        this.wrapper.alreadyExecuted = this.queryTag == TAG_OK || this.queryTag == TAG_CTAS || this.queryTag == TAG_COPY && this.typesAndSelect == null;
        this.namedStatementMap.putAt(index, Chars.toString(statementName), this.wrapper);
        this.activeBindVariableTypes = this.wrapper.bindVariableTypes;
        this.activeSelectColumnTypes = this.wrapper.selectColumnTypes;
    }

    private void doAuthentication(long msgLo, long msgLimit) throws BadProtocolException, PeerDisconnectedException, PeerIsSlowToReadException, AuthenticationException {
        CairoSecurityContext cairoSecurityContext = null;
        if (this.roUserAuthenticator != null) {
            try {
                cairoSecurityContext = this.roUserAuthenticator.authenticate(this.username, msgLo, msgLimit);
            }
            catch (AuthenticationException authenticationException) {
                // empty catch block
            }
        }
        if (cairoSecurityContext == null) {
            cairoSecurityContext = this.authenticator.authenticate(this.username, msgLo, msgLimit);
        }
        if (cairoSecurityContext != null) {
            this.sqlExecutionContext.with(cairoSecurityContext, this.bindVariableService, this.rnd, this.fd, this.circuitBreaker.of(this.fd));
            this.authenticationRequired = false;
            this.prepareLoginOk();
            this.sendAndReset();
        }
    }

    private void doSendWithRetries(int bufferOffset, int bufferSize) throws PeerDisconnectedException, PeerIsSlowToReadException {
        int offset = bufferOffset;
        int remaining = bufferSize;
        while (remaining > 0) {
            int m = this.nf.send(this.getFd(), this.sendBuffer + (long)offset, remaining);
            if (m < 0) {
                LOG.info().$("disconnected on write [code=").$(m).$(']').$();
                throw PeerDisconnectedException.INSTANCE;
            }
            if (m == 0) break;
            this.dumpBuffer('<', this.sendBuffer + (long)offset, m);
            remaining -= m;
            offset += m;
        }
        if (remaining > 0) {
            this.bufferRemainingOffset = offset;
            this.bufferRemainingSize = remaining;
            throw PeerIsSlowToReadException.INSTANCE;
        }
    }

    private void dumpBuffer(char direction, long buffer, int len) {
        if (this.dumpNetworkTraffic && len > 0) {
            StdoutSink.INSTANCE.put(direction);
            Net.dump(buffer, len);
        }
    }

    private void evictNamedStatementWrappersAndClear() {
        if (this.namedStatementMap.size() > 0) {
            ObjList<CharSequence> names = this.namedStatementMap.keys();
            int n = names.size();
            for (int i = 0; i < n; ++i) {
                CharSequence name = names.getQuick(i);
                this.namedStatementWrapperPool.push((NamedStatementWrapper)((Mutable)this.namedStatementMap.get(name)));
            }
            this.namedStatementMap.clear();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void executeInsert(SqlCompiler compiler) throws SqlException {
        recompileStale = true;
        retries = 0;
        while (recompileStale) {
            try {
                switch (this.transactionState) {
                    case 1: {
                        m = this.typesAndInsert.getInsert().createMethod(this.sqlExecutionContext, this);
                        recompileStale = false;
                        try {
                            this.rowCount = m.execute();
                            writer = m.popWriter();
                            this.pendingWriters.put(writer.getTableToken(), writer);
                            break;
                        }
                        catch (Throwable e) {
                            Misc.free(m);
                            throw e;
                        }
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        m2 = this.typesAndInsert.getInsert().createMethod(this.sqlExecutionContext, this);
                        var7_10 = null;
                        recompileStale = false;
                        this.rowCount = m2.execute();
                        m2.commit();
                        if (m2 == null) break;
                        if (var7_10 == null) ** GOTO lbl35
                        try {
                            m2.close();
                        }
                        catch (Throwable var8_11) {
                            var7_10.addSuppressed(var8_11);
                        }
                        break;
lbl35:
                        // 1 sources

                        m2.close();
                        break;
                        catch (Throwable var8_12) {
                            try {
                                var7_10 = var8_12;
                                throw var8_12;
                            }
                            catch (Throwable var9_13) {
                                if (m2 != null) {
                                    if (var7_10 != null) {
                                        try {
                                            m2.close();
                                        }
                                        catch (Throwable var10_14) {
                                            var7_10.addSuppressed(var10_14);
                                        }
                                    } else {
                                        m2.close();
                                    }
                                }
                                throw var9_13;
                            }
                        }
                    }
                }
                this.prepareCommandComplete(true);
                return;
            }
            catch (TableReferenceOutOfDateException ex) {
                if (!recompileStale || retries == 10) {
                    if (this.transactionState == 1) {
                        this.transactionState = 3;
                    }
                    throw ex;
                }
                PGConnectionContext.LOG.info().$(ex.getFlyweightMessage()).$();
                Misc.free(this.typesAndInsert);
                cc = compiler.compile(this.queryText, this.sqlExecutionContext);
                this.processCompiledQuery(cc);
            }
            catch (Throwable e) {
                if (this.transactionState == 1) {
                    this.transactionState = 3;
                }
                throw e;
            }
            ++retries;
        }
    }

    private void executeTag() {
        LOG.debug().$("executing [tag=").$(this.queryTag).$(']').$();
        if (this.queryTag != null && TAG_OK != this.queryTag) {
            this.executeTag0();
        }
    }

    private void executeTag0() {
        switch (this.transactionState) {
            case 2: {
                try {
                    this.closePendingWriters(true);
                    break;
                }
                finally {
                    this.pendingWriters.clear();
                    this.transactionState = 0;
                }
            }
            case 4: {
                try {
                    this.closePendingWriters(false);
                    break;
                }
                finally {
                    this.pendingWriters.clear();
                    this.transactionState = 0;
                }
            }
        }
    }

    private void executeUpdate(SqlCompiler compiler) throws SqlException {
        boolean recompileStale = true;
        int retries = 0;
        while (recompileStale) {
            try {
                if (this.transactionState != 3) {
                    this.executeUpdate0();
                    recompileStale = false;
                }
                this.prepareCommandComplete(true);
            }
            catch (TableReferenceOutOfDateException e) {
                if (retries == 10) {
                    if (this.transactionState == 1) {
                        this.transactionState = 3;
                    }
                    throw e;
                }
                LOG.info().$(e.getFlyweightMessage()).$();
                this.typesAndUpdate = Misc.free(this.typesAndUpdate);
                CompiledQuery cc = compiler.compile(this.queryText, this.sqlExecutionContext);
                this.processCompiledQuery(cc);
            }
            catch (Throwable e) {
                this.typesAndUpdate = Misc.free(this.typesAndUpdate);
                if (this.transactionState == 1) {
                    this.transactionState = 3;
                }
                throw e;
            }
            ++retries;
        }
    }

    private void executeUpdate0() throws SqlException {
        CompiledQuery cq = this.typesAndUpdate.getCompiledQuery();
        UpdateOperation op = cq.getUpdateOperation();
        op.start();
        TableToken tableToken = op.getTableToken();
        if (tableToken == null) {
            throw CairoException.critical(0).put("invalid update operation plan cached, table token is null");
        }
        int index = this.pendingWriters.keyIndex(tableToken);
        if (index < 0) {
            op.withContext(this.sqlExecutionContext);
            TableWriterAPI tableWriterAPI = this.pendingWriters.valueAt(index);
            tableWriterAPI.commit();
            tableWriterAPI.apply(op);
        } else {
            if (this.statementTimeout > 0L) {
                this.circuitBreaker.setTimeout(this.statementTimeout);
            }
            try (OperationFuture fut = cq.execute(this.sqlExecutionContext, this.tempSequence, false);){
                if (this.statementTimeout > 0L) {
                    if (fut.await(this.statementTimeout) != 2) {
                        if (op.isWriterClosePending()) {
                            this.freeUpdateCommand(op);
                        }
                        throw SqlException.$(0, "UPDATE query timeout ").put(this.statementTimeout).put(" ms");
                    }
                } else {
                    fut.await();
                }
                this.rowCount = fut.getAffectedRowsCount();
            }
            catch (SqlTimeoutException ex) {
                throw ex;
            }
            catch (CairoException | SqlException ex) {
                throw ex;
            }
            finally {
                if (op.isWriterClosePending()) {
                    this.freeUpdateCommand(op);
                }
            }
        }
    }

    private void freeBuffers() {
        this.recvBuffer = Unsafe.free(this.recvBuffer, this.recvBufferSize, 12);
        this.sendBufferPtr = this.sendBufferLimit = Unsafe.free(this.sendBuffer, this.sendBufferSize, 12);
        this.sendBuffer = this.sendBufferLimit;
    }

    private void freeFactory() {
        this.currentFactory = null;
        this.typesAndSelect = Misc.free(this.typesAndSelect);
    }

    private void freeUpdateCommand(UpdateOperation op) {
        this.bindVariableService = new BindVariableServiceImpl(this.engine.getConfiguration());
        SqlExecutionContextImpl newSqlExecutionContext = new SqlExecutionContextImpl(this.engine, this.sqlExecutionContext.getWorkerCount(), this.sqlExecutionContext.getSharedWorkerCount());
        newSqlExecutionContext.with(this.sqlExecutionContext.getCairoSecurityContext(), this.bindVariableService, this.sqlExecutionContext.getRandom(), this.sqlExecutionContext.getRequestFd(), this.circuitBreaker);
        this.sqlExecutionContext = newSqlExecutionContext;
        op.close();
        this.typesAndUpdate = null;
    }

    @Nullable
    private CharSequence getPortalName(long lo, long hi) throws BadProtocolException {
        if (hi - lo > 0L) {
            return this.getString(lo, hi, "invalid UTF8 bytes in portal name");
        }
        return null;
    }

    @Nullable
    private CharSequence getStatementName(long lo, long hi) throws BadProtocolException {
        if (hi - lo > 0L) {
            return this.getString(lo, hi, "invalid UTF8 bytes in statement name");
        }
        return null;
    }

    private CharSequence getString(long lo, long hi, CharSequence errorMessage) throws BadProtocolException {
        CharacterStoreEntry e = this.characterStore.newEntry();
        if (Chars.utf8Decode(lo, hi, e)) {
            return this.characterStore.toImmutable();
        }
        LOG.error().$(errorMessage).$();
        throw BadProtocolException.INSTANCE;
    }

    private void parse(long address, int len, SqlCompiler compiler) throws PeerDisconnectedException, PeerIsSlowToReadException, BadProtocolException, QueryPausedException, AuthenticationException, SqlException {
        if (this.requireInitialMessage) {
            this.sendRNQ = true;
            this.processInitialMessage(address, len);
            return;
        }
        if (len < 5) {
            return;
        }
        byte type = Unsafe.getUnsafe().getByte(address);
        int msgLen = PGConnectionContext.getIntUnsafe(address + 1L);
        LOG.debug().$("received msg [type=").$((char)type).$(", len=").$(msgLen).$(']').$();
        if (msgLen < 1) {
            LOG.error().$("invalid message length [type=").$(type).$(", msgLen=").$(msgLen).$(", recvBufferReadOffset=").$(this.recvBufferReadOffset).$(", recvBufferWriteOffset=").$(this.recvBufferWriteOffset).$(", totalReceived=").$(this.totalReceived).$(']').$();
            throw BadProtocolException.INSTANCE;
        }
        if (msgLen > len - 1) {
            LOG.debug().$("not enough data in buffer [expected=").$(msgLen).$(", have=").$(len).$(", recvBufferWriteOffset=").$(this.recvBufferWriteOffset).$(", recvBufferReadOffset=").$(this.recvBufferReadOffset).$(']').$();
            return;
        }
        this.recvBufferReadOffset += (long)(msgLen + 1);
        long msgLimit = address + (long)msgLen + 1L;
        long msgLo = address + 5L;
        if (this.authenticationRequired) {
            this.sendRNQ = true;
            this.doAuthentication(msgLo, msgLimit);
            return;
        }
        switch (type) {
            case 80: {
                this.sendRNQ = true;
                this.processParse(address, msgLo, msgLimit, compiler);
                break;
            }
            case 88: {
                throw PeerDisconnectedException.INSTANCE;
            }
            case 67: {
                this.processClose(msgLo, msgLimit);
                this.sendRNQ = true;
                break;
            }
            case 66: {
                this.sendRNQ = true;
                this.processBind(msgLo, msgLimit, compiler);
                break;
            }
            case 69: {
                this.sendRNQ = true;
                this.processExec(msgLo, msgLimit, compiler);
                break;
            }
            case 83: {
                this.processSyncActions();
                this.prepareReadyForQuery();
                this.prepareForNewQuery();
                this.sendRNQ = true;
            }
            case 72: {
                if (this.syncActions.size() > 0) {
                    this.processSyncActions();
                    this.prepareForNewQuery();
                }
                this.sendAndReset();
                break;
            }
            case 68: {
                this.sendRNQ = true;
                this.processDescribe(msgLo, msgLimit, compiler);
                break;
            }
            case 81: {
                this.sendRNQ = true;
                this.processQuery(msgLo, msgLimit, compiler);
                break;
            }
            case 100: {
                break;
            }
            default: {
                LOG.error().$("unknown message [type=").$(type).$(']').$();
                throw BadProtocolException.INSTANCE;
            }
        }
    }

    private void parseQueryText(long lo, long hi, SqlCompiler compiler) throws BadProtocolException, SqlException {
        CharacterStoreEntry e = this.characterStore.newEntry();
        if (Chars.utf8Decode(lo, hi, e)) {
            this.queryText = this.characterStore.toImmutable();
            LOG.info().$("parse [fd=").$(this.fd).$(", q=").utf8(this.queryText).I$();
            this.compileQuery(compiler);
            return;
        }
        LOG.error().$("invalid UTF8 bytes in parse query").$();
        throw BadProtocolException.INSTANCE;
    }

    private void prepareBindComplete() {
        this.responseAsciiSink.put((byte)50);
        this.responseAsciiSink.putIntDirect(INT_BYTES_X);
    }

    private void prepareCloseComplete() {
        this.responseAsciiSink.put((byte)51);
        this.responseAsciiSink.putIntDirect(INT_BYTES_X);
    }

    private void prepareDescribePortalResponse() {
        if (this.typesAndSelect != null) {
            try {
                this.prepareRowDescription();
            }
            catch (NoSpaceLeftInResponseBufferException ignored) {
                LOG.error().$("not enough space in buffer for row description [buffer=").$(this.sendBufferSize).I$();
                this.responseAsciiSink.reset();
                this.freeFactory();
                throw CairoException.critical(0).put("server configuration error: not enough space in send buffer for row description");
            }
        } else {
            this.prepareNoDataMessage();
        }
    }

    private void prepareDescribeResponse() {
        if (this.sendParameterDescription) {
            this.prepareParameterDescription();
        }
        this.prepareDescribePortalResponse();
    }

    private void prepareError(CairoException ex) {
        int errno = ex.getErrno();
        CharSequence message = ex.getFlyweightMessage();
        this.prepareErrorResponse(ex.getPosition(), ex.getFlyweightMessage());
        if (errno == -1) {
            LOG.error().$("error [msg=`").$(message).$('`').$(", errno=`").$(errno).I$();
        } else {
            LOG.critical().$("error [msg=`").$(message).$('`').$(", errno=`").$(errno).I$();
        }
    }

    private void prepareErrorResponse(int position, CharSequence message) {
        this.responseAsciiSink.put((byte)69);
        long addr = this.responseAsciiSink.skip();
        this.responseAsciiSink.put('C');
        this.responseAsciiSink.encodeUtf8Z("00000");
        this.responseAsciiSink.put('M');
        this.responseAsciiSink.encodeUtf8Z(message);
        this.responseAsciiSink.put('S');
        this.responseAsciiSink.encodeUtf8Z("ERROR");
        if (position > -1) {
            this.responseAsciiSink.put('P').put(position + 1).put('\u0000');
        }
        this.responseAsciiSink.put('\u0000');
        this.responseAsciiSink.putLen(addr);
    }

    private void prepareForNewBatchQuery() {
        if (this.completed) {
            LOG.debug().$("prepare for new query").$();
            this.isEmptyQuery = false;
            this.bindVariableService.clear();
            this.currentCursor = Misc.free(this.currentCursor);
            this.typesAndInsert = null;
            this.clearCursorAndFactory();
            this.rowCount = 0L;
            this.queryTag = TAG_OK;
            this.queryText = null;
            this.wrapper = null;
            this.syncActions.clear();
            this.sendParameterDescription = false;
        }
    }

    private void prepareForNewQuery() {
        this.prepareForNewBatchQuery();
        this.characterStore.clear();
    }

    private void prepareGssResponse() {
        this.responseAsciiSink.put('N');
    }

    private void prepareLoginOk() {
        this.responseAsciiSink.put((byte)82);
        this.responseAsciiSink.putNetworkInt(8);
        this.responseAsciiSink.putIntDirect(0);
        PGConnectionContext.prepareParams(this.responseAsciiSink, "TimeZone", "GMT");
        PGConnectionContext.prepareParams(this.responseAsciiSink, "application_name", "QuestDB");
        PGConnectionContext.prepareParams(this.responseAsciiSink, "server_version", this.serverVersion);
        PGConnectionContext.prepareParams(this.responseAsciiSink, "integer_datetimes", "on");
        PGConnectionContext.prepareParams(this.responseAsciiSink, "client_encoding", "UTF8");
        this.prepareReadyForQuery();
    }

    private void prepareLoginResponse() {
        this.responseAsciiSink.put((byte)82);
        this.responseAsciiSink.putNetworkInt(8);
        this.responseAsciiSink.putNetworkInt(3);
    }

    private void prepareNoDataMessage() {
        this.responseAsciiSink.put((byte)110);
        this.responseAsciiSink.putIntDirect(INT_BYTES_X);
    }

    private void prepareNonCriticalError(int position, CharSequence message) {
        this.prepareErrorResponse(position, message);
        LOG.error().$("error [pos=").$(position).$(", msg=`").$(message).$('`').I$();
    }

    private void prepareParameterDescription() {
        this.responseAsciiSink.put((byte)116);
        long l = this.responseAsciiSink.skip();
        int n = this.bindVariableService.getIndexedVariableCount();
        this.responseAsciiSink.putNetworkShort((short)n);
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.responseAsciiSink.putIntDirect(PGOids.toParamType(this.activeBindVariableTypes.getQuick(i)));
            }
        }
        this.responseAsciiSink.putLen(l);
    }

    private void prepareParseComplete() {
        this.responseAsciiSink.put((byte)49);
        this.responseAsciiSink.putIntDirect(INT_BYTES_X);
    }

    private void prepareQueryCanceled(CharSequence message) {
        this.prepareErrorResponse(-1, message);
        LOG.info().$("query cancelled [msg=`").$(message).$('`').I$();
    }

    private void prepareRowDescription() {
        RecordMetadata metadata = this.typesAndSelect.getFactory().getMetadata();
        ResponseAsciiSink sink = this.responseAsciiSink;
        sink.put((byte)84);
        long addr = sink.skip();
        int n = this.activeSelectColumnTypes.size() / 2;
        sink.putNetworkShort((short)n);
        for (int i = 0; i < n; ++i) {
            int typeFlag = this.activeSelectColumnTypes.getQuick(2 * i);
            int columnType = PGOids.toColumnType(ColumnType.isNull(typeFlag) ? 11 : typeFlag);
            sink.encodeUtf8Z(metadata.getColumnName(i));
            sink.putIntDirect(0);
            sink.putNetworkShort((short)(i + 1));
            sink.putNetworkInt(PGOids.getTypeOid(columnType));
            if (ColumnType.tagOf(columnType) < 11) {
                sink.putNetworkShort((short)ColumnType.sizeOf(columnType));
            } else {
                sink.putNetworkShort((short)-1);
            }
            sink.putIntDirect(INT_NULL_X);
            sink.putNetworkShort(ColumnType.isBinary(columnType) ? (short)1 : PGOids.getColumnBinaryFlag(typeFlag));
        }
        sink.putLen(addr);
    }

    private void prepareSslResponse() {
        this.responseAsciiSink.put('N');
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processBind(long lo, long msgLimit, SqlCompiler compiler) throws BadProtocolException, SqlException {
        this.sqlExecutionContext.getCircuitBreaker().resetTimer();
        LOG.debug().$("bind").$();
        long hi = PGConnectionContext.getStringLength(lo, msgLimit, "bad portal name length [msgType='B']");
        CharSequence portalName = this.getPortalName(lo, hi);
        lo = hi + 1L;
        hi = PGConnectionContext.getStringLength(lo, msgLimit, "bad prepared statement name length [msgType='B']");
        CharSequence statementName = this.getStatementName(lo, hi);
        this.configureContextFromNamedStatement(statementName, compiler);
        if (portalName != null) {
            this.configurePortal(portalName, statementName);
        }
        lo = hi + 1L;
        short parameterFormatCount = PGConnectionContext.getShort(lo, msgLimit, "could not read parameter format code count");
        lo += 2L;
        if (parameterFormatCount > 0) {
            if (parameterFormatCount == 1) {
                PGConnectionContext.bindSingleFormatForAll(lo, msgLimit, this.activeBindVariableTypes);
            } else if (parameterFormatCount == this.parsePhaseBindVariableCount) {
                PGConnectionContext.bindParameterFormats(lo, msgLimit, parameterFormatCount, this.activeBindVariableTypes);
            }
        }
        short parameterValueCount = PGConnectionContext.getShort(lo += (long)(parameterFormatCount * 2), msgLimit, "could not read parameter value count");
        LOG.debug().$("binding [parameterValueCount=").$(parameterValueCount).$(", thread=").$(Thread.currentThread().getId()).$(']').$();
        this.validateParameterCounts(parameterFormatCount, parameterValueCount, this.parsePhaseBindVariableCount);
        lo += 2L;
        try {
            if (parameterValueCount > 0) {
                lo = this.parsePhaseBindVariableCount == parameterValueCount ? this.bindValuesUsingSetters(lo, msgLimit, parameterValueCount) : this.bindValuesAsStrings(lo, msgLimit, parameterValueCount);
            }
        }
        catch (ImplicitCastException | SqlException e) {
            this.freeFactory();
            this.typesAndUpdate = Misc.free(this.typesAndUpdate);
            throw e;
        }
        if (this.typesAndSelect != null) {
            this.bindSelectColumnFormats.clear();
            short columnFormatCodeCount = PGConnectionContext.getShort(lo, msgLimit, "could not read result set column format codes");
            if (columnFormatCodeCount > 0) {
                RecordMetadata m = this.typesAndSelect.getFactory().getMetadata();
                int columnCount = m.getColumnCount();
                long spaceNeeded = lo + (long)((columnFormatCodeCount + 1) * 2);
                if (spaceNeeded > msgLimit) {
                    LOG.error().$("could not process column format codes [bufSpaceNeeded=").$(spaceNeeded).$(", bufSpaceAvail=").$(msgLimit).$(']').$();
                    throw BadProtocolException.INSTANCE;
                }
                this.bindSelectColumnFormats.setPos(columnCount);
                if (columnFormatCodeCount == columnCount) {
                    for (int i = 0; i < columnCount; ++i) {
                        short code = PGConnectionContext.getShortUnsafe(lo += 2L);
                        this.activeSelectColumnTypes.setQuick(2 * i, PGOids.toColumnBinaryType(code, m.getColumnType(i)));
                        this.bindSelectColumnFormats.setQuick(i, code);
                        this.activeSelectColumnTypes.setQuick(2 * i + 1, 0);
                    }
                } else {
                    if (columnFormatCodeCount != 1) {
                        LOG.error().$("could not process column format codes [fmtCount=").$(columnFormatCodeCount).$(", columnCount=").$(columnCount).$(']').$();
                        throw BadProtocolException.INSTANCE;
                    }
                    short code = PGConnectionContext.getShortUnsafe(lo += 2L);
                    for (int i = 0; i < columnCount; ++i) {
                        this.activeSelectColumnTypes.setQuick(2 * i, PGOids.toColumnBinaryType(code, m.getColumnType(i)));
                        this.bindSelectColumnFormats.setQuick(i, code);
                        this.activeSelectColumnTypes.setQuick(2 * i + 1, 0);
                    }
                }
            } else if (columnFormatCodeCount == 0) {
                RecordMetadata m = this.typesAndSelect.getFactory().getMetadata();
                int columnCount = m.getColumnCount();
                this.bindSelectColumnFormats.setPos(columnCount);
                for (int i = 0; i < columnCount; ++i) {
                    this.activeSelectColumnTypes.setQuick(2 * i, PGOids.toColumnBinaryType((short)0, m.getColumnType(i)));
                    this.bindSelectColumnFormats.setQuick(i, 0);
                }
            }
        }
        this.syncActions.add(3);
    }

    private void processClose(long lo, long msgLimit) throws BadProtocolException {
        byte type = Unsafe.getUnsafe().getByte(lo);
        switch (type) {
            case 83: {
                long hi = PGConnectionContext.getStringLength(++lo, msgLimit, "bad prepared statement name length");
                this.removeNamedStatement(this.getStatementName(lo, hi));
                break;
            }
            case 80: {
                long high = PGConnectionContext.getStringLength(++lo, msgLimit, "bad prepared statement name length");
                CharSequence portalName = this.getPortalName(lo, high);
                if (portalName == null) break;
                int index = this.namedPortalMap.keyIndex(portalName);
                if (index < 0) {
                    this.namedPortalPool.push((Portal)((Mutable)this.namedPortalMap.valueAt(index)));
                    this.namedPortalMap.removeAt(index);
                    break;
                }
                LOG.error().$("invalid portal name [value=").$(portalName).$(']').$();
                throw BadProtocolException.INSTANCE;
            }
            default: {
                LOG.error().$("invalid type for close message [type=").$(type).$(']').$();
                throw BadProtocolException.INSTANCE;
            }
        }
        this.prepareCloseComplete();
    }

    private void processCompiledQuery(CompiledQuery cq) throws SqlException {
        this.sqlExecutionContext.storeTelemetry(cq.getType(), (short)3);
        switch (cq.getType()) {
            case 21: {
                this.queryTag = TAG_CTAS;
                this.rowCount = cq.getAffectedRowsCount();
                break;
            }
            case 25: {
                this.typesAndSelectIsCached = false;
                this.typesAndSelect = (TypesAndSelect)this.typesAndSelectPool.pop();
                this.typesAndSelect.of(cq.getRecordCursorFactory(), this.bindVariableService);
                this.queryTag = TAG_EXPLAIN;
            }
            case 1: {
                this.typesAndSelect = (TypesAndSelect)this.typesAndSelectPool.pop();
                this.typesAndSelect.of(cq.getRecordCursorFactory(), this.bindVariableService);
                this.queryTag = TAG_SELECT;
                LOG.debug().$("cache select [sql=").$(this.queryText).$(", thread=").$(Thread.currentThread().getId()).$(']').$();
                break;
            }
            case 2: {
                this.queryTag = TAG_INSERT;
                this.typesAndInsert = (TypesAndInsert)this.typesAndInsertPool.pop();
                this.typesAndInsert.of(cq.getInsertOperation(), this.bindVariableService);
                if (this.bindVariableService.getIndexedVariableCount() <= 0) break;
                LOG.debug().$("cache insert [sql=").$(this.queryText).$(", thread=").$(Thread.currentThread().getId()).$(']').$();
                this.typesAndInsertCache.put(this.queryText, this.typesAndInsert);
                break;
            }
            case 14: {
                this.queryTag = TAG_UPDATE;
                this.typesAndUpdate = (TypesAndUpdate)this.typesAndUpdatePool.pop();
                this.typesAndUpdate.of(cq, this.bindVariableService);
                this.typesAndUpdateIsCached = this.bindVariableService.getIndexedVariableCount() > 0;
                break;
            }
            case 10: {
                this.queryTag = TAG_INSERT;
                this.rowCount = cq.getAffectedRowsCount();
                break;
            }
            case 8: {
                RecordCursorFactory factory = cq.getRecordCursorFactory();
                if (factory != null) {
                    this.typesAndSelectIsCached = false;
                    this.typesAndSelect = (TypesAndSelect)this.typesAndSelectPool.pop();
                    this.typesAndSelect.of(cq.getRecordCursorFactory(), this.bindVariableService);
                }
                this.queryTag = TAG_COPY;
                break;
            }
            case 6: {
                this.queryTag = TAG_SET;
                break;
            }
            case 24: {
                this.queryTag = TAG_DEALLOCATE;
                this.removeNamedStatement(cq.getStatementName());
                break;
            }
            case 18: {
                this.queryTag = TAG_BEGIN;
                this.transactionState = 1;
                break;
            }
            case 19: {
                this.queryTag = TAG_COMMIT;
                if (this.transactionState == 3) break;
                this.transactionState = 2;
                break;
            }
            case 20: {
                this.queryTag = TAG_ROLLBACK;
                this.transactionState = 4;
                break;
            }
            case 4: {
                try (OperationFuture fut = cq.execute(this.sqlExecutionContext, this.tempSequence, true);){
                    fut.await();
                }
            }
            default: {
                this.queryTag = TAG_OK;
            }
        }
    }

    private void processDescribe(long lo, long msgLimit, SqlCompiler compiler) throws SqlException, BadProtocolException {
        this.sqlExecutionContext.getCircuitBreaker().resetTimer();
        boolean isPortal = Unsafe.getUnsafe().getByte(lo) == 80;
        long hi = PGConnectionContext.getStringLength(lo + 1L, msgLimit, "bad prepared statement name length");
        CharSequence target = this.getPortalName(lo + 1L, hi);
        LOG.debug().$("describe [name=").$(target).$(']').$();
        if (isPortal && target != null) {
            Portal p = this.namedPortalMap.get(target);
            if (p != null) {
                target = p.statementName;
            } else {
                LOG.error().$("invalid portal [name=").$(target).$(']').$();
                throw BadProtocolException.INSTANCE;
            }
        }
        this.configureContextFromNamedStatement(target, compiler);
        int n = this.bindVariableService.getIndexedVariableCount();
        if (this.sendParameterDescription && n > 0 && this.activeBindVariableTypes.size() == 0) {
            this.activeBindVariableTypes.setPos(n);
            for (int i = 0; i < n; ++i) {
                this.activeBindVariableTypes.setQuick(i, Numbers.bswap(PGOids.getTypeOid(this.bindVariableService.getFunction(i).getType())));
            }
        }
        if (isPortal) {
            this.syncActions.add(4);
        } else {
            this.syncActions.add(2);
        }
    }

    private void processExec(long lo, long msgLimit, SqlCompiler compiler) throws PeerDisconnectedException, PeerIsSlowToReadException, QueryPausedException, BadProtocolException, SqlException {
        this.sqlExecutionContext.getCircuitBreaker().resetTimer();
        long hi = PGConnectionContext.getStringLength(lo, msgLimit, "bad portal name length");
        CharSequence portalName = this.getPortalName(lo, hi);
        if (portalName != null) {
            LOG.info().$("execute portal [name=").$(portalName).$(']').$();
        }
        lo = hi + 1L;
        int maxRows = PGConnectionContext.getInt(lo, msgLimit, "could not read max rows value");
        this.processSyncActions();
        this.processExecute(maxRows, compiler);
        this.wrapper = null;
    }

    private void processExecute(int maxRows, SqlCompiler compiler) throws PeerDisconnectedException, PeerIsSlowToReadException, QueryPausedException, SqlException {
        if (this.typesAndSelect != null) {
            LOG.debug().$("executing query").$();
            this.setupFactoryAndCursor(compiler);
            this.sendCursor(maxRows, this.resumeCursorExecuteRef, this.resumeCommandCompleteRef);
        } else if (this.typesAndInsert != null) {
            LOG.debug().$("executing insert").$();
            this.executeInsert(compiler);
        } else if (this.typesAndUpdate != null) {
            LOG.debug().$("executing update").$();
            this.executeUpdate(compiler);
        } else {
            this.executeTag();
            this.prepareCommandComplete(false);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processInitialMessage(long address, int len) throws PeerDisconnectedException, PeerIsSlowToReadException, BadProtocolException {
        if (len < 8) {
            return;
        }
        msgLen = PGConnectionContext.getIntUnsafe(address);
        if (msgLen > len) {
            return;
        }
        this.recvBufferReadOffset += (long)msgLen;
        protocol = PGConnectionContext.getIntUnsafe(address + 4L);
        switch (protocol) {
            case 80877103: {
                this.prepareSslResponse();
                this.sendAndReset();
                return;
            }
            case 80877104: {
                this.prepareGssResponse();
                this.sendAndReset();
                return;
            }
            case 196608: {
                this.requireInitialMessage = false;
                msgLimit = address + (long)msgLen;
                lo = address + 8L;
                PGConnectionContext.LOG.info().$("protocol [major=").$(protocol >> 16).$(", minor=").$((short)protocol).$(']').$();
                while (lo < msgLimit - 1L) {
                    nameLo = lo;
                    nameHi = PGConnectionContext.getStringLength(lo, msgLimit, "malformed property name");
                    valueLo = nameHi + 1L;
                    valueHi = PGConnectionContext.getStringLength(valueLo, msgLimit, "malformed property value");
                    lo = valueHi + 1L;
                    this.dbcs.of(nameLo, nameHi);
                    parsed = true;
                    if (Chars.equals(this.dbcs, "user")) {
                        e = this.characterStore.newEntry();
                        e.put(this.dbcs.of(valueLo, valueHi));
                        this.username = e.toImmutable();
                    }
                    if (!Chars.equals(this.dbcs, "options")) ** GOTO lbl50
                    this.dbcs.of(valueLo, valueHi);
                    if (!Chars.startsWith((CharSequence)this.dbcs, "-c statement_timeout=")) ** GOTO lbl49
                    try {
                        this.statementTimeout = Numbers.parseLong(this.dbcs.of(valueLo + (long)"-c statement_timeout=".length(), valueHi));
                        if (this.statementTimeout > 0L) {
                            this.circuitBreaker.setTimeout(this.statementTimeout);
                        }
                        ** GOTO lbl50
                    }
                    catch (NumericException ex) {
                        parsed = false;
                    }
                    ** GOTO lbl50
lbl49:
                    // 1 sources

                    parsed = false;
lbl50:
                    // 5 sources

                    if (parsed) {
                        PGConnectionContext.LOG.debug().$("property [name=").$(this.dbcs.of(nameLo, nameHi)).$(", value=").$(this.dbcs.of(valueLo, valueHi)).$(']').$();
                        continue;
                    }
                    PGConnectionContext.LOG.info().$("invalid property [name=").$(this.dbcs.of(nameLo, nameHi)).$(", value=").$(this.dbcs.of(valueLo, valueHi)).$(']').$();
                }
                this.characterStore.clear();
                this.assertTrue(this.username != null, "user is not specified");
                this.prepareLoginResponse();
                this.sendAndReset();
                break;
            }
            case 80877102: {
                PGConnectionContext.LOG.info().$("cancel request").$();
                throw PeerDisconnectedException.INSTANCE;
            }
            default: {
                PGConnectionContext.LOG.error().$("unknown init message [protocol=").$(protocol).$(']').$();
                throw BadProtocolException.INSTANCE;
            }
        }
    }

    private void processParse(long address, long lo, long msgLimit, SqlCompiler compiler) throws BadProtocolException, SqlException {
        this.sqlExecutionContext.getCircuitBreaker().resetTimer();
        this.syncActions.clear();
        long hi = PGConnectionContext.getStringLength(lo, msgLimit, "bad prepared statement name length");
        CharSequence statementName = this.getStatementName(lo, hi);
        lo = hi + 1L;
        hi = PGConnectionContext.getStringLength(lo, msgLimit, "bad query text length");
        this.parseQueryText(lo, hi, compiler);
        lo = hi + 1L;
        this.parsePhaseBindVariableCount = PGConnectionContext.getShort(lo, msgLimit, "could not read parameter type count");
        if (statementName != null) {
            LOG.info().$("prepare [name=").$(statementName).$(']').$();
            this.configurePreparedStatement(statementName);
        } else {
            this.activeBindVariableTypes = this.bindVariableTypes;
            this.activeSelectColumnTypes = this.selectColumnTypes;
        }
        if (this.parsePhaseBindVariableCount > 0) {
            if (lo + 2L + (long)this.parsePhaseBindVariableCount * 4L > msgLimit) {
                LOG.error().$("could not read parameters [parameterCount=").$(this.parsePhaseBindVariableCount).$(", offset=").$(lo - address).$(", remaining=").$(msgLimit - lo).$(']').$();
                throw BadProtocolException.INSTANCE;
            }
            LOG.debug().$("params [count=").$(this.parsePhaseBindVariableCount).$(']').$();
            PGConnectionContext.setupBindVariables(lo + 2L, this.activeBindVariableTypes, this.parsePhaseBindVariableCount);
        } else if (this.parsePhaseBindVariableCount < 0) {
            LOG.error().$("invalid parameter count [parameterCount=").$(this.parsePhaseBindVariableCount).$(", offset=").$(lo - address).$(']').$();
            throw BadProtocolException.INSTANCE;
        }
        if (this.typesAndSelect != null) {
            this.buildSelectColumnTypes();
        }
        this.syncActions.add(1);
    }

    private void processQuery(long lo, long limit, SqlCompiler compiler) throws PeerDisconnectedException, PeerIsSlowToReadException, QueryPausedException, BadProtocolException {
        block6: {
            this.prepareForNewQuery();
            CharacterStoreEntry e = this.characterStore.newEntry();
            if (Chars.utf8Decode(lo, limit - 1L, e)) {
                this.queryText = this.characterStore.toImmutable();
                try {
                    compiler.compileBatch(this.queryText, this.sqlExecutionContext, this.batchCallback);
                }
                catch (SqlException ex) {
                    this.prepareNonCriticalError(ex.getPosition(), ex.getFlyweightMessage());
                }
                catch (CairoException ex) {
                    if (ex.isInterruption()) {
                        this.prepareQueryCanceled(ex.getFlyweightMessage());
                        break block6;
                    }
                    this.prepareError(ex);
                }
            } else {
                LOG.error().$("invalid UTF8 bytes in parse query").$();
                throw BadProtocolException.INSTANCE;
            }
        }
        this.sendReadyForNewQuery();
    }

    private void processSyncActions() {
        try {
            int n = this.syncActions.size();
            block9: for (int i = 0; i < n; ++i) {
                switch (this.syncActions.getQuick(i)) {
                    case 1: {
                        this.prepareParseComplete();
                        continue block9;
                    }
                    case 2: {
                        this.prepareDescribeResponse();
                        continue block9;
                    }
                    case 3: {
                        this.prepareBindComplete();
                        continue block9;
                    }
                    case 4: {
                        this.prepareDescribePortalResponse();
                    }
                }
            }
        }
        finally {
            this.syncActions.clear();
        }
    }

    private void putGeoHashStringByteValue(Record rec, int col, int bitFlags) {
        byte l = rec.getGeoByte(col);
        this.putGeoHashStringValue(l, bitFlags);
    }

    private void putGeoHashStringIntValue(Record rec, int col, int bitFlags) {
        int l = rec.getGeoInt(col);
        this.putGeoHashStringValue(l, bitFlags);
    }

    private void putGeoHashStringLongValue(Record rec, int col, int bitFlags) {
        long l = rec.getGeoLong(col);
        this.putGeoHashStringValue(l, bitFlags);
    }

    private void putGeoHashStringShortValue(Record rec, int col, int bitFlags) {
        short l = rec.getGeoShort(col);
        this.putGeoHashStringValue(l, bitFlags);
    }

    private void putGeoHashStringValue(long value, int bitFlags) {
        if (value == -1L) {
            this.responseAsciiSink.setNullValue();
        } else {
            long a = this.responseAsciiSink.skip();
            if (bitFlags < 0) {
                GeoHashes.appendCharsUnsafe(value, -bitFlags, this.responseAsciiSink);
            } else {
                GeoHashes.appendBinaryStringUnsafe(value, bitFlags, this.responseAsciiSink);
            }
            this.responseAsciiSink.putLenEx(a);
        }
    }

    private void removeNamedStatement(CharSequence statementName) {
        int index;
        if (statementName != null && (index = this.namedStatementMap.keyIndex(statementName)) < 0) {
            this.namedStatementWrapperPool.push((NamedStatementWrapper)((Mutable)this.namedStatementMap.valueAt(index)));
            this.namedStatementMap.removeAt(index);
        }
    }

    private void reportError(CairoException ex) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.prepareError(ex);
        this.sendReadyForNewQuery();
        this.clearRecvBuffer();
    }

    private void reportNonCriticalError(int position, CharSequence flyweightMessage) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.prepareNonCriticalError(position, flyweightMessage);
        this.sendReadyForNewQuery();
        this.clearRecvBuffer();
    }

    private void reportQueryCancelled(CharSequence flyweightMessage) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.prepareQueryCanceled(flyweightMessage);
        this.sendReadyForNewQuery();
        this.clearRecvBuffer();
    }

    private void resumeCommandComplete(boolean queryWasPaused) {
        this.prepareCommandComplete(true);
    }

    private void resumeCursorExecute(boolean queryWasPaused) throws PeerDisconnectedException, PeerIsSlowToReadException, QueryPausedException, SqlException {
        Record record = this.currentCursor.getRecord();
        int columnCount = this.currentFactory.getMetadata().getColumnCount();
        if (!queryWasPaused) {
            this.appendSingleRecord(record, columnCount);
        }
        this.responseAsciiSink.bookmark();
        this.sendCursor0(record, columnCount, this.resumeCommandCompleteRef);
    }

    private void resumeCursorQuery(boolean queryWasPaused) throws PeerDisconnectedException, PeerIsSlowToReadException, QueryPausedException, SqlException {
        this.resumeCursorQuery0(queryWasPaused);
        this.sendReadyForNewQuery();
    }

    private void resumeCursorQuery0(boolean queryWasPaused) throws PeerDisconnectedException, PeerIsSlowToReadException, QueryPausedException, SqlException {
        Record record = this.currentCursor.getRecord();
        int columnCount = this.currentFactory.getMetadata().getColumnCount();
        if (!queryWasPaused) {
            this.appendSingleRecord(record, columnCount);
        }
        this.responseAsciiSink.bookmark();
        this.sendCursor0(record, columnCount, this.resumeQueryCompleteRef);
    }

    private void resumeQueryComplete(boolean queryWasPaused) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.prepareCommandComplete(true);
        this.sendReadyForNewQuery();
    }

    private void sendAndReset() throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.doSend(0, (int)(this.sendBufferPtr - this.sendBuffer));
        this.responseAsciiSink.reset();
    }

    private void sendCopyInResponse(CairoEngine engine, TextLoader textLoader) throws PeerDisconnectedException, PeerIsSlowToReadException {
        TableToken tableToken = engine.getTableTokenIfExists(textLoader.getTableName());
        if (0 == engine.getStatus(this.sqlExecutionContext.getCairoSecurityContext(), this.path, tableToken)) {
            this.responseAsciiSink.put((byte)71);
            long addr = this.responseAsciiSink.skip();
            this.responseAsciiSink.put((byte)0);
            try (TableWriter writer = engine.getWriter(this.sqlExecutionContext.getCairoSecurityContext(), tableToken, WRITER_LOCK_REASON);){
                TableRecordMetadata metadata = writer.getMetadata();
                this.responseAsciiSink.putNetworkShort((short)metadata.getColumnCount());
                int n = metadata.getColumnCount();
                for (int i = 0; i < n; ++i) {
                    this.responseAsciiSink.putNetworkShort((short)PGOids.getTypeOid(metadata.getColumnType(i)));
                }
            }
            this.responseAsciiSink.putLen(addr);
        } else {
            SqlException e = SqlException.$(0, "table does not exist [table=").put(textLoader.getTableName()).put(']');
            this.prepareNonCriticalError(e.getPosition(), e.getFlyweightMessage());
            this.prepareReadyForQuery();
        }
        this.sendAndReset();
    }

    private void sendCursor(int maxRows, PGResumeProcessor cursorResumeProcessor, PGResumeProcessor commandCompleteResumeProcessor) throws PeerDisconnectedException, PeerIsSlowToReadException, QueryPausedException, SqlException {
        this.rowCount = 0L;
        Record record = this.currentCursor.getRecord();
        RecordMetadata metadata = this.currentFactory.getMetadata();
        int columnCount = metadata.getColumnCount();
        long cursorRowCount = this.currentCursor.size();
        this.maxRows = maxRows > 0 ? Long.min(maxRows, cursorRowCount) : Long.MAX_VALUE;
        this.resumeProcessor = cursorResumeProcessor;
        this.responseAsciiSink.bookmark();
        this.sendCursor0(record, columnCount, commandCompleteResumeProcessor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendCursor0(Record record, int columnCount, PGResumeProcessor commandCompleteResumeProcessor) throws PeerDisconnectedException, PeerIsSlowToReadException, QueryPausedException, SqlException {
        if (!this.circuitBreaker.isTimerSet()) {
            this.circuitBreaker.resetTimer();
        }
        try {
            while (this.currentCursor.hasNext()) {
                try {
                    try {
                        this.appendRecord(record, columnCount);
                        this.responseAsciiSink.bookmark();
                    }
                    catch (NoSpaceLeftInResponseBufferException e) {
                        this.responseAsciiSink.resetToBookmark();
                        this.sendAndReset();
                        this.appendSingleRecord(record, columnCount);
                        this.responseAsciiSink.bookmark();
                    }
                    if (this.rowCount < this.maxRows) continue;
                    break;
                }
                catch (SqlException e) {
                    this.clearCursorAndFactory();
                    this.responseAsciiSink.resetToBookmark();
                    throw e;
                }
            }
        }
        catch (DataUnavailableException e) {
            this.isPausedQuery = true;
            this.responseAsciiSink.resetToBookmark();
            throw QueryPausedException.instance(e.getEvent(), this.sqlExecutionContext.getCircuitBreaker());
        }
        boolean bl = this.completed = this.maxRows <= 0L || this.rowCount < this.maxRows;
        if (!this.completed) {
            this.prepareSuspended();
            this.resumeProcessor = null;
            return;
        }
        this.clearCursorAndFactory();
        if (this.sendBufferLimit - this.sendBufferPtr < 64L) {
            this.resumeProcessor = commandCompleteResumeProcessor;
            this.sendAndReset();
        }
        this.prepareCommandComplete(true);
    }

    private void sendReadyForNewQuery() throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.prepareReadyForQuery();
        this.sendAndReset();
    }

    private void setUuidBindVariable(int index, long address, int valueLen) throws BadProtocolException, SqlException {
        PGConnectionContext.ensureValueLength(index, 16, valueLen);
        long hi = PGConnectionContext.getLongUnsafe(address);
        long lo = PGConnectionContext.getLongUnsafe(address + 8L);
        this.bindVariableService.setUuid(index, lo, hi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupFactoryAndCursor(SqlCompiler compiler) throws SqlException {
        if (this.currentCursor == null) {
            boolean recompileStale = true;
            SqlExecutionCircuitBreaker circuitBreaker = this.sqlExecutionContext.getCircuitBreaker();
            try {
                if (!circuitBreaker.isTimerSet()) {
                    circuitBreaker.resetTimer();
                }
                int retries = 0;
                while (recompileStale) {
                    this.currentFactory = this.typesAndSelect.getFactory();
                    try {
                        this.currentCursor = this.currentFactory.getCursor(this.sqlExecutionContext);
                        recompileStale = false;
                        this.rnd = this.sqlExecutionContext.getRandom();
                    }
                    catch (TableReferenceOutOfDateException e) {
                        if (retries == 10) {
                            throw e;
                        }
                        LOG.info().$(e.getFlyweightMessage()).$();
                        this.freeFactory();
                        this.compileQuery(compiler);
                        this.buildSelectColumnTypes();
                        this.applyLatestBindColumnFormats();
                    }
                    catch (Throwable e) {
                        this.freeFactory();
                        throw e;
                    }
                    ++retries;
                }
            }
            finally {
                circuitBreaker.unsetTimer();
            }
        }
    }

    private void setupVariableSettersFromWrapper(NamedStatementWrapper wrapper, @Nullable SqlCompiler compiler) throws SqlException {
        this.queryText = wrapper.queryText;
        LOG.debug().$("wrapper query [q=`").$(wrapper.queryText).$("`]").$();
        this.activeBindVariableTypes = wrapper.bindVariableTypes;
        this.parsePhaseBindVariableCount = wrapper.bindVariableTypes.size();
        this.activeSelectColumnTypes = wrapper.selectColumnTypes;
        if (!wrapper.alreadyExecuted && this.compileQuery(compiler) && this.typesAndSelect != null) {
            this.buildSelectColumnTypes();
        }
        wrapper.alreadyExecuted = false;
    }

    private void shiftReceiveBuffer(long readOffsetBeforeParse) {
        long len = this.recvBufferWriteOffset - readOffsetBeforeParse;
        LOG.debug().$("shift [offset=").$(readOffsetBeforeParse).$(", len=").$(len).$(']').$();
        Vect.memcpy(this.recvBuffer, this.recvBuffer + readOffsetBeforeParse, len);
        this.recvBufferWriteOffset = len;
        this.recvBufferReadOffset = 0L;
    }

    private void validateParameterCounts(short parameterFormatCount, short parameterValueCount, int parameterTypeCount) throws BadProtocolException {
        if (parameterValueCount > 0) {
            if (parameterValueCount < parameterTypeCount) {
                LOG.error().$("parameter type count must be less or equals to number of parameters values").$();
                throw BadProtocolException.INSTANCE;
            }
            if (parameterFormatCount > 1 && parameterFormatCount != parameterValueCount) {
                LOG.error().$("parameter format count and parameter value count must match").$();
                throw BadProtocolException.INSTANCE;
            }
        }
    }

    void clearRecvBuffer() {
        this.recvBufferWriteOffset = 0L;
        this.recvBufferReadOffset = 0L;
    }

    int doReceive(int remaining) {
        long data = this.recvBuffer + this.recvBufferWriteOffset;
        int n = this.nf.recv(this.getFd(), data, remaining);
        this.dumpBuffer('>', data, n);
        return n;
    }

    void doSend(int offset, int size) throws PeerDisconnectedException, PeerIsSlowToReadException {
        int n = this.nf.send(this.getFd(), this.sendBuffer + (long)offset, size);
        this.dumpBuffer('<', this.sendBuffer + (long)offset, n);
        if (n < 0) {
            throw PeerDisconnectedException.INSTANCE;
        }
        if (n < size) {
            this.doSendWithRetries(offset + n, size - n);
        }
        this.sendBufferPtr = this.sendBuffer;
        this.bufferRemainingSize = 0;
        this.bufferRemainingOffset = 0;
    }

    void prepareCommandComplete(boolean addRowCount) {
        if (this.isEmptyQuery) {
            LOG.debug().$("empty").$();
            this.responseAsciiSink.put((byte)73);
            this.responseAsciiSink.putIntDirect(INT_BYTES_X);
        } else {
            this.responseAsciiSink.put((byte)67);
            long addr = this.responseAsciiSink.skip();
            if (addRowCount) {
                if (this.queryTag == TAG_INSERT) {
                    LOG.debug().$("insert [rowCount=").$(this.rowCount).$(']').$();
                    this.responseAsciiSink.encodeUtf8(this.queryTag).put(" 0 ").put(this.rowCount).put('\u0000');
                } else {
                    LOG.debug().$("other [rowCount=").$(this.rowCount).$(']').$();
                    this.responseAsciiSink.encodeUtf8(this.queryTag).put(' ').put(this.rowCount).put('\u0000');
                }
            } else {
                LOG.debug().$("no row count").$();
                this.responseAsciiSink.encodeUtf8(this.queryTag).put('\u0000');
            }
            this.responseAsciiSink.putLen(addr);
        }
    }

    void prepareReadyForQuery() {
        if (this.sendRNQ) {
            LOG.debug().$("RNQ sent").$();
            this.responseAsciiSink.put((byte)90);
            this.responseAsciiSink.putNetworkInt(5);
            switch (this.transactionState) {
                case 1: {
                    this.responseAsciiSink.put('T');
                    break;
                }
                case 3: {
                    this.responseAsciiSink.put('E');
                    break;
                }
                default: {
                    this.responseAsciiSink.put('I');
                }
            }
            this.sendRNQ = false;
        }
    }

    void prepareSuspended() {
        LOG.debug().$("suspended").$();
        this.responseAsciiSink.put((byte)115);
        this.responseAsciiSink.putIntDirect(INT_BYTES_X);
    }

    int recv() throws PeerDisconnectedException, PeerIsSlowToWriteException, BadProtocolException {
        int remaining = (int)((long)this.recvBufferSize - this.recvBufferWriteOffset);
        this.assertTrue(remaining > 0, "undersized receive buffer or someone is abusing protocol");
        int n = this.doReceive(remaining);
        LOG.debug().$("recv [n=").$(n).$(']').$();
        if (n < 0) {
            LOG.info().$("disconnected on read [code=").$(n).$(']').$();
            throw PeerDisconnectedException.INSTANCE;
        }
        if (n == 0) {
            throw PeerIsSlowToWriteException.INSTANCE;
        }
        this.recvBufferWriteOffset += (long)n;
        return n;
    }

    class ResponseAsciiSink
    extends AbstractCharSink {
        private long bookmarkPtr = -1L;

        ResponseAsciiSink() {
        }

        public void bookmark() {
            this.bookmarkPtr = PGConnectionContext.this.sendBufferPtr;
        }

        public void bump(int size) {
            PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBufferPtr + (long)size;
        }

        @Override
        public CharSink put(CharSequence cs) {
            int len;
            if (cs != null && (len = cs.length()) > 0) {
                this.ensureCapacity(len);
                for (int i = 0; i < len; ++i) {
                    Unsafe.getUnsafe().putByte(PGConnectionContext.this.sendBufferPtr + (long)i, (byte)cs.charAt(i));
                }
                PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBufferPtr + (long)len;
            }
            return this;
        }

        @Override
        public CharSink put(char c) {
            this.ensureCapacity(1);
            Unsafe.getUnsafe().putByte(PGConnectionContext.this.sendBufferPtr++, (byte)c);
            return this;
        }

        @Override
        public CharSink put(char[] chars, int start, int len) {
            this.ensureCapacity(len);
            Chars.asciiCopyTo(chars, start, len, PGConnectionContext.this.sendBufferPtr);
            PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBufferPtr + (long)len;
            return this;
        }

        public CharSink put(byte b) {
            this.ensureCapacity(1);
            Unsafe.getUnsafe().putByte(PGConnectionContext.this.sendBufferPtr++, b);
            return this;
        }

        public void put(BinarySequence sequence) {
            long len = sequence.length();
            if (len > (long)PGConnectionContext.this.maxBlobSizeOnQuery) {
                this.setNullValue();
            } else {
                this.ensureCapacity((int)(len + 4L));
                PGConnectionContext.putInt(PGConnectionContext.this.sendBufferPtr, (int)len);
                PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBufferPtr + 4L;
                for (long x = 0L; x < len; ++x) {
                    Unsafe.getUnsafe().putByte(PGConnectionContext.this.sendBufferPtr + x, sequence.byteAt(x));
                }
                PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBufferPtr + len;
            }
        }

        public void putIntDirect(int value) {
            this.ensureCapacity(4);
            this.putIntUnsafe(0L, value);
            PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBufferPtr + 4L;
        }

        public void putIntUnsafe(long offset, int value) {
            Unsafe.getUnsafe().putInt(PGConnectionContext.this.sendBufferPtr + offset, value);
        }

        public void putLen(long start) {
            PGConnectionContext.putInt(start, (int)(PGConnectionContext.this.sendBufferPtr - start));
        }

        public void putLenEx(long start) {
            PGConnectionContext.putInt(start, (int)(PGConnectionContext.this.sendBufferPtr - start - 4L));
        }

        public void putNetworkDouble(double value) {
            this.ensureCapacity(8);
            Unsafe.getUnsafe().putDouble(PGConnectionContext.this.sendBufferPtr, Double.longBitsToDouble(Numbers.bswap(Double.doubleToLongBits(value))));
            PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBufferPtr + 8L;
        }

        public void putNetworkFloat(float value) {
            this.ensureCapacity(4);
            Unsafe.getUnsafe().putFloat(PGConnectionContext.this.sendBufferPtr, Float.intBitsToFloat(Numbers.bswap(Float.floatToIntBits(value))));
            PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBufferPtr + 4L;
        }

        public void putNetworkInt(int value) {
            this.ensureCapacity(4);
            PGConnectionContext.putInt(PGConnectionContext.this.sendBufferPtr, value);
            PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBufferPtr + 4L;
        }

        public void putNetworkLong(long value) {
            this.ensureCapacity(8);
            PGConnectionContext.putLong(PGConnectionContext.this.sendBufferPtr, value);
            PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBufferPtr + 8L;
        }

        public void putNetworkShort(short value) {
            this.ensureCapacity(2);
            PGConnectionContext.putShort(PGConnectionContext.this.sendBufferPtr, value);
            PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBufferPtr + 2L;
        }

        public void resetToBookmark() {
            assert (this.bookmarkPtr != -1L);
            PGConnectionContext.this.sendBufferPtr = this.bookmarkPtr;
            this.bookmarkPtr = -1L;
        }

        private void ensureCapacity(int size) {
            if (PGConnectionContext.this.sendBufferPtr + (long)size < PGConnectionContext.this.sendBufferLimit) {
                return;
            }
            throw NoSpaceLeftInResponseBufferException.INSTANCE;
        }

        void encodeUtf8Z(CharSequence value) {
            this.encodeUtf8(value);
            this.ensureCapacity(1);
            Unsafe.getUnsafe().putByte(PGConnectionContext.this.sendBufferPtr++, (byte)0);
        }

        void reset() {
            PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBuffer;
        }

        void setNullValue() {
            this.putIntDirect(INT_NULL_X);
        }

        long skip() {
            this.ensureCapacity(4);
            long checkpoint = PGConnectionContext.this.sendBufferPtr;
            PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBufferPtr + 4L;
            return checkpoint;
        }
    }

    class PGConnectionBatchCallback
    implements BatchCallback {
        PGConnectionBatchCallback() {
        }

        @Override
        public void postCompile(SqlCompiler compiler, CompiledQuery cq, CharSequence text) throws PeerIsSlowToReadException, PeerDisconnectedException, QueryPausedException, SqlException {
            try {
                PGConnectionContext.this.queryText = text;
                LOG.info().$("parse [fd=").$(PGConnectionContext.this.fd).$(", q=").utf8(text).I$();
                PGConnectionContext.this.processCompiledQuery(cq);
                if (PGConnectionContext.this.typesAndSelect != null) {
                    PGConnectionContext.this.activeSelectColumnTypes = PGConnectionContext.this.selectColumnTypes;
                    PGConnectionContext.this.buildSelectColumnTypes();
                    assert (PGConnectionContext.this.queryText != null);
                    PGConnectionContext.this.queryTag = PGConnectionContext.TAG_SELECT;
                    PGConnectionContext.this.setupFactoryAndCursor(compiler);
                    PGConnectionContext.this.prepareRowDescription();
                    PGConnectionContext.this.sendCursor(0, PGConnectionContext.this.resumeCursorQueryRef, PGConnectionContext.this.resumeQueryCompleteRef);
                } else if (PGConnectionContext.this.typesAndInsert != null) {
                    PGConnectionContext.this.executeInsert(compiler);
                } else if (PGConnectionContext.this.typesAndUpdate != null) {
                    PGConnectionContext.this.executeUpdate(compiler);
                } else if (cq.getType() == 10 || cq.getType() == 21) {
                    PGConnectionContext.this.prepareCommandComplete(true);
                } else {
                    PGConnectionContext.this.executeTag();
                    PGConnectionContext.this.prepareCommandComplete(false);
                }
                PGConnectionContext.this.sqlExecutionContext.getCircuitBreaker().unsetTimer();
            }
            catch (QueryPausedException e) {
                throw e;
            }
            catch (Exception e) {
                PGConnectionContext.this.sqlExecutionContext.getCircuitBreaker().unsetTimer();
                throw e;
            }
        }

        @Override
        public void preCompile(SqlCompiler compiler) {
            PGConnectionContext.this.sendRNQ = true;
            PGConnectionContext.this.prepareForNewBatchQuery();
            PGConnectionContext.this.typesAndInsert = null;
            PGConnectionContext.this.typesAndUpdate = null;
            PGConnectionContext.this.typesAndSelect = null;
            PGConnectionContext.this.circuitBreaker.resetTimer();
        }
    }

    public static class Portal
    implements Mutable {
        public CharSequence statementName = null;

        @Override
        public void clear() {
            this.statementName = null;
        }
    }

    public static class NamedStatementWrapper
    implements Mutable {
        public final IntList bindVariableTypes = new IntList();
        public final IntList selectColumnTypes = new IntList();
        public boolean alreadyExecuted = false;
        public CharSequence queryText = null;

        @Override
        public void clear() {
            this.queryText = null;
            this.bindVariableTypes.clear();
            this.selectColumnTypes.clear();
        }
    }

    @FunctionalInterface
    private static interface PGResumeProcessor {
        public void resume(boolean var1) throws PeerIsSlowToReadException, PeerDisconnectedException, QueryPausedException, SqlException;
    }
}

