/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.map;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.map.FastMapCursor;
import io.questdb.cairo.map.FastMapRecord;
import io.questdb.cairo.map.FastMapValue;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.griffin.engine.LimitOverflowException;
import io.questdb.std.BinarySequence;
import io.questdb.std.DirectLongList;
import io.questdb.std.Hash;
import io.questdb.std.Long256;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FastMap
implements Map,
Reopenable {
    private static final long MAX_HEAP_SIZE = Integer.toUnsignedLong(-1) - 1L << 3;
    private static final int MIN_INITIAL_CAPACITY = 128;
    private static final long OFFSET_SLOT_SIZE = 2L;
    private final FastMapCursor cursor;
    private final int initialKeyCapacity;
    private final int initialPageSize;
    private final BaseKey key;
    private final int keyOffset;
    private final int keySize;
    private final int listMemoryTag;
    private final double loadFactor;
    private final int mapMemoryTag;
    private final int maxResizes;
    private final FastMapRecord record;
    private final FastMapValue value;
    private final FastMapValue value2;
    private final FastMapValue value3;
    private final int valueColumnCount;
    private final int valueSize;
    private long capacity;
    private int free;
    private long kLimit;
    private long kPos;
    private long kStart;
    private int keyCapacity;
    private int mask;
    private int nResizes;
    private DirectLongList offsets;
    private int size = 0;

    public FastMap(int pageSize, @NotNull ColumnTypes keyTypes, int keyCapacity, double loadFactor, int maxResizes) {
        this(pageSize, keyTypes, null, keyCapacity, loadFactor, maxResizes);
    }

    public FastMap(int pageSize, @NotNull ColumnTypes keyTypes, @Nullable ColumnTypes valueTypes, int keyCapacity, double loadFactor, int maxResizes, int memoryTag) {
        this(pageSize, keyTypes, valueTypes, keyCapacity, loadFactor, maxResizes, memoryTag, memoryTag);
    }

    public FastMap(int pageSize, @NotNull ColumnTypes keyTypes, @Nullable ColumnTypes valueTypes, int keyCapacity, double loadFactor, int maxResizes) {
        this(pageSize, keyTypes, valueTypes, keyCapacity, loadFactor, maxResizes, 9, 10);
    }

    FastMap(int pageSize, @NotNull ColumnTypes keyTypes, @Nullable ColumnTypes valueTypes, int keyCapacity, double loadFactor, int maxResizes, int mapMemoryTag, int listMemoryTag) {
        assert (pageSize > 3);
        assert (loadFactor > 0.0 && loadFactor < 1.0);
        this.mapMemoryTag = mapMemoryTag;
        this.listMemoryTag = listMemoryTag;
        this.initialKeyCapacity = keyCapacity;
        this.initialPageSize = pageSize;
        this.loadFactor = loadFactor;
        this.capacity = pageSize;
        this.kStart = this.kPos = Unsafe.malloc(this.capacity, mapMemoryTag);
        this.kLimit = this.kStart + (long)pageSize;
        this.keyCapacity = (int)((double)keyCapacity / loadFactor);
        this.keyCapacity = this.keyCapacity < 128 ? 128 : Numbers.ceilPow2(this.keyCapacity);
        this.mask = this.keyCapacity - 1;
        this.free = (int)((double)this.keyCapacity * loadFactor);
        this.offsets = new DirectLongList(this.keyCapacity, listMemoryTag);
        this.offsets.setPos(this.keyCapacity);
        this.offsets.zero(0L);
        this.nResizes = 0;
        this.maxResizes = maxResizes;
        int keyColumnCount = keyTypes.getColumnCount();
        int keySize = 0;
        for (int i = 0; i < keyColumnCount; ++i) {
            int columnType = keyTypes.getColumnType(i);
            int size = ColumnType.sizeOf(columnType);
            if (size > 0) {
                keySize += size;
                continue;
            }
            keySize = -1;
            break;
        }
        this.keySize = keySize;
        int offset = keySize != -1 ? 0 : 4;
        int[] valueOffsets = null;
        int valueSize = 0;
        if (valueTypes != null) {
            this.valueColumnCount = valueTypes.getColumnCount();
            valueOffsets = new int[this.valueColumnCount];
            for (int i = 0; i < this.valueColumnCount; ++i) {
                valueOffsets[i] = offset;
                int columnType = valueTypes.getColumnType(i);
                int size = ColumnType.sizeOf(columnType);
                if (size <= 0) {
                    this.close();
                    throw CairoException.nonCritical().put("value type is not supported: ").put(ColumnType.nameOf(columnType));
                }
                offset += size;
                valueSize += size;
            }
        } else {
            this.valueColumnCount = 0;
        }
        this.valueSize = valueSize;
        this.keyOffset = offset;
        this.value = new FastMapValue(valueOffsets);
        this.value2 = new FastMapValue(valueOffsets);
        this.value3 = new FastMapValue(valueOffsets);
        this.record = new FastMapRecord(valueOffsets, this.keyOffset, this.value, keyTypes, valueTypes);
        assert ((long)(keySize + valueSize) < this.kLimit - this.kStart) : "page size is too small to fit a single key";
        this.cursor = new FastMapCursor(this.record, this);
        this.key = keySize == -1 ? new VarSizeKey() : new FixedSizeKey();
    }

    @Override
    public void clear() {
        this.kPos = this.kStart;
        this.free = (int)((double)this.keyCapacity * this.loadFactor);
        this.size = 0;
        this.offsets.zero(0L);
    }

    @Override
    public final void close() {
        Misc.free(this.offsets);
        if (this.kStart != 0L) {
            Unsafe.free(this.kStart, this.capacity, this.mapMemoryTag);
            this.kPos = 0L;
            this.kStart = 0L;
            this.kLimit = 0L;
            this.free = 0;
            this.size = 0;
            this.capacity = 0L;
        }
    }

    public long getAreaSize() {
        return this.kLimit - this.kStart;
    }

    @Override
    public RecordCursor getCursor() {
        return this.cursor.init(this.kStart, this.kLimit, this.size);
    }

    public int getKeyCapacity() {
        return this.keyCapacity;
    }

    @Override
    public MapRecord getRecord() {
        return this.record;
    }

    @Override
    public void reopen() {
        if (this.kStart == 0L) {
            this.restoreInitialCapacity();
        }
    }

    @Override
    public void restoreInitialCapacity() {
        this.capacity = this.initialPageSize;
        this.kStart = this.kPos = Unsafe.realloc(this.kStart, this.kLimit - this.kStart, this.capacity, this.mapMemoryTag);
        this.kLimit = this.kStart + (long)this.initialPageSize;
        this.keyCapacity = (int)((double)this.initialKeyCapacity / this.loadFactor);
        this.keyCapacity = this.keyCapacity < 128 ? 128 : Numbers.ceilPow2(this.keyCapacity);
        this.mask = this.keyCapacity - 1;
        this.free = (int)((double)this.keyCapacity * this.loadFactor);
        this.offsets.resetCapacity();
        this.offsets.setCapacity(this.keyCapacity);
        this.offsets.setPos(this.keyCapacity);
        this.offsets.zero(0L);
        this.nResizes = 0;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public MapValue valueAt(long address) {
        return this.valueOf(address, false, this.value);
    }

    @Override
    public MapKey withKey() {
        return this.key.init();
    }

    private static long getPackedOffset(DirectLongList offsets, int index) {
        return offsets.get(index);
    }

    private static void setPackedOffset(DirectLongList offsets, int index, long offset, int hashCode) {
        offsets.set(index, Numbers.encodeLowHighInts((int)((offset >> 3) + 1L), hashCode));
    }

    private static void setPackedOffset(DirectLongList offsets, int index, long packedOffset) {
        offsets.set(index, packedOffset);
    }

    private static int unpackHashCode(long packedOffset) {
        return Numbers.decodeHighInt(packedOffset);
    }

    private static long unpackOffset(long packedOffset) {
        return Integer.toUnsignedLong(Numbers.decodeLowInt(packedOffset)) - 1L << 3;
    }

    private FastMapValue asNew(BaseKey keyWriter, int index, int hashCode, FastMapValue value) {
        this.kPos = keyWriter.appendAddress;
        if ((this.kPos & 7L) != 0L) {
            this.kPos |= 7L;
            ++this.kPos;
        }
        FastMap.setPackedOffset(this.offsets, index, keyWriter.startAddress - this.kStart, hashCode);
        if (--this.free == 0) {
            this.rehash();
        }
        ++this.size;
        return this.valueOf(keyWriter.startAddress, true, value);
    }

    private FastMapValue probe0(BaseKey keyWriter, int index, int hashCode, FastMapValue value) {
        block1: {
            long offset;
            long packedOffset;
            do {
                ++index;
                packedOffset = FastMap.getPackedOffset(this.offsets, index &= this.mask);
                offset = FastMap.unpackOffset(packedOffset);
                if (offset <= -1L) break block1;
            } while (hashCode != FastMap.unpackHashCode(packedOffset) || !keyWriter.eq(offset));
            return this.valueOf(this.kStart + offset, false, value);
        }
        return this.asNew(keyWriter, index, hashCode, value);
    }

    private FastMapValue probeReadOnly(BaseKey keyWriter, int index, long hashCode, FastMapValue value) {
        block1: {
            long offset;
            long packedOffset;
            do {
                ++index;
                packedOffset = FastMap.getPackedOffset(this.offsets, index &= this.mask);
                offset = FastMap.unpackOffset(packedOffset);
                if (offset <= -1L) break block1;
            } while (hashCode != (long)FastMap.unpackHashCode(packedOffset) || !keyWriter.eq(offset));
            return this.valueOf(this.kStart + offset, false, value);
        }
        return null;
    }

    private void rehash() {
        int capacity = this.keyCapacity << 1;
        this.mask = capacity - 1;
        DirectLongList newOffsets = new DirectLongList(capacity, this.listMemoryTag);
        newOffsets.setPos(capacity);
        newOffsets.zero(0L);
        int k = (int)this.offsets.size();
        for (int i = 0; i < k; ++i) {
            long packedOffset = FastMap.getPackedOffset(this.offsets, i);
            long offset = FastMap.unpackOffset(packedOffset);
            if (offset < 0L) continue;
            int hashCode = FastMap.unpackHashCode(packedOffset);
            int index = hashCode & this.mask;
            while (FastMap.unpackOffset(FastMap.getPackedOffset(newOffsets, index)) > -1L) {
                index = index + 1 & this.mask;
            }
            FastMap.setPackedOffset(newOffsets, index, packedOffset);
        }
        this.offsets.close();
        this.offsets = newOffsets;
        this.free = (int)((double)this.free + (double)(capacity - this.keyCapacity) * this.loadFactor);
        this.keyCapacity = capacity;
    }

    private void resize(int size) {
        long kAddress;
        long kCapacity;
        if (this.nResizes < this.maxResizes) {
            ++this.nResizes;
            kCapacity = this.kLimit - this.kStart << 1;
            long target = this.key.appendAddress + (long)size - this.kStart;
            if (kCapacity < target) {
                kCapacity = Numbers.ceilPow2(target);
            }
            if (kCapacity > MAX_HEAP_SIZE) {
                throw LimitOverflowException.instance().put("limit of ").put(MAX_HEAP_SIZE).put(" memory exceeded in FastMap");
            }
            kAddress = Unsafe.realloc(this.kStart, this.capacity, kCapacity, this.mapMemoryTag);
            this.capacity = kCapacity;
            long d = kAddress - this.kStart;
            this.kPos += d;
            this.key.startAddress += d;
            this.key.appendAddress += d;
            assert (this.kPos > 0L);
            assert (this.key.startAddress > 0L);
            assert (this.key.appendAddress > 0L);
        } else {
            throw LimitOverflowException.instance().put("limit of ").put(this.maxResizes).put(" resizes exceeded in FastMap");
        }
        this.kStart = kAddress;
        this.kLimit = kAddress + kCapacity;
    }

    private FastMapValue valueOf(long address, boolean newValue, FastMapValue value) {
        return value.of(address, this.kLimit, newValue);
    }

    long getAppendOffset() {
        return this.kPos;
    }

    int getValueColumnCount() {
        return this.valueColumnCount;
    }

    int keySize() {
        return this.keySize;
    }

    int valueSize() {
        return this.valueSize;
    }

    private class VarSizeKey
    extends BaseKey {
        private int len;

        private VarSizeKey() {
        }

        @Override
        public void putBin(BinarySequence value) {
            if (value == null) {
                this.putNull();
            } else {
                long len = value.length() + 4L;
                if (len > Integer.MAX_VALUE) {
                    throw CairoException.nonCritical().put("binary column is too large");
                }
                this.checkSize((int)len);
                int l = (int)(len - 4L);
                Unsafe.getUnsafe().putInt(this.appendAddress, l);
                value.copyTo(this.appendAddress + 4L, 0L, l);
                this.appendAddress += len;
            }
        }

        @Override
        public void putBool(boolean value) {
            this.checkSize(1);
            Unsafe.getUnsafe().putByte(this.appendAddress, (byte)(value ? 1 : 0));
            ++this.appendAddress;
        }

        @Override
        public void putByte(byte value) {
            this.checkSize(1);
            Unsafe.getUnsafe().putByte(this.appendAddress, value);
            ++this.appendAddress;
        }

        @Override
        public void putChar(char value) {
            this.checkSize(2);
            Unsafe.getUnsafe().putChar(this.appendAddress, value);
            this.appendAddress += 2L;
        }

        @Override
        public void putDate(long value) {
            this.putLong(value);
        }

        @Override
        public void putDouble(double value) {
            this.checkSize(8);
            Unsafe.getUnsafe().putDouble(this.appendAddress, value);
            this.appendAddress += 8L;
        }

        @Override
        public void putFloat(float value) {
            this.checkSize(4);
            Unsafe.getUnsafe().putFloat(this.appendAddress, value);
            this.appendAddress += 4L;
        }

        @Override
        public void putInt(int value) {
            this.checkSize(4);
            Unsafe.getUnsafe().putInt(this.appendAddress, value);
            this.appendAddress += 4L;
        }

        @Override
        public void putLong(long value) {
            this.checkSize(8);
            Unsafe.getUnsafe().putLong(this.appendAddress, value);
            this.appendAddress += 8L;
        }

        @Override
        public void putLong128(long lo, long hi) {
            this.checkSize(16);
            Unsafe.getUnsafe().putLong(this.appendAddress, lo);
            Unsafe.getUnsafe().putLong(this.appendAddress + 8L, hi);
            this.appendAddress += 16L;
        }

        @Override
        public void putLong256(Long256 value) {
            this.checkSize(32);
            Unsafe.getUnsafe().putLong(this.appendAddress, value.getLong0());
            Unsafe.getUnsafe().putLong(this.appendAddress + 8L, value.getLong1());
            Unsafe.getUnsafe().putLong(this.appendAddress + 16L, value.getLong2());
            Unsafe.getUnsafe().putLong(this.appendAddress + 24L, value.getLong3());
            this.appendAddress += 32L;
        }

        @Override
        public void putShort(short value) {
            this.checkSize(2);
            Unsafe.getUnsafe().putShort(this.appendAddress, value);
            this.appendAddress += 2L;
        }

        @Override
        public void putStr(CharSequence value) {
            if (value == null) {
                this.putNull();
                return;
            }
            int len = value.length();
            this.checkSize((len << 1) + 4);
            Unsafe.getUnsafe().putInt(this.appendAddress, len);
            this.appendAddress += 4L;
            for (int i = 0; i < len; ++i) {
                Unsafe.getUnsafe().putChar(this.appendAddress + ((long)i << 1), value.charAt(i));
            }
            this.appendAddress += (long)len << 1;
        }

        @Override
        public void putStr(CharSequence value, int lo, int hi) {
            int len = hi - lo;
            this.checkSize((len << 1) + 4);
            Unsafe.getUnsafe().putInt(this.appendAddress, len);
            this.appendAddress += 4L;
            for (int i = lo; i < hi; ++i) {
                Unsafe.getUnsafe().putChar(this.appendAddress + ((long)(i - lo) << 1), value.charAt(i));
            }
            this.appendAddress += (long)len << 1;
        }

        @Override
        public void putStrLowerCase(CharSequence value) {
            if (value == null) {
                this.putNull();
                return;
            }
            int len = value.length();
            this.checkSize((len << 1) + 4);
            Unsafe.getUnsafe().putInt(this.appendAddress, len);
            this.appendAddress += 4L;
            for (int i = 0; i < len; ++i) {
                Unsafe.getUnsafe().putChar(this.appendAddress + ((long)i << 1), Character.toLowerCase(value.charAt(i)));
            }
            this.appendAddress += (long)len << 1;
        }

        @Override
        public void putStrLowerCase(CharSequence value, int lo, int hi) {
            int len = hi - lo;
            this.checkSize((len << 1) + 4);
            Unsafe.getUnsafe().putInt(this.appendAddress, len);
            this.appendAddress += 4L;
            for (int i = lo; i < hi; ++i) {
                Unsafe.getUnsafe().putChar(this.appendAddress + ((long)(i - lo) << 1), Character.toLowerCase(value.charAt(i)));
            }
            this.appendAddress += (long)len << 1;
        }

        @Override
        public void putTimestamp(long value) {
            this.putLong(value);
        }

        @Override
        public void skip(int bytes) {
            this.checkSize(bytes);
            this.appendAddress += (long)bytes;
        }

        private void putNull() {
            this.checkSize(4);
            Unsafe.getUnsafe().putInt(this.appendAddress, -1);
            this.appendAddress += 4L;
        }

        @Override
        protected void commit() {
            this.len = (int)(this.appendAddress - this.startAddress);
            Unsafe.getUnsafe().putInt(this.startAddress, this.len);
        }

        @Override
        protected boolean eq(long offset) {
            long a = FastMap.this.kStart + offset;
            long b = this.startAddress;
            if (Unsafe.getUnsafe().getInt(a) != Unsafe.getUnsafe().getInt(b)) {
                return false;
            }
            return Vect.memeq(a + (long)FastMap.this.keyOffset, b + (long)FastMap.this.keyOffset, this.len - FastMap.this.keyOffset);
        }

        @Override
        protected int hash() {
            return Hash.hashMem32(this.startAddress + (long)FastMap.this.keyOffset, this.len - FastMap.this.keyOffset);
        }
    }

    private class FixedSizeKey
    extends BaseKey {
        private FixedSizeKey() {
        }

        @Override
        public FixedSizeKey init() {
            super.init();
            this.checkSize(FastMap.this.keySize + FastMap.this.valueSize);
            return this;
        }

        @Override
        public void putBin(BinarySequence value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putBool(boolean value) {
            assert (this.appendAddress + 1L <= FastMap.this.kLimit);
            Unsafe.getUnsafe().putByte(this.appendAddress, (byte)(value ? 1 : 0));
            ++this.appendAddress;
        }

        @Override
        public void putByte(byte value) {
            assert (this.appendAddress + 1L <= FastMap.this.kLimit);
            Unsafe.getUnsafe().putByte(this.appendAddress, value);
            ++this.appendAddress;
        }

        @Override
        public void putChar(char value) {
            assert (this.appendAddress + 2L <= FastMap.this.kLimit);
            Unsafe.getUnsafe().putChar(this.appendAddress, value);
            this.appendAddress += 2L;
        }

        @Override
        public void putDate(long value) {
            this.putLong(value);
        }

        @Override
        public void putDouble(double value) {
            assert (this.appendAddress + 8L <= FastMap.this.kLimit);
            Unsafe.getUnsafe().putDouble(this.appendAddress, value);
            this.appendAddress += 8L;
        }

        @Override
        public void putFloat(float value) {
            assert (this.appendAddress + 4L <= FastMap.this.kLimit);
            Unsafe.getUnsafe().putFloat(this.appendAddress, value);
            this.appendAddress += 4L;
        }

        @Override
        public void putInt(int value) {
            assert (this.appendAddress + 4L <= FastMap.this.kLimit);
            Unsafe.getUnsafe().putInt(this.appendAddress, value);
            this.appendAddress += 4L;
        }

        @Override
        public void putLong(long value) {
            assert (this.appendAddress + 8L <= FastMap.this.kLimit);
            Unsafe.getUnsafe().putLong(this.appendAddress, value);
            this.appendAddress += 8L;
        }

        @Override
        public void putLong128(long lo, long hi) {
            assert (this.appendAddress + 16L <= FastMap.this.kLimit);
            Unsafe.getUnsafe().putLong(this.appendAddress, lo);
            Unsafe.getUnsafe().putLong(this.appendAddress + 8L, hi);
            this.appendAddress += 16L;
        }

        @Override
        public void putLong256(Long256 value) {
            assert (this.appendAddress + 32L <= FastMap.this.kLimit);
            Unsafe.getUnsafe().putLong(this.appendAddress, value.getLong0());
            Unsafe.getUnsafe().putLong(this.appendAddress + 8L, value.getLong1());
            Unsafe.getUnsafe().putLong(this.appendAddress + 16L, value.getLong2());
            Unsafe.getUnsafe().putLong(this.appendAddress + 24L, value.getLong3());
            this.appendAddress += 32L;
        }

        @Override
        public void putShort(short value) {
            assert (this.appendAddress + 2L <= FastMap.this.kLimit);
            Unsafe.getUnsafe().putShort(this.appendAddress, value);
            this.appendAddress += 2L;
        }

        @Override
        public void putStr(CharSequence value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putStr(CharSequence value, int lo, int hi) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putStrLowerCase(CharSequence value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putStrLowerCase(CharSequence value, int lo, int hi) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putTimestamp(long value) {
            this.putLong(value);
        }

        @Override
        public void skip(int bytes) {
            this.appendAddress += (long)bytes;
        }

        @Override
        protected boolean eq(long offset) {
            return Vect.memeq(FastMap.this.kStart + offset + (long)FastMap.this.keyOffset, this.startAddress + (long)FastMap.this.keyOffset, FastMap.this.keySize);
        }

        @Override
        protected int hash() {
            return Hash.hashMem32(this.startAddress + (long)FastMap.this.keyOffset, FastMap.this.keySize);
        }
    }

    private abstract class BaseKey
    implements MapKey {
        protected long appendAddress;
        protected long startAddress;

        private BaseKey() {
        }

        @Override
        public MapValue createValue() {
            return this.createValue(FastMap.this.value);
        }

        @Override
        public MapValue createValue2() {
            return this.createValue(FastMap.this.value2);
        }

        @Override
        public MapValue createValue3() {
            return this.createValue(FastMap.this.value3);
        }

        @Override
        public MapValue findValue() {
            return this.findValue(FastMap.this.value);
        }

        @Override
        public MapValue findValue2() {
            return this.findValue(FastMap.this.value2);
        }

        @Override
        public MapValue findValue3() {
            return this.findValue(FastMap.this.value3);
        }

        public BaseKey init() {
            this.startAddress = FastMap.this.kPos;
            this.appendAddress = FastMap.this.kPos + (long)FastMap.this.keyOffset;
            return this;
        }

        @Override
        public void put(Record record, RecordSink sink) {
            sink.copy(record, this);
        }

        @Override
        public void putRecord(Record value) {
        }

        private MapValue createValue(FastMapValue value) {
            this.commit();
            int hashCode = this.hash();
            int index = hashCode & FastMap.this.mask;
            long packedOffset = FastMap.getPackedOffset(FastMap.this.offsets, index);
            long offset = FastMap.unpackOffset(packedOffset);
            if (offset < 0L) {
                return FastMap.this.asNew(this, index, hashCode, value);
            }
            if (hashCode == FastMap.unpackHashCode(packedOffset) && this.eq(offset)) {
                return FastMap.this.valueOf(FastMap.this.kStart + offset, false, value);
            }
            return FastMap.this.probe0(this, index, hashCode, value);
        }

        private MapValue findValue(FastMapValue value) {
            this.commit();
            int hashCode = this.hash();
            int index = hashCode & FastMap.this.mask;
            long packedOffset = FastMap.getPackedOffset(FastMap.this.offsets, index);
            long offset = FastMap.unpackOffset(packedOffset);
            if (offset < 0L) {
                return null;
            }
            if (hashCode == FastMap.unpackHashCode(packedOffset) && this.eq(offset)) {
                return FastMap.this.valueOf(FastMap.this.kStart + offset, false, value);
            }
            return FastMap.this.probeReadOnly(this, index, hashCode, value);
        }

        protected void checkSize(int size) {
            if (this.appendAddress + (long)size > FastMap.this.kLimit) {
                FastMap.this.resize(size);
            }
        }

        protected void commit() {
        }

        protected abstract boolean eq(long var1);

        protected abstract int hash();
    }
}

