/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.h2.database.migration;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import org.apache.nifi.h2.database.migration.DatabaseVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DatabaseRepackager {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseRepackager.class);
    private static final byte[] SOURCE_PACKAGE_NAME = "org.h2.mvstore".getBytes(StandardCharsets.UTF_8);
    private static final byte[] SOURCE_PACKAGE_ROOT_NAME = new byte[]{111, 114, 103};
    private static final String REPLACEMENT_PACKAGE_FORMAT = "%s.mvstore";
    private static final int END_OF_FILE = -1;

    DatabaseRepackager() {
    }

    static void repackageDatabaseFile(DatabaseVersion databaseVersion, Path sourceDatabaseFile, Path repackagedDatabaseFile) {
        logger.debug("H2 DB {} repackaging started [{}]", (Object)databaseVersion.getVersion(), (Object)sourceDatabaseFile);
        String replacementPackageName = String.format(REPLACEMENT_PACKAGE_FORMAT, databaseVersion.getPackageName());
        byte[] replacementPackageBytes = replacementPackageName.getBytes(StandardCharsets.UTF_8);
        ByteArrayOutputStream sourcePackageBuffer = new ByteArrayOutputStream();
        try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(sourceDatabaseFile, new OpenOption[0]));
             BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(repackagedDatabaseFile, new OpenOption[0]));){
            int read = 0;
            boolean buffering = false;
            while (read != -1) {
                read = ((InputStream)inputStream).read();
                if (buffering) {
                    if (sourcePackageBuffer.size() < SOURCE_PACKAGE_NAME.length) {
                        sourcePackageBuffer.write(read);
                        continue;
                    }
                    byte[] packageBytes = sourcePackageBuffer.toByteArray();
                    sourcePackageBuffer.reset();
                    if (Arrays.equals(SOURCE_PACKAGE_NAME, packageBytes)) {
                        ((OutputStream)outputStream).write(replacementPackageBytes);
                    } else {
                        ((OutputStream)outputStream).write(packageBytes);
                    }
                    ((OutputStream)outputStream).write(read);
                    buffering = false;
                    continue;
                }
                if (SOURCE_PACKAGE_ROOT_NAME[0] == read) {
                    read = ((InputStream)inputStream).read();
                    if (SOURCE_PACKAGE_ROOT_NAME[1] == read) {
                        read = ((InputStream)inputStream).read();
                        if (SOURCE_PACKAGE_ROOT_NAME[2] == read) {
                            buffering = true;
                            sourcePackageBuffer.write(SOURCE_PACKAGE_ROOT_NAME);
                            continue;
                        }
                        ((OutputStream)outputStream).write(SOURCE_PACKAGE_ROOT_NAME[0]);
                        ((OutputStream)outputStream).write(SOURCE_PACKAGE_ROOT_NAME[1]);
                        ((OutputStream)outputStream).write(read);
                        continue;
                    }
                    ((OutputStream)outputStream).write(SOURCE_PACKAGE_ROOT_NAME[0]);
                    ((OutputStream)outputStream).write(read);
                    continue;
                }
                ((OutputStream)outputStream).write(read);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("H2 DB %s Repackaging Failed", databaseVersion.getVersion()), e);
        }
    }
}

