/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web;

import java.io.Serializable;

public class Revision
implements Serializable {
    private static final long serialVersionUID = 988658790374170022L;
    private final Long version;
    private final String clientId;
    private final String componentId;

    public Revision(Long version, String clientId, String componentId) {
        if (version == null) {
            throw new IllegalArgumentException("The revision must be specified.");
        }
        if (componentId == null) {
            throw new IllegalArgumentException("The componentId must be specified.");
        }
        this.version = version;
        this.clientId = clientId;
        this.componentId = componentId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public Long getVersion() {
        return this.version;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public Revision incrementRevision(String clientId) {
        return new Revision(this.version + 1L, clientId, this.componentId);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Revision)) {
            return false;
        }
        Revision thatRevision = (Revision)obj;
        if (thatRevision.getComponentId() == null && this.getComponentId() != null) {
            return false;
        }
        if (thatRevision.getComponentId() != null && this.getComponentId() == null) {
            return false;
        }
        if (thatRevision.getComponentId() != null && !thatRevision.getComponentId().equals(this.getComponentId())) {
            return false;
        }
        if (this.version != null && this.version.equals(thatRevision.version)) {
            return true;
        }
        return this.clientId != null && !this.clientId.trim().isEmpty() && this.clientId.equals(thatRevision.getClientId());
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + (this.componentId != null ? this.componentId.hashCode() : 0);
        hash = 59 * hash + (this.version != null ? this.version.hashCode() : 0);
        hash = 59 * hash + (this.clientId != null ? this.clientId.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "[" + this.version + ", " + this.clientId + ", " + this.componentId + ']';
    }
}

