/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.queue;

import java.util.Comparator;
import org.apache.nifi.controller.queue.FlowFileSummary;

public enum SortColumn implements Comparator<FlowFileSummary>
{
    QUEUE_POSITION(new Comparator<FlowFileSummary>(){

        @Override
        public int compare(FlowFileSummary o1, FlowFileSummary o2) {
            return Integer.compare(o1.getPosition(), o2.getPosition());
        }
    }),
    FLOWFILE_UUID(new Comparator<FlowFileSummary>(){

        @Override
        public int compare(FlowFileSummary o1, FlowFileSummary o2) {
            return o1.getUuid().compareTo(o2.getUuid());
        }
    }),
    FILENAME(new Comparator<FlowFileSummary>(){

        @Override
        public int compare(FlowFileSummary o1, FlowFileSummary o2) {
            return o1.getFilename().compareTo(o2.getFilename());
        }
    }),
    FLOWFILE_SIZE(new Comparator<FlowFileSummary>(){

        @Override
        public int compare(FlowFileSummary o1, FlowFileSummary o2) {
            return Long.compare(o1.getSize(), o2.getSize());
        }
    }),
    QUEUED_DURATION(new Comparator<FlowFileSummary>(){

        @Override
        public int compare(FlowFileSummary o1, FlowFileSummary o2) {
            return -Long.compare(o1.getLastQueuedTime(), o2.getLastQueuedTime());
        }
    }),
    FLOWFILE_AGE(new Comparator<FlowFileSummary>(){

        @Override
        public int compare(FlowFileSummary o1, FlowFileSummary o2) {
            return Long.compare(o1.getLineageStartDate(), o2.getLineageStartDate());
        }
    }),
    PENALIZATION(new Comparator<FlowFileSummary>(){

        @Override
        public int compare(FlowFileSummary o1, FlowFileSummary o2) {
            return Boolean.compare(o1.isPenalized(), o2.isPenalized());
        }
    });

    private final Comparator<FlowFileSummary> comparator;

    private SortColumn(Comparator<FlowFileSummary> comparator) {
        this.comparator = comparator;
    }

    @Override
    public int compare(FlowFileSummary o1, FlowFileSummary o2) {
        return this.comparator.compare(o1, o2);
    }
}

