/*
 * Decompiled with CFR 0.152.
 */
package v14.h2.util;

import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import v14.h2.api.IntervalQualifier;
import v14.h2.engine.CastDataProvider;
import v14.h2.message.DbException;
import v14.h2.util.DateTimeUtils;
import v14.h2.util.IntervalUtils;
import v14.h2.util.TimeZoneProvider;
import v14.h2.value.DataType;
import v14.h2.value.Value;
import v14.h2.value.ValueDate;
import v14.h2.value.ValueInterval;
import v14.h2.value.ValueTime;
import v14.h2.value.ValueTimeTimeZone;
import v14.h2.value.ValueTimestamp;
import v14.h2.value.ValueTimestampTimeZone;

public class JSR310Utils {
    private static final long MIN_DATE_VALUE = -511999999455L;
    private static final long MAX_DATE_VALUE = 511999999903L;
    private static final long MIN_INSTANT_SECOND = -31557014167219200L;
    private static final long MAX_INSTANT_SECOND = 31556889864403199L;

    private JSR310Utils() {
    }

    public static Object valueToLocalDate(Value value) {
        long l = ((ValueDate)value.convertTo(10)).getDateValue();
        if (l > 511999999903L) {
            l = 511999999903L;
        } else if (l < -511999999455L) {
            l = -511999999455L;
        }
        return LocalDate.of(DateTimeUtils.yearFromDateValue(l), DateTimeUtils.monthFromDateValue(l), DateTimeUtils.dayFromDateValue(l));
    }

    public static Object valueToLocalTime(Value value) {
        return LocalTime.ofNanoOfDay(((ValueTime)value.convertTo(9)).getNanos());
    }

    public static Object valueToLocalDateTime(Value value, CastDataProvider castDataProvider) {
        ValueTimestamp valueTimestamp = (ValueTimestamp)value.convertTo(11, castDataProvider, false);
        return JSR310Utils.localDateTimeFromDateNanos(valueTimestamp.getDateValue(), valueTimestamp.getTimeNanos());
    }

    public static Object valueToInstant(Value value, CastDataProvider castDataProvider) {
        ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)value.convertTo(24, castDataProvider, false);
        long l = valueTimestampTimeZone.getTimeNanos();
        long l2 = DateTimeUtils.absoluteDayFromDateValue(valueTimestampTimeZone.getDateValue()) * 86400L + l / 1000000000L - (long)valueTimestampTimeZone.getTimeZoneOffsetSeconds();
        l %= 1000000000L;
        if (l2 > 31556889864403199L) {
            l2 = 31556889864403199L;
            l = 999999999L;
        } else if (l2 < -31557014167219200L) {
            l2 = -31557014167219200L;
            l = 0L;
        }
        return Instant.ofEpochSecond(l2, l);
    }

    public static Object valueToOffsetDateTime(Value value, CastDataProvider castDataProvider) {
        return JSR310Utils.valueToOffsetDateTime(value, castDataProvider, false);
    }

    public static Object valueToZonedDateTime(Value value, CastDataProvider castDataProvider) {
        return JSR310Utils.valueToOffsetDateTime(value, castDataProvider, true);
    }

    private static Object valueToOffsetDateTime(Value value, CastDataProvider castDataProvider, boolean bl) {
        ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)value.convertTo(24, castDataProvider, false);
        long l = valueTimestampTimeZone.getDateValue();
        long l2 = valueTimestampTimeZone.getTimeNanos();
        LocalDateTime localDateTime = (LocalDateTime)JSR310Utils.localDateTimeFromDateNanos(l, l2);
        int n = valueTimestampTimeZone.getTimeZoneOffsetSeconds();
        ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(n);
        return bl ? ZonedDateTime.of(localDateTime, zoneOffset) : OffsetDateTime.of(localDateTime, zoneOffset);
    }

    public static Object valueToOffsetTime(Value value, CastDataProvider castDataProvider) {
        ValueTimeTimeZone valueTimeTimeZone = (ValueTimeTimeZone)value.convertTo(41, castDataProvider, false);
        return OffsetTime.of(LocalTime.ofNanoOfDay(valueTimeTimeZone.getNanos()), ZoneOffset.ofTotalSeconds(valueTimeTimeZone.getTimeZoneOffsetSeconds()));
    }

    public static Object valueToPeriod(Value value) {
        if (!(value instanceof ValueInterval)) {
            value = value.convertTo(32);
        }
        if (!DataType.isYearMonthIntervalType(value.getValueType())) {
            throw DbException.get(22018, (Throwable)null, value.getString());
        }
        ValueInterval valueInterval = (ValueInterval)value;
        IntervalQualifier intervalQualifier = valueInterval.getQualifier();
        boolean bl = valueInterval.isNegative();
        long l = valueInterval.getLeading();
        long l2 = valueInterval.getRemaining();
        int n = Value.convertToInt(IntervalUtils.yearsFromInterval(intervalQualifier, bl, l, l2), null);
        int n2 = Value.convertToInt(IntervalUtils.monthsFromInterval(intervalQualifier, bl, l, l2), null);
        return Period.of(n, n2, 0);
    }

    public static Object valueToDuration(Value value) {
        if (!(value instanceof ValueInterval)) {
            value = value.convertTo(35);
        }
        if (DataType.isYearMonthIntervalType(value.getValueType())) {
            throw DbException.get(22018, (Throwable)null, value.getString());
        }
        BigInteger[] bigIntegerArray = IntervalUtils.intervalToAbsolute((ValueInterval)value).divideAndRemainder(BigInteger.valueOf(1000000000L));
        return Duration.ofSeconds(bigIntegerArray[0].longValue(), bigIntegerArray[1].longValue());
    }

    public static Value localDateToValue(Object object) {
        LocalDate localDate = (LocalDate)object;
        return ValueDate.fromDateValue(DateTimeUtils.dateValue(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth()));
    }

    public static Value localTimeToValue(Object object) {
        return ValueTime.fromNanos(((LocalTime)object).toNanoOfDay());
    }

    public static Value localDateTimeToValue(Object object) {
        LocalDateTime localDateTime = (LocalDateTime)object;
        LocalDate localDate = localDateTime.toLocalDate();
        long l = DateTimeUtils.dateValue(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth());
        long l2 = localDateTime.toLocalTime().toNanoOfDay();
        return ValueTimestamp.fromDateValueAndNanos(l, l2);
    }

    public static Value instantToValue(Object object) {
        Instant instant = (Instant)object;
        long l = instant.getEpochSecond();
        int n = instant.getNano();
        long l2 = l / 86400L;
        if (l < 0L && l2 * 86400L != l) {
            --l2;
        }
        long l3 = (l - l2 * 86400L) * 1000000000L + (long)n;
        return ValueTimestampTimeZone.fromDateValueAndNanos(DateTimeUtils.dateValueFromAbsoluteDay(l2), l3, 0);
    }

    public static ValueTimestampTimeZone offsetDateTimeToValue(Object object) {
        OffsetDateTime offsetDateTime = (OffsetDateTime)object;
        LocalDateTime localDateTime = offsetDateTime.toLocalDateTime();
        LocalDate localDate = localDateTime.toLocalDate();
        long l = DateTimeUtils.dateValue(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth());
        return ValueTimestampTimeZone.fromDateValueAndNanos(l, localDateTime.toLocalTime().toNanoOfDay(), offsetDateTime.getOffset().getTotalSeconds());
    }

    public static ValueTimestampTimeZone zonedDateTimeToValue(Object object) {
        ZonedDateTime zonedDateTime = (ZonedDateTime)object;
        LocalDateTime localDateTime = zonedDateTime.toLocalDateTime();
        LocalDate localDate = localDateTime.toLocalDate();
        long l = DateTimeUtils.dateValue(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth());
        return ValueTimestampTimeZone.fromDateValueAndNanos(l, localDateTime.toLocalTime().toNanoOfDay(), zonedDateTime.getOffset().getTotalSeconds());
    }

    public static ValueTimeTimeZone offsetTimeToValue(Object object) {
        OffsetTime offsetTime = (OffsetTime)object;
        return ValueTimeTimeZone.fromNanos(offsetTime.toLocalTime().toNanoOfDay(), offsetTime.getOffset().getTotalSeconds());
    }

    private static Object localDateTimeFromDateNanos(long l, long l2) {
        if (l > 511999999903L) {
            l = 511999999903L;
            l2 = 86399999999999L;
        } else if (l < -511999999455L) {
            l = -511999999455L;
            l2 = 0L;
        }
        return LocalDateTime.of(LocalDate.of(DateTimeUtils.yearFromDateValue(l), DateTimeUtils.monthFromDateValue(l), DateTimeUtils.dayFromDateValue(l)), LocalTime.ofNanoOfDay(l2));
    }

    public static ValueInterval periodToValue(Object object) {
        IntervalQualifier intervalQualifier;
        Period period = (Period)object;
        int n = period.getDays();
        if (n != 0) {
            throw DbException.getInvalidValueException("Period.days", n);
        }
        int n2 = period.getYears();
        int n3 = period.getMonths();
        boolean bl = false;
        long l = 0L;
        long l2 = 0L;
        if (n2 == 0) {
            if ((long)n3 == 0L) {
                intervalQualifier = IntervalQualifier.YEAR_TO_MONTH;
            } else {
                intervalQualifier = IntervalQualifier.MONTH;
                l = n3;
                if (l < 0L) {
                    l = -l;
                    bl = true;
                }
            }
        } else if ((long)n3 == 0L) {
            intervalQualifier = IntervalQualifier.YEAR;
            l = n2;
            if (l < 0L) {
                l = -l;
                bl = true;
            }
        } else {
            intervalQualifier = IntervalQualifier.YEAR_TO_MONTH;
            l = n2 * 12 + n3;
            if (l < 0L) {
                l = -l;
                bl = true;
            }
            l2 = l % 12L;
            l /= 12L;
        }
        return ValueInterval.from(intervalQualifier, bl, l, l2);
    }

    public static ValueInterval durationToValue(Object object) {
        Duration duration = (Duration)object;
        long l = duration.getSeconds();
        int n = duration.getNano();
        boolean bl = l < 0L;
        l = Math.abs(l);
        if (bl && n != 0) {
            n = 1000000000 - n;
            --l;
        }
        return ValueInterval.from(IntervalQualifier.SECOND, bl, l, n);
    }

    public static TimeZoneProvider getDefaultTimeZoneProvider() {
        return new WithTimeZone8(ZoneId.systemDefault());
    }

    public static TimeZoneProvider getTimeZoneProvider(String string) {
        return new WithTimeZone8(ZoneId.of(string, ZoneId.SHORT_IDS));
    }

    private static final class WithTimeZone8
    extends TimeZoneProvider.WithTimeZone {
        private static final long EPOCH_SECONDS_HIGH = 31556889864403199L;
        private static final long EPOCH_SECONDS_LOW = -31557014167219200L;
        private static volatile DateTimeFormatter TIME_ZONE_FORMATTER;
        private final ZoneId zoneId;

        WithTimeZone8(ZoneId zoneId) {
            this.zoneId = zoneId;
        }

        @Override
        public int getTimeZoneOffsetUTC(long l) {
            return this.zoneId.getRules().getOffset(WithTimeZone8.epochSecondsForCalendar(l)).getTotalSeconds();
        }

        @Override
        int getTimeZoneOffsetLocal(int n, int n2, int n3, int n4, int n5, int n6) {
            n = WithTimeZone8.yearForCalendar(n);
            return ZonedDateTime.of(LocalDateTime.of(n, n2, n3, n4, n5, n6), this.zoneId).getOffset().getTotalSeconds();
        }

        @Override
        long getEpochSecondsFromLocal(int n, int n2, int n3, int n4, int n5, int n6) {
            int n7 = WithTimeZone8.yearForCalendar(n);
            long l = ZonedDateTime.of(LocalDateTime.of(n7, n2, n3, n4, n5, n6), this.zoneId).toOffsetDateTime().toEpochSecond();
            return l + (long)(n - n7) * 31556952L;
        }

        @Override
        public String getId() {
            return this.zoneId.getId();
        }

        @Override
        public String getShortId(long l) {
            DateTimeFormatter dateTimeFormatter = TIME_ZONE_FORMATTER;
            if (dateTimeFormatter == null) {
                TIME_ZONE_FORMATTER = dateTimeFormatter = DateTimeFormatter.ofPattern("z", Locale.ENGLISH);
            }
            return ZonedDateTime.ofInstant(Instant.ofEpochSecond(l), this.zoneId).format(dateTimeFormatter);
        }

        private static int yearForCalendar(int n) {
            if (n > 999999999) {
                n -= 400;
            } else if (n < -999999999) {
                n += 400;
            }
            return n;
        }

        private static Instant epochSecondsForCalendar(long l) {
            if (l > 31556889864403199L) {
                l -= 12622780800L;
            } else if (l < -31557014167219200L) {
                l += 12622780800L;
            }
            return Instant.ofEpochSecond(l);
        }

        public String toString() {
            return "TimeZoneProvider " + this.zoneId.getId();
        }
    }
}

