/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate.cached;

import java.util.Arrays;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.CachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.EntityIdSet;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.cached.iterator.EntityIdArrayIteratorMultiTypeIdPacked;
import jetbrains.exodus.entitystore.iterate.cached.iterator.ReverseEntityIdArrayIteratorMultiTypeIdPacked;
import jetbrains.exodus.entitystore.util.EntityIdSetFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiTypeSortedEntityIdArrayCachedInstanceIterable
extends CachedInstanceIterable {
    private final int[] typeIds;
    private final long[] localIds;
    @Nullable
    private EntityIdSet idSet;

    public MultiTypeSortedEntityIdArrayCachedInstanceIterable(@NotNull PersistentStoreTransaction txn, @NotNull EntityIterableBase source, int[] typeIds, long[] localIds, @Nullable EntityIdSet idSet2) {
        super(txn, source);
        this.typeIds = typeIds;
        this.localIds = localIds;
        this.idSet = idSet2;
    }

    @Override
    protected CachedInstanceIterable orderById() {
        return this;
    }

    @Override
    public boolean isSortedById() {
        return true;
    }

    @Override
    protected long countImpl(@NotNull PersistentStoreTransaction txn) {
        return this.localIds.length;
    }

    @Override
    protected boolean containsImpl(@NotNull EntityId entityId) {
        EntityIdSet ids = this.idSet;
        if (ids != null) {
            return ids.contains(entityId);
        }
        return super.containsImpl(entityId);
    }

    @Override
    protected int indexOfImpl(@NotNull EntityId entityId) {
        long localId = entityId.getLocalId();
        int typeId = entityId.getTypeId();
        int prevBound = 0;
        int length = this.typeIds.length;
        for (int i = 0; i < length; ++i) {
            if (this.typeIds[i] == typeId) {
                int result;
                if ((result = Arrays.binarySearch(this.localIds, prevBound, this.typeIds[++i], localId)) < 0) break;
                return result;
            }
            prevBound = this.typeIds[++i];
        }
        return -1;
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return new EntityIdArrayIteratorMultiTypeIdPacked(this, this.typeIds, this.localIds);
    }

    @Override
    @NotNull
    public EntityIteratorBase getReverseIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return new ReverseEntityIdArrayIteratorMultiTypeIdPacked(this, this.typeIds, this.localIds);
    }

    @Override
    @NotNull
    public EntityIdSet toSet(@NotNull PersistentStoreTransaction txn) {
        EntityIdSet result = this.idSet;
        if (result != null) {
            return result;
        }
        int count = this.typeIds.length;
        result = EntityIdSetFactory.newSet();
        int j = 0;
        for (int i = 0; i < count; ++i) {
            int typeId = this.typeIds[i];
            int upperBound = this.typeIds[++i];
            if (typeId == Integer.MIN_VALUE) {
                while (j < upperBound) {
                    result = result.add(null);
                    ++j;
                }
                continue;
            }
            while (j < upperBound) {
                result = result.add(typeId, this.localIds[j++]);
            }
        }
        this.idSet = result;
        return result;
    }
}

