/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.claim;

import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.nifi.controller.repository.claim.ResourceClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaimManager;
import org.apache.nifi.controller.repository.claim.StandardResourceClaim;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardResourceClaimManager
implements ResourceClaimManager {
    private static final Logger logger = LoggerFactory.getLogger(StandardResourceClaimManager.class);
    private final ConcurrentMap<ResourceClaim, ClaimCount> claimantCounts = new ConcurrentHashMap<ResourceClaim, ClaimCount>();
    private final BlockingQueue<ResourceClaim> destructableClaims = new LinkedBlockingQueue<ResourceClaim>(50000);

    public ResourceClaim newResourceClaim(String container, String section, String id, boolean lossTolerant, boolean writable) {
        StandardResourceClaim claim = new StandardResourceClaim(this, container, section, id, lossTolerant);
        if (!writable) {
            claim.freeze();
        }
        return claim;
    }

    public ResourceClaim getResourceClaim(String container, String section, String id) {
        StandardResourceClaim tempClaim = new StandardResourceClaim(this, container, section, id, false);
        ClaimCount count = (ClaimCount)this.claimantCounts.get(tempClaim);
        return count == null ? null : count.getClaim();
    }

    private AtomicInteger getCounter(ResourceClaim claim) {
        if (claim == null) {
            return null;
        }
        ClaimCount counter = (ClaimCount)this.claimantCounts.get(claim);
        if (counter != null) {
            return counter.getCount();
        }
        counter = new ClaimCount(claim, new AtomicInteger(0));
        ClaimCount existingCounter = this.claimantCounts.putIfAbsent(claim, counter);
        return existingCounter == null ? counter.getCount() : existingCounter.getCount();
    }

    public int getClaimantCount(ResourceClaim claim) {
        if (claim == null) {
            return 0;
        }
        ClaimCount counter = (ClaimCount)this.claimantCounts.get(claim);
        return counter == null ? 0 : counter.getCount().get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decrementClaimantCount(ResourceClaim claim) {
        if (claim == null) {
            return 0;
        }
        ResourceClaim resourceClaim = claim;
        synchronized (resourceClaim) {
            ClaimCount counter = (ClaimCount)this.claimantCounts.get(claim);
            if (counter == null) {
                logger.warn("Decrementing claimant count for {} but claimant count is not known. Returning -1", (Object)claim);
                return -1;
            }
            int newClaimantCount = counter.getCount().decrementAndGet();
            if (newClaimantCount < 0) {
                logger.error("Decremented claimant count for {} to {}", (Object)claim, (Object)newClaimantCount);
            } else {
                logger.debug("Decrementing claimant count for {} to {}", (Object)claim, (Object)newClaimantCount);
            }
            if (newClaimantCount == 0 && !claim.isWritable()) {
                this.removeClaimantCount(claim);
            }
            return newClaimantCount;
        }
    }

    protected void removeClaimantCount(ResourceClaim claim) {
        this.claimantCounts.remove(claim);
    }

    public int incrementClaimantCount(ResourceClaim claim) {
        return this.incrementClaimantCount(claim, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int incrementClaimantCount(ResourceClaim claim, boolean newClaim) {
        if (claim == null) {
            return 0;
        }
        ResourceClaim resourceClaim = claim;
        synchronized (resourceClaim) {
            AtomicInteger counter = this.getCounter(claim);
            int newClaimantCount = counter.incrementAndGet();
            logger.debug("Incrementing claimant count for {} to {}", (Object)claim, (Object)newClaimantCount);
            if (!newClaim && newClaimantCount == 1) {
                this.destructableClaims.remove(claim);
            }
            return newClaimantCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markDestructable(ResourceClaim claim) {
        if (claim == null) {
            return;
        }
        ResourceClaim resourceClaim = claim;
        synchronized (resourceClaim) {
            if (this.getClaimantCount(claim) > 0) {
                return;
            }
            logger.debug("Marking claim {} as destructable", (Object)claim);
            try {
                while (!this.destructableClaims.offer(claim, 30L, TimeUnit.MINUTES)) {
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void drainDestructableClaims(Collection<ResourceClaim> destination, int maxElements) {
        int drainedCount = this.destructableClaims.drainTo(destination, maxElements);
        logger.debug("Drained {} destructable claims to {}", (Object)drainedCount, destination);
    }

    public void drainDestructableClaims(Collection<ResourceClaim> destination, int maxElements, long timeout, TimeUnit unit) {
        try {
            ResourceClaim firstClaim = this.destructableClaims.poll(timeout, unit);
            if (firstClaim != null) {
                destination.add(firstClaim);
                this.destructableClaims.drainTo(destination, maxElements - 1);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void purge() {
        this.claimantCounts.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeze(ResourceClaim claim) {
        if (claim == null) {
            return;
        }
        if (!(claim instanceof StandardResourceClaim)) {
            throw new IllegalArgumentException("The given resource claim is not managed by this Resource Claim Manager");
        }
        ((StandardResourceClaim)claim).freeze();
        ResourceClaim resourceClaim = claim;
        synchronized (resourceClaim) {
            if (this.getClaimantCount(claim) == 0) {
                this.claimantCounts.remove(claim);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDestructable(ResourceClaim claim) {
        if (claim == null) {
            return false;
        }
        ResourceClaim resourceClaim = claim;
        synchronized (resourceClaim) {
            return this.destructableClaims.contains(claim);
        }
    }

    private static final class ClaimCount {
        private final ResourceClaim claim;
        private final AtomicInteger count;

        public ClaimCount(ResourceClaim claim, AtomicInteger count) {
            this.claim = claim;
            this.count = count;
        }

        public AtomicInteger getCount() {
            return this.count;
        }

        public ResourceClaim getClaim() {
            return this.claim;
        }
    }
}

