/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.c2.provider.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.nifi.minifi.c2.api.ConfigurationProviderException;
import org.apache.nifi.minifi.c2.api.InvalidParameterException;
import org.apache.nifi.minifi.c2.api.properties.C2Properties;
import org.apache.nifi.security.ssl.StandardKeyStoreBuilder;
import org.apache.nifi.security.ssl.StandardSslContextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnector {
    private static final Logger logger = LoggerFactory.getLogger(HttpConnector.class);
    private static final String HTTPS = "https:";
    private static final String C2_SERVER_HOME = System.getenv("C2_SERVER_HOME");
    private final String baseUrl;
    private final SSLContext sslContext;
    private final Proxy proxy;
    private final String proxyAuthorization;

    public HttpConnector(String baseUrl) throws InvalidParameterException, GeneralSecurityException, IOException {
        this(baseUrl, null, 0);
    }

    public HttpConnector(String baseUrl, String proxyHost, int proxyPort) throws InvalidParameterException, GeneralSecurityException, IOException {
        this(baseUrl, proxyHost, proxyPort, null, null);
    }

    public HttpConnector(String baseUrl, String proxyHost, int proxyPort, String proxyUsername, String proxyPassword) throws InvalidParameterException {
        this.sslContext = baseUrl.startsWith(HTTPS) ? this.buildSSLContext() : null;
        this.baseUrl = baseUrl;
        if (proxyHost != null && !proxyHost.isEmpty()) {
            if (proxyPort == 0) {
                throw new InvalidParameterException("Must specify proxy port with proxy host");
            }
            this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
        } else {
            this.proxy = null;
        }
        if (proxyUsername != null && !proxyUsername.isEmpty()) {
            if (this.proxy == null) {
                throw new InvalidParameterException("Cannot specify proxy username without proxy host.");
            }
            if (proxyPassword == null) {
                throw new InvalidParameterException("Must specify proxy password with proxy username.");
            }
            this.proxyAuthorization = "Basic " + Base64.getEncoder().encodeToString((proxyHost + ":" + proxyPassword).getBytes(StandardCharsets.UTF_8));
        } else {
            this.proxyAuthorization = null;
        }
    }

    private SSLContext buildSSLContext() {
        KeyStore truststore;
        KeyStore keyStore;
        C2Properties properties = C2Properties.getInstance();
        Path c2ServerHome = Paths.get(C2_SERVER_HOME, new String[0]);
        File keyStoreFile = c2ServerHome.resolve(properties.getProperty("minifi.c2.server.keystore")).toFile();
        logger.debug("Loading Key Store [{}]", (Object)keyStoreFile.getPath());
        try (FileInputStream keyStoreStream = new FileInputStream(keyStoreFile);){
            keyStore = new StandardKeyStoreBuilder().type(properties.getProperty("minifi.c2.server.keystoreType")).inputStream((InputStream)keyStoreStream).password(properties.getProperty("minifi.c2.server.keystorePasswd").toCharArray()).build();
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("Key Store loading failed", ioe);
        }
        File trustStoreFile = c2ServerHome.resolve(properties.getProperty("minifi.c2.server.truststore")).toFile();
        logger.debug("Loading Trust Store [{}]", (Object)trustStoreFile.getPath());
        try (FileInputStream trustStoreStream = new FileInputStream(trustStoreFile);){
            truststore = new StandardKeyStoreBuilder().type(properties.getProperty("minifi.c2.server.truststoreType")).inputStream((InputStream)trustStoreStream).password(properties.getProperty("minifi.c2.server.truststorePasswd").toCharArray()).build();
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("Trust Store loading failed", ioe);
        }
        return new StandardSslContextBuilder().keyStore(keyStore).keyPassword(properties.getProperty("minifi.c2.server.keyPasswd").toCharArray()).trustStore(truststore).build();
    }

    public HttpURLConnection get(String endpointPath) throws ConfigurationProviderException {
        return this.get(endpointPath, Collections.emptyMap());
    }

    public HttpURLConnection get(String endpointPath, Map<String, List<String>> headers) throws ConfigurationProviderException {
        HttpURLConnection httpURLConnection;
        URL url;
        String endpointUrl = this.baseUrl + endpointPath;
        if (logger.isDebugEnabled()) {
            logger.debug("Connecting to endpoint: " + endpointUrl);
        }
        try {
            url = URI.create(endpointUrl).toURL();
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new ConfigurationProviderException("Malformed url " + endpointUrl, (Throwable)e);
        }
        try {
            httpURLConnection = this.proxy == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(this.proxy);
            if (this.sslContext != null) {
                HttpsURLConnection httpsURLConnection = (HttpsURLConnection)httpURLConnection;
                SSLSocketFactory socketFactory = this.sslContext.getSocketFactory();
                httpsURLConnection.setSSLSocketFactory(socketFactory);
            }
        }
        catch (IOException e) {
            throw new ConfigurationProviderException("Unable to connect to " + url, (Throwable)e);
        }
        if (this.proxyAuthorization != null) {
            httpURLConnection.setRequestProperty("Proxy-Authorization", this.proxyAuthorization);
        }
        headers.forEach((s, strings) -> httpURLConnection.setRequestProperty((String)s, String.join((CharSequence)",", strings)));
        return httpURLConnection;
    }
}

