/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.JarClassLoader;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class ProxyURLStreamHandlerFactory
implements URLStreamHandlerFactory,
LookupListener {
    private static final Logger LOG = Logger.getLogger(ProxyURLStreamHandlerFactory.class.getName());
    private static boolean proxyFactoryInitialized;
    private static URLStreamHandler originalJarHandler;
    private final URLStreamHandlerFactory delegate;
    private Lookup.Result<URLStreamHandlerFactory> r;
    private URLStreamHandlerFactory[] handlers;

    public static synchronized void register() {
        LOG.log(Level.FINE, "register: {0}", proxyFactoryInitialized);
        LOG.log(Level.FINER, null, new Exception("Initialized by"));
        if (!proxyFactoryInitialized) {
            block12: {
                if (!ProxyURLStreamHandlerFactory.class.getClassLoader().getClass().getName().equals("com.sun.jnlp.JNLPClassLoader")) {
                    try {
                        ArrayList<Field> candidates = new ArrayList<Field>();
                        for (Field f : URL.class.getDeclaredFields()) {
                            if (f.getType() != URLStreamHandler.class) continue;
                            candidates.add(f);
                        }
                        if (candidates.size() != 1) {
                            throw new Exception("No, or multiple, URLStreamHandler-valued fields in URL: " + candidates);
                        }
                        Field f = (Field)candidates.get(0);
                        f.setAccessible(true);
                        originalJarHandler = (URLStreamHandler)f.get(new URL("jar:file:/sample.jar!/"));
                        LOG.log(Level.FINE, "found originalJarHandler: {0}", originalJarHandler);
                    }
                    catch (Throwable t) {
                        if (originalJarHandler != null) break block12;
                        LOG.log(Level.SEVERE, "No way to find original stream handler for jar protocol", t);
                    }
                }
            }
            try {
                URL.setURLStreamHandlerFactory(new ProxyURLStreamHandlerFactory(null));
            }
            catch (Error e) {
                LOG.log(Level.CONFIG, "Problems registering URLStreamHandlerFactory, trying reflection", e);
                try {
                    Object prev = null;
                    for (Field f : URL.class.getDeclaredFields()) {
                        LOG.log(Level.FINEST, "Found field {0}", f);
                        if (f.getType() != URLStreamHandlerFactory.class) continue;
                        LOG.log(Level.FINEST, "Clearing field {0}");
                        f.setAccessible(true);
                        prev = (URLStreamHandlerFactory)f.get(null);
                        LOG.log(Level.CONFIG, "Previous value was {0}", prev);
                        f.set(null, null);
                        LOG.config("Field is supposed to be empty");
                        break;
                    }
                    if (prev != null && prev.getClass().getName().equals(ProxyURLStreamHandlerFactory.class.getName())) {
                        prev = null;
                    }
                    URL.setURLStreamHandlerFactory(new ProxyURLStreamHandlerFactory((URLStreamHandlerFactory)prev));
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, "No way to register URLStreamHandlerFactory; NetBeans is unlikely to work", t);
                }
            }
            proxyFactoryInitialized = true;
        }
    }

    static URLStreamHandler originalJarHandler() {
        return originalJarHandler;
    }

    private ProxyURLStreamHandlerFactory(URLStreamHandlerFactory delegate) {
        this.delegate = delegate;
        LOG.log(Level.FINE, "new ProxyURLStreamHandlerFactory. delegate={0} originalJarHandler={1}", new Object[]{delegate, originalJarHandler});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        URLStreamHandler h;
        if (protocol.equals("jar")) {
            return originalJarHandler != null ? new JarClassLoader.JarURLStreamHandler(originalJarHandler) : null;
        }
        if (protocol.equals("file") || protocol.equals("http") || protocol.equals("https") || protocol.equals("resource")) {
            return null;
        }
        if (this.delegate != null && (h = this.delegate.createURLStreamHandler(protocol)) != null) {
            return h;
        }
        URLStreamHandlerFactory[] uRLStreamHandlerFactoryArray = this;
        synchronized (this) {
            if (this.handlers == null) {
                this.r = Lookup.getDefault().lookupResult(URLStreamHandlerFactory.class);
                this.r.addLookupListener((LookupListener)this);
                this.resultChanged(null);
            }
            URLStreamHandlerFactory[] _handlers = this.handlers;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            for (URLStreamHandlerFactory f : _handlers) {
                URLStreamHandler h2 = f.createURLStreamHandler(protocol);
                if (h2 == null) continue;
                return h2;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resultChanged(LookupEvent ev) {
        Collection<URLStreamHandlerFactory> c = this.r.allInstances();
        ProxyURLStreamHandlerFactory proxyURLStreamHandlerFactory = this;
        synchronized (proxyURLStreamHandlerFactory) {
            this.handlers = c.toArray(new URLStreamHandlerFactory[c.size()]);
        }
    }
}

