/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.ui.laf.base;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import javax.faces.context.ResponseWriter;

@Deprecated
class FullyBufferedWriter
extends Writer {
    private ResponseWriter _writer;
    private ArrayList<char[]> _usedBuffers;
    private char[] _buffer;
    private int _bufferSize;
    private int _nextChar;
    private static final int _DEFAULT_BUFFER_SIZE = 1024;

    public FullyBufferedWriter(ResponseWriter writer) {
        if (writer == null) {
            throw new NullPointerException();
        }
        this._writer = writer;
    }

    @Override
    public void write(int c) throws IOException {
        int nextChar = this._nextChar;
        if (nextChar >= this._bufferSize) {
            this._getNewBuffer(1);
            nextChar = 0;
        }
        this._buffer[nextChar] = (char)c;
        this._nextChar = nextChar + 1;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int nextChar = this._nextChar;
        int remainingChars = this._bufferSize - nextChar;
        if (len > remainingChars) {
            if (this._buffer != null) {
                System.arraycopy(cbuf, off, this._buffer, nextChar, remainingChars);
            }
            off += remainingChars;
            this._getNewBuffer(len -= remainingChars);
            nextChar = 0;
        }
        System.arraycopy(cbuf, off, this._buffer, nextChar, len);
        this._nextChar = nextChar + len;
    }

    @Override
    public void write(String s, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        int nextChar = this._nextChar;
        int remainingChars = this._bufferSize - nextChar;
        if (len > remainingChars) {
            if (this._buffer != null) {
                s.getChars(off, off + remainingChars, this._buffer, nextChar);
            }
            off += remainingChars;
            this._getNewBuffer(len -= remainingChars);
            nextChar = 0;
        }
        s.getChars(off, off + len, this._buffer, nextChar);
        this._nextChar = nextChar + len;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        if (this._writer == null) {
            return;
        }
        this.reallyFlush();
        this._writer = null;
    }

    public void reallyFlush() throws IOException {
        int nextChar = this._nextChar;
        ArrayList<char[]> usedBuffers = this._usedBuffers;
        if (nextChar == 0 && usedBuffers == null) {
            return;
        }
        if (usedBuffers != null) {
            int bufferCount = usedBuffers.size();
            for (int i = 0; i < bufferCount; ++i) {
                char[] usedBuffer = usedBuffers.get(i);
                this._writer.write(usedBuffer, 0, usedBuffer.length);
            }
        }
        this._writer.write(this._buffer, 0, nextChar);
        this._nextChar = 0;
        this._writer.flush();
    }

    public void dispose() {
        if (this._writer == null) {
            return;
        }
        this._writer = null;
        this._nextChar = 0;
        this._usedBuffers = null;
    }

    private void _getNewBuffer(int neededSize) {
        if (this._buffer != null) {
            if (this._usedBuffers == null) {
                this._usedBuffers = new ArrayList(5);
            }
            this._usedBuffers.add(this._buffer);
        }
        int size = Math.max(1024, neededSize);
        this._buffer = new char[size];
        this._nextChar = 0;
        this._bufferSize = size;
    }
}

