/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image;

import java.util.Map;
import org.apache.myfaces.trinidadinternal.image.ImageType;
import org.apache.myfaces.trinidadinternal.image.ImageTypeImpl;
import org.apache.myfaces.trinidadinternal.image.laf.browser.BlafImageUtils;
import org.apache.myfaces.trinidadinternal.share.util.NamespaceMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageTypeManager {
    private static ImageTypeManager _sDefaultInstance;
    private NamespaceMap _types = new NamespaceMap();

    public static ImageTypeManager getDefaultImageTypeManager() {
        if (_sDefaultInstance == null) {
            ImageTypeManager manager = new ImageTypeManager();
            BlafImageUtils.registerImageTypes(manager);
            _sDefaultInstance = manager;
        }
        return _sDefaultInstance;
    }

    public synchronized ImageType getImageType(String namespace, String name) {
        return (ImageType)this._types.get(namespace, name);
    }

    public synchronized ImageType registerImageType(String namespace, String name, Map<Object, Object> properties) {
        ImageType type = this.getImageType(namespace, name);
        if (type != null) {
            assert (type instanceof ImageTypeImpl);
            ((ImageTypeImpl)type).setProperties(properties);
        } else {
            type = new ImageTypeImpl(namespace, name, properties);
            this._types.put(namespace, name, type);
        }
        return type;
    }

    public synchronized void unregisterImageType(ImageType type) {
        this._types.remove(type.getNamespaceURI(), type.getLocalName());
    }
}

