/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.convert;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.convert.ConverterUtils;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ComponentUtils;
import org.apache.myfaces.trinidad.util.MessageFactory;

public class NumberConverter
extends javax.faces.convert.NumberConverter {
    public static final String CONVERTER_ID = "org.apache.myfaces.trinidad.Number";
    public static final String CONVERT_PATTERN_MESSAGE_ID = "org.apache.myfaces.trinidad.convert.NumberConverter.CONVERT_PATTERN";
    public static final String CONVERT_NUMBER_MESSAGE_ID = "org.apache.myfaces.trinidad.convert.NumberConverter.CONVERT_NUMBER";
    public static final String CONVERT_CURRENCY_MESSAGE_ID = "org.apache.myfaces.trinidad.convert.NumberConverter.CONVERT_CURRENCY";
    public static final String CONVERT_PERCENT_MESSAGE_ID = "org.apache.myfaces.trinidad.convert.NumberConverter.CONVERT_PERCENT";
    private static final FacesBean.Type _TYPE = new FacesBean.Type();
    private static final PropertyKey _CONVERT_CURRENCY_MESSAGE_DETAIL_KEY = _TYPE.registerKey("messageDetailConvertCurrency", String.class);
    private static final PropertyKey _CONVERT_NUMBER_MESSAGE_DETAIL_KEY = _TYPE.registerKey("messageDetailConvertNumber", String.class);
    private static final PropertyKey _CONVERT_PATTERN_MESSAGE_DETAIL_KEY = _TYPE.registerKey("messageDetailConvertPattern", String.class);
    private static final PropertyKey _CONVERT_PERCENT_MESSAGE_DETAIL_KEY = _TYPE.registerKey("messageDetailConvertPercent", String.class);
    private static final PropertyKey _HINT_PATTERN_KEY = _TYPE.registerKey("hintPattern", String.class);
    private static final PropertyKey _CURRENCY_CODE_KEY = _TYPE.registerKey("currencyCode", String.class);
    private static final PropertyKey _CURRENCY_SYMBOL_KEY = _TYPE.registerKey("currencySymbol", String.class);
    private static final PropertyKey _GROUPING_USED_KEY = _TYPE.registerKey("groupingUsed", Boolean.TYPE, Boolean.TRUE);
    private static final PropertyKey _INTEGER_ONLY_KEY = _TYPE.registerKey("integerOnly", Boolean.TYPE, Boolean.FALSE);
    private static final PropertyKey _LOCALE_KEY = _TYPE.registerKey("locale", Locale.class);
    private static final PropertyKey _MAX_FRACTION_DIGITS_KEY = _TYPE.registerKey("maxFractionDigits", Integer.TYPE);
    private static final PropertyKey _MAX_INTEGER_DIGITS_KEY = _TYPE.registerKey("maxIntegerDigits", Integer.TYPE);
    private static final PropertyKey _MIN_FRACTION_DIGITS_KEY = _TYPE.registerKey("minFractionDigits", Integer.TYPE);
    private static final PropertyKey _MIN_INTEGER_DIGITS_KEY = _TYPE.registerKey("minIntegerDigits", Integer.TYPE);
    private static final PropertyKey _PATTERN_KEY = _TYPE.registerKey("pattern", String.class);
    private static final PropertyKey _TYPE_KEY = _TYPE.registerKey("type", String.class, "numeric");
    private FacesBean _facesBean = ConverterUtils.getFacesBean(_TYPE);
    private static TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(NumberConverter.class);
    private static Map<String, Map<Locale, NumberFormat>> _numberFormatHolder = new HashMap<String, Map<Locale, NumberFormat>>();
    private static Map<Locale, DecimalFormatSymbols> _patternFormatSymbolsHolder = new HashMap<Locale, DecimalFormatSymbols>();
    private static final Object _TYPE_LOCK = new Object();
    private static final Object _SYMBOLS_LOCK = new Object();
    private static final int _NUMBER_TYPE = 1;
    private static final int _CURRENCY_TYPE = 2;
    private static final int _PERCENT_TYPE = 3;
    private static final int _PATTERN_TYPE = 4;
    private static final Number _EXAMPLE_PERCENT = 0.3423;
    private static final Number _EXAMPLE_CURRENCY = 10250;

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        if (null == context || null == component) {
            throw new NullPointerException(_LOG.getMessage("NULL_FACESCONTEXT_OR_UICOMPONENT"));
        }
        if (null == value) {
            return null;
        }
        if ((value = value.trim()).length() < 1) {
            return null;
        }
        String pattern = this.getPattern();
        String type = this.getType();
        if (null == pattern && null == type) {
            throw new IllegalArgumentException(_LOG.getMessage("EITHER_PATTERN_OR_TYPE_MUST_SPECIFIED"));
        }
        RequestContext reqCtx = RequestContext.getCurrentInstance();
        Locale locale = this._getLocale(reqCtx, context);
        NumberFormat fmt = this._getNumberFormat(pattern, type, locale, reqCtx);
        DecimalFormat df = (DecimalFormat)fmt;
        df.setParseBigDecimal(true);
        DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
        boolean changed = false;
        if (dfs.getGroupingSeparator() == '\u00a0') {
            dfs.setGroupingSeparator(' ');
            df.setDecimalFormatSymbols(dfs);
            value = value.replace('\u00a0', ' ');
            changed = true;
        }
        ParsePosition pp = new ParsePosition(0);
        Number num = (Number)fmt.parseObject(value, pp);
        int typeIdx = NumberConverter._getType(pattern, type);
        if (num == null && (typeIdx == 2 || typeIdx == 3)) {
            NumberFormat nfmt = NumberFormat.getNumberInstance(locale);
            DecimalFormat ndf = (DecimalFormat)nfmt;
            ndf.setParseBigDecimal(true);
            DecimalFormatSymbols ndfs = null;
            if (changed) {
                ndfs = ndf.getDecimalFormatSymbols();
                ndfs.setGroupingSeparator(' ');
                ndf.setDecimalFormatSymbols(ndfs);
            }
            num = (Number)nfmt.parseObject(value, pp);
            if (typeIdx == 3 && num != null) {
                num = num.doubleValue() / 100.0;
            }
        }
        if (changed) {
            dfs.setGroupingSeparator('\u00a0');
            df.setDecimalFormatSymbols(dfs);
        }
        if (pp.getIndex() != value.length()) {
            Object label = ConverterUtils.getComponentLabel(component);
            Object[] params = null;
            if (typeIdx == 4) {
                pattern = this.getLocalizedPattern(context, pattern, dfs);
                params = new Object[]{label, value, pattern};
            } else if (typeIdx == 1) {
                params = new Object[]{label, value};
            } else if (typeIdx == 2) {
                params = new Object[]{label, value, fmt.format(_EXAMPLE_CURRENCY)};
            } else if (typeIdx == 3) {
                params = new Object[]{label, value, fmt.format(_EXAMPLE_PERCENT)};
            }
            throw new ConverterException(this.getConvertMessage(context, component, value, params));
        }
        if (this.isIntegerOnly()) {
            return num.longValue();
        }
        return num;
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (null == context || null == component) {
            throw new NullPointerException(_LOG.getMessage("NULL_FACESCONTEXT_OR_UICOMPONENT"));
        }
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException(_LOG.getMessage("VALUE_NOT_JAVA_LANG_NUMBER_TYPE"));
        }
        String pattern = this.getPattern();
        String type = this.getType();
        if (null == pattern && null == type) {
            throw new IllegalArgumentException(_LOG.getMessage("EITHER_PATTERN_OR_TYPE_MUST_SPECIFIED"));
        }
        RequestContext reqCtx = RequestContext.getCurrentInstance();
        Locale locale = this._getLocale(reqCtx, context);
        NumberFormat formatter = this._getNumberFormat(pattern, type, locale, reqCtx);
        this._setFormatProperties(formatter);
        if ("currency".equals(type)) {
            this._setCurrencyFormattingProperties(reqCtx, formatter);
        }
        return formatter.format(value);
    }

    public void restoreState(FacesContext context, Object state) {
        this._facesBean.restoreState(context, state);
    }

    public Object saveState(FacesContext context) {
        return this._facesBean.saveState(context);
    }

    public void setValueExpression(String name, ValueExpression expression) {
        ConverterUtils.setValueExpression(this._facesBean, name, expression);
    }

    public ValueExpression getValueExpression(String name) {
        return ConverterUtils.getValueExpression(this._facesBean, name);
    }

    public void setValueBinding(String name, ValueBinding binding) {
        ConverterUtils.setValueBinding(this._facesBean, name, binding);
    }

    public ValueBinding getValueBinding(String name) {
        return ConverterUtils.getValueBinding(this._facesBean, name);
    }

    public void setMessageDetailConvertPattern(String convertPatternMessageDetail) {
        this._facesBean.setProperty(_CONVERT_PATTERN_MESSAGE_DETAIL_KEY, convertPatternMessageDetail);
    }

    public String getMessageDetailConvertPattern() {
        Object msg = this._facesBean.getProperty(_CONVERT_PATTERN_MESSAGE_DETAIL_KEY);
        return ComponentUtils.resolveString(msg);
    }

    public void setMessageDetailConvertNumber(String convertNumberMessageDetail) {
        this._facesBean.setProperty(_CONVERT_NUMBER_MESSAGE_DETAIL_KEY, convertNumberMessageDetail);
    }

    public String getMessageDetailConvertNumber() {
        Object msg = this._facesBean.getProperty(_CONVERT_NUMBER_MESSAGE_DETAIL_KEY);
        return ComponentUtils.resolveString(msg);
    }

    public void setMessageDetailConvertCurrency(String convertCurrencyMessageDetail) {
        this._facesBean.setProperty(_CONVERT_CURRENCY_MESSAGE_DETAIL_KEY, convertCurrencyMessageDetail);
    }

    public String getMessageDetailConvertCurrency() {
        Object msg = this._facesBean.getProperty(_CONVERT_CURRENCY_MESSAGE_DETAIL_KEY);
        return ComponentUtils.resolveString(msg);
    }

    public void setMessageDetailConvertPercent(String convertPercentMessageDetail) {
        this._facesBean.setProperty(_CONVERT_PERCENT_MESSAGE_DETAIL_KEY, convertPercentMessageDetail);
    }

    public String getMessageDetailConvertPercent() {
        Object msg = this._facesBean.getProperty(_CONVERT_PERCENT_MESSAGE_DETAIL_KEY);
        return ComponentUtils.resolveString(msg);
    }

    public void setHintPattern(String hintPattern) {
        this._facesBean.setProperty(_HINT_PATTERN_KEY, hintPattern);
    }

    public String getHintPattern() {
        Object obj = this._facesBean.getProperty(_HINT_PATTERN_KEY);
        return ComponentUtils.resolveString(obj);
    }

    public void setCurrencyCode(String currencyCode) {
        this._facesBean.setProperty(_CURRENCY_CODE_KEY, currencyCode);
    }

    public String getCurrencyCode() {
        Object currCode = this._facesBean.getProperty(_CURRENCY_CODE_KEY);
        return ComponentUtils.resolveString(currCode);
    }

    public void setCurrencySymbol(String currencySymbol) {
        this._facesBean.setProperty(_CURRENCY_SYMBOL_KEY, currencySymbol);
    }

    public String getCurrencySymbol() {
        Object currSymbol = this._facesBean.getProperty(_CURRENCY_SYMBOL_KEY);
        return ComponentUtils.resolveString(currSymbol);
    }

    public void setGroupingUsed(boolean groupingUsed) {
        Boolean grpUsed = NumberConverter._getBooleanValue(groupingUsed);
        this._facesBean.setProperty(_GROUPING_USED_KEY, grpUsed);
    }

    public boolean isGroupingUsed() {
        Object grpUSed = this._facesBean.getProperty(_GROUPING_USED_KEY);
        return ComponentUtils.resolveBoolean(grpUSed, true);
    }

    public void setIntegerOnly(boolean integerOnly) {
        this._facesBean.setProperty(_INTEGER_ONLY_KEY, NumberConverter._getBooleanValue(integerOnly));
    }

    public boolean isIntegerOnly() {
        Object isInt = this._facesBean.getProperty(_INTEGER_ONLY_KEY);
        return ComponentUtils.resolveBoolean(isInt, false);
    }

    public void setLocale(Locale locale) {
        this._facesBean.setProperty(_LOCALE_KEY, locale);
    }

    public Locale getLocale() {
        Object locale = this._facesBean.getProperty(_LOCALE_KEY);
        return ComponentUtils.resolveLocale(locale);
    }

    public void setMaxFractionDigits(int maxFractionDigits) {
        this._facesBean.setProperty(_MAX_FRACTION_DIGITS_KEY, NumberConverter._getIntValue(maxFractionDigits));
    }

    public int getMaxFractionDigits() {
        Object value = this._facesBean.getProperty(_MAX_FRACTION_DIGITS_KEY);
        return ComponentUtils.resolveInteger(value);
    }

    public void setMaxIntegerDigits(int maxIntegerDigits) {
        this._facesBean.setProperty(_MAX_INTEGER_DIGITS_KEY, NumberConverter._getIntValue(maxIntegerDigits));
    }

    public int getMaxIntegerDigits() {
        Object value = this._facesBean.getProperty(_MAX_INTEGER_DIGITS_KEY);
        return ComponentUtils.resolveInteger(value);
    }

    public void setMinFractionDigits(int minFractionDigits) {
        this._facesBean.setProperty(_MIN_FRACTION_DIGITS_KEY, NumberConverter._getIntValue(minFractionDigits));
    }

    public int getMinFractionDigits() {
        Object value = this._facesBean.getProperty(_MIN_FRACTION_DIGITS_KEY);
        return ComponentUtils.resolveInteger(value);
    }

    public void setMinIntegerDigits(int minIntegerDigits) {
        this._facesBean.setProperty(_MIN_INTEGER_DIGITS_KEY, NumberConverter._getIntValue(minIntegerDigits));
    }

    public int getMinIntegerDigits() {
        Object value = this._facesBean.getProperty(_MIN_INTEGER_DIGITS_KEY);
        return ComponentUtils.resolveInteger(value);
    }

    public void setPattern(String pattern) {
        this._facesBean.setProperty(_PATTERN_KEY, pattern);
    }

    public String getPattern() {
        Object pattern = this._facesBean.getProperty(_PATTERN_KEY);
        return ComponentUtils.resolveString(pattern);
    }

    public String getLocalizedPattern(FacesContext context, String pattern, DecimalFormatSymbols dfs) {
        String symbol;
        if (pattern == null) {
            return null;
        }
        int idx = pattern.indexOf(164);
        if (idx == -1) {
            return pattern;
        }
        if (dfs == null) {
            String type = this.getType();
            RequestContext reqCtx = RequestContext.getCurrentInstance();
            Locale locale = this._getLocale(reqCtx, context);
            NumberFormat fmt = this._getNumberFormat(pattern, type, locale, reqCtx);
            DecimalFormat df = (DecimalFormat)fmt;
            dfs = df.getDecimalFormatSymbols();
        }
        if (idx + 1 < pattern.length() && pattern.charAt(idx + 1) == '\u00a4') {
            symbol = dfs.getInternationalCurrencySymbol();
            if (symbol.length() > 0) {
                pattern = pattern.replaceAll(new String(new char[]{'\u00a4', '\u00a4'}), Matcher.quoteReplacement(symbol));
            }
        } else {
            symbol = dfs.getCurrencySymbol();
            if (symbol.length() > 0) {
                pattern = pattern.replaceAll(new String(new char[]{'\u00a4'}), Matcher.quoteReplacement(symbol));
            }
        }
        return pattern;
    }

    public void setType(String type) {
        this._facesBean.setProperty(_TYPE_KEY, type);
    }

    public String getType() {
        Object type = this._facesBean.getProperty(_TYPE_KEY);
        return ComponentUtils.resolveString(type, "number");
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + NumberConverter._getHashValue(this.getLocale());
        result = result * 37 + NumberConverter._getHashValue(this.getCurrencyCode());
        result = result * 37 + NumberConverter._getHashValue(this.getCurrencySymbol());
        result = result * 37 + NumberConverter._getHashValue(this.getType());
        result = result * 37 + NumberConverter._getHashValue(this.getPattern());
        result = result * 37 + this.getMaxFractionDigits();
        result = result * 37 + this.getMaxIntegerDigits();
        result = result * 37 + this.getMinFractionDigits();
        result = result * 37 + this.getMinIntegerDigits();
        result = result * 37 + (this.isGroupingUsed() ? 1 : 0);
        result = result * 37 + (this.isIntegerOnly() ? 1 : 0);
        result = result * 37 + (this.isTransient() ? 1 : 0);
        result = result * 37 + NumberConverter._getHashValue(this.getMessageDetailConvertPattern());
        result = result * 37 + NumberConverter._getHashValue(this.getMessageDetailConvertNumber());
        result = result * 37 + NumberConverter._getHashValue(this.getMessageDetailConvertCurrency());
        result = result * 37 + NumberConverter._getHashValue(this.getMessageDetailConvertPercent());
        return result;
    }

    public boolean equals(Object numberConverter) {
        if (this == numberConverter) {
            return true;
        }
        if (numberConverter instanceof NumberConverter) {
            NumberConverter nConv = (NumberConverter)((Object)numberConverter);
            return this.getMaxFractionDigits() == nConv.getMaxFractionDigits() && this.getMaxIntegerDigits() == nConv.getMaxIntegerDigits() && this.getMinFractionDigits() == nConv.getMinFractionDigits() && this.getMinIntegerDigits() == nConv.getMinIntegerDigits() && this.isTransient() == nConv.isTransient() && this.isGroupingUsed() == nConv.isGroupingUsed() && this.isIntegerOnly() == nConv.isIntegerOnly() && ConverterUtils.equals(this.getType(), nConv.getType()) && ConverterUtils.equals(this.getLocale(), nConv.getLocale()) && ConverterUtils.equals(this.getCurrencyCode(), nConv.getCurrencyCode()) && ConverterUtils.equals(this.getCurrencySymbol(), nConv.getCurrencySymbol()) && ConverterUtils.equals(this.getPattern(), nConv.getPattern()) && ConverterUtils.equals(this.getMessageDetailConvertPattern(), nConv.getMessageDetailConvertPattern()) && ConverterUtils.equals(this.getMessageDetailConvertNumber(), nConv.getMessageDetailConvertNumber()) && ConverterUtils.equals(this.getMessageDetailConvertCurrency(), nConv.getMessageDetailConvertCurrency()) && ConverterUtils.equals(this.getMessageDetailConvertPercent(), nConv.getMessageDetailConvertPercent());
        }
        return false;
    }

    private static int _getHashValue(Object obj) {
        return obj == null ? 0 : obj.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DecimalFormatSymbols _getCachedDecimalFormatSymbol(Locale locale) {
        Object object = _SYMBOLS_LOCK;
        synchronized (object) {
            DecimalFormatSymbols dfs = _patternFormatSymbolsHolder.get(locale);
            if (dfs != null) {
                return (DecimalFormatSymbols)dfs.clone();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _cacheDecimalFormatSymbols(Locale locale, DecimalFormatSymbols symbols) {
        Object object = _SYMBOLS_LOCK;
        synchronized (object) {
            if (_patternFormatSymbolsHolder == null) {
                _patternFormatSymbolsHolder = new HashMap<Locale, DecimalFormatSymbols>();
            } else {
                _patternFormatSymbolsHolder.put(locale, (DecimalFormatSymbols)symbols.clone());
            }
        }
    }

    private static Boolean _getBooleanValue(boolean value) {
        return value ? Boolean.TRUE : Boolean.FALSE;
    }

    private static Integer _getIntValue(int value) {
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NumberFormat _getCachedNumberFormat(String pattern, String type, Locale locale) {
        Object object = _TYPE_LOCK;
        synchronized (object) {
            String key = pattern != null ? pattern : type;
            Map<Locale, NumberFormat> nfMap = _numberFormatHolder.get(key);
            if (nfMap == null) {
                return null;
            }
            NumberFormat nf = nfMap.get(locale);
            if (nf != null) {
                return (NumberFormat)nf.clone();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _cacheNumberFormat(NumberFormat format, String pattern, String type, Locale locale) {
        Object object = _TYPE_LOCK;
        synchronized (object) {
            if (_numberFormatHolder == null) {
                _numberFormatHolder = new HashMap<String, Map<Locale, NumberFormat>>();
            } else {
                String key = pattern != null ? pattern : type;
                Map<Locale, NumberFormat> nfMap = _numberFormatHolder.get(key);
                if (nfMap == null) {
                    nfMap = new HashMap<Locale, NumberFormat>();
                    _numberFormatHolder.put(key, nfMap);
                }
                nfMap.put(locale, (NumberFormat)format.clone());
            }
        }
    }

    private NumberFormat _getNumberFormat(String pattern, String type, Locale locale, RequestContext reqCtx) {
        int formatType = NumberConverter._getType(pattern, type);
        NumberFormat nfmt = this._getCachedNumberFormat(pattern, type, locale);
        if (nfmt == null) {
            nfmt = this._getNumberFormatter(formatType, pattern, locale);
            this._cacheNumberFormat(nfmt, pattern, type, locale);
        }
        if (nfmt instanceof DecimalFormat) {
            DecimalFormat dfmt = (DecimalFormat)nfmt;
            DecimalFormatSymbols dfSymbols = dfmt.getDecimalFormatSymbols();
            this._setUpDecimalSymbolFormatProperties(dfSymbols, reqCtx, locale);
            ((DecimalFormat)nfmt).setDecimalFormatSymbols(dfSymbols);
        } else if (_LOG.isWarning()) {
            _LOG.warning("Failed to get hold of DecimalFormat for type: +" + type + "\n" + "decimal separator," + "number grouping separator," + "currency code" + "will be defaulted based on locale " + locale.toString());
        }
        return nfmt;
    }

    private void _setUpDecimalSymbolFormatProperties(DecimalFormatSymbols symbols, RequestContext reqCtx, Locale locale) {
        if (reqCtx != null) {
            char ch = '\u0000';
            ch = reqCtx.getDecimalSeparator();
            if (ch != '\u0000') {
                symbols.setDecimalSeparator(ch);
            }
            if ((ch = reqCtx.getNumberGroupingSeparator()) != '\u0000') {
                symbols.setGroupingSeparator(ch);
            }
        } else if (_LOG.isWarning()) {
            _LOG.warning("NULL_REQUESTCONTEXT", locale.toString());
        }
    }

    private void _setFormatProperties(NumberFormat formatter) {
        formatter.setGroupingUsed(this.isGroupingUsed());
        if (this.isMaximumFractionDigitsSet()) {
            formatter.setMaximumFractionDigits(this.getMaxFractionDigits());
        }
        if (this.isMaximumIntegerDigitsSet()) {
            formatter.setMaximumIntegerDigits(this.getMaxIntegerDigits());
        }
        if (this.isMinimumFractionDigitsSet()) {
            formatter.setMinimumFractionDigits(this.getMinFractionDigits());
        }
        if (this.isMinimumIntegerDigitsSet()) {
            formatter.setMinimumIntegerDigits(this.getMinIntegerDigits());
        }
    }

    private void _setCurrencyInformation(RequestContext context, DecimalFormatSymbols symbols) {
        String currencyCode = this._getCurrencyCode(context);
        if (currencyCode != null) {
            symbols.setCurrency(Currency.getInstance(currencyCode));
            return;
        }
        if (this.getCurrencySymbol() != null) {
            symbols.setCurrencySymbol(this.getCurrencySymbol());
            _LOG.fine("Using currency symbol as currecny code evaluates to null");
        }
    }

    private NumberFormat _getNumberFormatter(int formatType, String pattern, Locale locale) {
        NumberFormat nfmt;
        if (4 == formatType) {
            DecimalFormatSymbols symbols = NumberConverter._getCachedDecimalFormatSymbol(locale);
            if (null == symbols) {
                symbols = new DecimalFormatSymbols(locale);
                NumberConverter._cacheDecimalFormatSymbols(locale, symbols);
            }
            nfmt = new DecimalFormat(pattern, symbols);
        } else if (1 == formatType) {
            nfmt = NumberFormat.getNumberInstance(locale);
        } else if (2 == formatType) {
            nfmt = NumberFormat.getCurrencyInstance(locale);
        } else if (3 == formatType) {
            nfmt = NumberFormat.getPercentInstance(locale);
        } else {
            assert (formatType > 4 || formatType < 1) : "invalid type";
            nfmt = null;
        }
        return nfmt;
    }

    private Object _getRawConvertCurrencyMessageDetail() {
        return this._facesBean.getRawProperty(_CONVERT_CURRENCY_MESSAGE_DETAIL_KEY);
    }

    private Object _getRawConvertNumberMessageDetail() {
        return this._facesBean.getRawProperty(_CONVERT_NUMBER_MESSAGE_DETAIL_KEY);
    }

    private Object _getRawConvertPatternMessageDetail() {
        return this._facesBean.getRawProperty(_CONVERT_PATTERN_MESSAGE_DETAIL_KEY);
    }

    private Object _getRawConvertPercentMessageDetail() {
        return this._facesBean.getRawProperty(_CONVERT_PERCENT_MESSAGE_DETAIL_KEY);
    }

    protected final FacesMessage getConvertMessage(FacesContext context, UIComponent component, String inputValue, Object[] params) {
        String msgId;
        Object convMsgDet;
        int type = NumberConverter._getType(this.getPattern(), this.getType());
        if (4 == type) {
            convMsgDet = this._getRawConvertPatternMessageDetail();
            msgId = CONVERT_PATTERN_MESSAGE_ID;
        } else if (1 == type) {
            convMsgDet = this._getRawConvertNumberMessageDetail();
            msgId = CONVERT_NUMBER_MESSAGE_ID;
        } else if (2 == type) {
            convMsgDet = this._getRawConvertCurrencyMessageDetail();
            msgId = CONVERT_CURRENCY_MESSAGE_ID;
        } else if (3 == type) {
            convMsgDet = this._getRawConvertPercentMessageDetail();
            msgId = CONVERT_PERCENT_MESSAGE_ID;
        } else {
            throw new IllegalArgumentException("Invalid type: " + this.getType());
        }
        return MessageFactory.getMessage(context, msgId, convMsgDet, params, component);
    }

    private Locale _getLocale(RequestContext rc, FacesContext context) {
        Locale locale = this.getLocale();
        if (locale == null && (locale = rc.getFormattingLocale()) == null) {
            locale = context.getViewRoot().getLocale();
        }
        return locale;
    }

    private String _getCurrencyCode(RequestContext context) {
        String currencyCode = this.getCurrencyCode();
        if (currencyCode == null) {
            if (context != null) {
                currencyCode = context.getCurrencyCode();
            } else {
                _LOG.warning("NULL_REQUEST_CONTEXT_UNABLE_GET_CURRENCY_CODE");
            }
        }
        return currencyCode;
    }

    private void _setCurrencyFormattingProperties(RequestContext context, NumberFormat numberFormatter) {
        if (numberFormatter instanceof DecimalFormat) {
            DecimalFormat dfmt = (DecimalFormat)numberFormatter;
            DecimalFormatSymbols symbols = dfmt.getDecimalFormatSymbols();
            this._setCurrencyInformation(context, symbols);
            dfmt.setDecimalFormatSymbols(symbols);
        } else {
            _LOG.warning("NUMBER_NOT_DECIMALFORMAT_IGNORE_CURRENCY");
        }
    }

    private static int _getType(String pattern, String type) {
        if (pattern != null) {
            return 4;
        }
        if ("number".equals(type)) {
            return 1;
        }
        if ("currency".equals(type)) {
            return 2;
        }
        if ("percent".equals(type)) {
            return 3;
        }
        throw new IllegalArgumentException(_LOG.getMessage("NOT_VALID_TYPE", type));
    }

    protected boolean isMaximumFractionDigitsSet() {
        return this._facesBean.getProperty(_MAX_FRACTION_DIGITS_KEY) != null;
    }

    protected boolean isMinimumFractionDigitsSet() {
        return this._facesBean.getProperty(_MIN_FRACTION_DIGITS_KEY) != null;
    }

    protected boolean isMaximumIntegerDigitsSet() {
        return this._facesBean.getProperty(_MAX_INTEGER_DIGITS_KEY) != null;
    }

    protected boolean isMinimumIntegerDigitsSet() {
        return this._facesBean.getProperty(_MIN_INTEGER_DIGITS_KEY) != null;
    }
}

