/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import org.apache.myfaces.tobago.component.RendererTypes;
import org.apache.myfaces.tobago.component.Tags;
import org.apache.myfaces.tobago.component.Visual;
import org.apache.myfaces.tobago.internal.component.AbstractUILayoutBase;
import org.apache.myfaces.tobago.internal.component.AbstractUIStyle;
import org.apache.myfaces.tobago.layout.AlignItems;
import org.apache.myfaces.tobago.layout.JustifyContent;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.layout.MeasureList;
import org.apache.myfaces.tobago.util.ComponentUtils;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public abstract class AbstractUIFlexLayout
extends AbstractUILayoutBase {
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.tobago.FlexLayout";

    public void processEvent(ComponentSystemEvent event) {
        if (event instanceof PostAddToViewEvent) {
            MeasureList tokens;
            FacesContext facesContext = this.getFacesContext();
            boolean horizontal = this.isHorizontal();
            MeasureList measureList = tokens = horizontal ? this.getColumns() : this.getRows();
            if (tokens == null) {
                tokens = new MeasureList();
                tokens.add(Measure.AUTO);
            }
            if (tokens.getSize() > 0) {
                int i = 0;
                for (UIComponent child : this.getChildren()) {
                    Measure token;
                    Measure.Unit unit;
                    if (!(child instanceof Visual)) continue;
                    if (i >= tokens.getSize()) {
                        i = 0;
                    }
                    if ((unit = (token = tokens.get(i++)).getUnit()) == Measure.Unit.AUTO) continue;
                    AbstractUIStyle style = ComponentUtils.findChild(child, AbstractUIStyle.class);
                    if (style == null) {
                        style = (AbstractUIStyle)facesContext.getApplication().createComponent(facesContext, Tags.style.componentType(), RendererTypes.Style.name());
                        style.setTransient(true);
                        child.getChildren().add(style);
                    }
                    if (unit == Measure.Unit.FR) {
                        float factor = token.getValue();
                        style.setFlexGrow(Float.valueOf(factor));
                        style.setFlexShrink(0);
                        style.setFlexBasis(Measure.ZERO);
                        continue;
                    }
                    if (horizontal) {
                        style.setWidth(token);
                        continue;
                    }
                    style.setHeight(token);
                }
            }
        }
    }

    public abstract MeasureList getColumns();

    public abstract MeasureList getRows();

    public abstract AlignItems getAlignItems();

    public abstract JustifyContent getJustifyContent();

    public boolean isHorizontal() {
        return this.getRows() == null;
    }
}

