/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.tobago.component.SupportsAccessKey;
import org.apache.myfaces.tobago.config.Configurable;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.internal.component.AbstractUICommand;
import org.apache.myfaces.tobago.internal.component.AbstractUILink;
import org.apache.myfaces.tobago.internal.util.AccessKeyLogger;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.layout.PixelMeasure;
import org.apache.myfaces.tobago.renderkit.CommandRendererBase;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.Command;
import org.apache.myfaces.tobago.renderkit.html.CommandMap;
import org.apache.myfaces.tobago.renderkit.html.JsonUtils;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkRenderer
extends CommandRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(LinkRenderer.class);

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUILink link = (AbstractUILink)component;
        String clientId = link.getClientId(facesContext);
        boolean disabled = link.isDisabled();
        LabelWithAccessKey label = new LabelWithAccessKey((SupportsAccessKey)link);
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        if (disabled) {
            writer.startElement("span", (UIComponent)link);
        } else {
            Integer tabIndex;
            writer.startElement("a", (UIComponent)link);
            CommandMap map = new CommandMap(new Command(facesContext, (AbstractUICommand)link));
            writer.writeAttribute("data-tobago-commands", JsonUtils.encode(map), true);
            writer.writeAttribute("href", "#", false);
            if (label.getAccessKey() != null) {
                writer.writeAttribute("accesskey", Character.toString(label.getAccessKey().charValue()), false);
                AccessKeyLogger.addAccessKey((FacesContext)facesContext, (Character)label.getAccessKey(), (String)clientId);
            }
            if ((tabIndex = link.getTabIndex()) != null) {
                writer.writeAttribute("tabindex", tabIndex.intValue());
            }
        }
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)link);
        Style style = new Style(facesContext, (LayoutBase)link);
        writer.writeStyleAttribute(style);
        writer.writeClassAttribute(Classes.create((UIComponent)link));
        writer.writeIdAttribute(clientId);
        writer.writeNameAttribute(clientId);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)link);
        if (title != null) {
            writer.writeAttribute("title", title, true);
        }
        writer.flush();
        String image = link.getImage();
        if (image != null) {
            if (!ResourceManagerUtils.isAbsoluteResource((String)image)) {
                image = this.getImageWithPath(facesContext, image, disabled);
            }
            writer.startElement("img", (UIComponent)link);
            writer.writeClassAttribute(Classes.create((UIComponent)link, (String)"image"));
            writer.writeAttribute("src", image, true);
            writer.writeAttribute("border", 0);
            String tip = link.getTip();
            writer.writeAttribute("alt", tip != null ? tip : "", true);
            if (tip != null) {
                writer.writeAttribute("title", tip, true);
            }
            writer.endElement("img");
        }
        if (label.getLabel() != null) {
            if (image != null) {
                writer.write(" ");
            }
            HtmlRendererUtils.writeLabelWithAccessKey(writer, label);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUILink link = (AbstractUILink)component;
        ResponseWriter writer = facesContext.getResponseWriter();
        if (link.isDisabled()) {
            writer.endElement("span");
        } else {
            writer.endElement("a");
        }
    }

    public Measure getPreferredWidth(FacesContext facesContext, Configurable component) {
        if (!(component instanceof AbstractUILink)) {
            return Measure.valueOf((int)100);
        }
        AbstractUILink link = (AbstractUILink)component;
        LabelWithAccessKey label = new LabelWithAccessKey((SupportsAccessKey)link);
        String text = label.getLabel();
        String image = link.getImage();
        Measure width = PixelMeasure.ZERO;
        if (text != null) {
            Measure m = RenderUtils.calculateStringWidth(facesContext, (UIComponent)link, text);
            width = width.add(m);
        }
        if (text != null && image != null) {
            width = width.add(4);
        }
        if (image != null) {
            width = width.add(16);
        }
        return width;
    }
}

