/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.webapp;

import java.io.IOException;
import java.io.Writer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.tobago.ajax.AjaxUtils;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;

public abstract class TobagoResponseWriter
extends ResponseWriter {
    public abstract void startElement(String var1, UIComponent var2) throws IOException;

    @Deprecated
    public void startElement(String name) throws IOException {
        this.startElement(name, null);
    }

    public abstract void endElement(String var1) throws IOException;

    public abstract void write(String var1) throws IOException;

    public abstract void writeComment(Object var1) throws IOException;

    public abstract ResponseWriter cloneWithWriter(Writer var1);

    @Deprecated
    public abstract void writeAttribute(String var1, Object var2, String var3) throws IOException;

    @Deprecated
    public abstract void writeText(Object var1, String var2) throws IOException;

    public abstract void flush() throws IOException;

    public abstract void writeAttribute(String var1, String var2, boolean var3) throws IOException;

    public void writeAttribute(String name, boolean on) throws IOException {
        if (on) {
            this.writeAttribute(name, name, false);
        }
    }

    public void writeAttribute(String name, int number) throws IOException {
        this.writeAttribute(name, Integer.toString(number), false);
    }

    @Deprecated
    public void writeAttributeFromComponent(String name, String property) throws IOException {
        this.writeAttribute(name, null, property);
    }

    public void writeIdAttribute(String id) throws IOException {
        this.writeAttribute("id", id, false);
    }

    public void writeNameAttribute(String name) throws IOException {
        this.writeAttribute("name", name, false);
    }

    @Deprecated
    public void writeClassAttribute(String cssClass) throws IOException {
        this.writeAttribute("class", cssClass, false);
    }

    public void writeClassAttribute(Classes classes) throws IOException {
        this.writeAttribute("class", classes.getStringValue(), false);
    }

    @Deprecated
    public abstract String getStyleClasses();

    @Deprecated
    public abstract void writeClassAttribute() throws IOException;

    public void writeStyleAttribute(Style style) throws IOException {
        String json;
        if (style != null && (json = style.encodeJson()).length() > 2) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            this.writeAttribute("data-tobago-style", json, style.needsToBeEscaped() || AjaxUtils.isAjaxRequest(facesContext));
        }
    }

    @Deprecated
    public void writeStyleAttribute(String style) throws IOException {
        this.writeAttribute("style", style, false);
    }

    @Deprecated
    public void writeJavascript(String script) throws IOException {
        this.startJavascript();
        this.write(script);
        this.endJavascript();
    }

    @Deprecated
    public void endJavascript() throws IOException {
        this.endElement("script");
    }

    @Deprecated
    public void startJavascript() throws IOException {
        this.startElement("script", null);
        this.writeAttribute("type", "text/javascript", false);
        this.flush();
    }

    public void writeText(String text) throws IOException {
        this.writeText(text, null);
    }

    public void writeTextFromComponent(String property) throws IOException {
        this.writeText(null, property);
    }

    public String getContentTypeWithCharSet() {
        String characterEncoding;
        String contentType = this.getContentType();
        if (contentType == null) {
            contentType = "text/html";
        }
        if ((characterEncoding = this.getCharacterEncoding()) == null) {
            characterEncoding = "UTF-8";
        }
        StringBuilder builder = new StringBuilder(contentType);
        builder.append("; charset=");
        builder.append(characterEncoding);
        return builder.toString();
    }
}

