/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UICalendar;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.model.CalendarModel;
import org.apache.myfaces.tobago.model.DateModel;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class CalendarRenderer
extends LayoutComponentRendererBase {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Calendar calendar;
        UICalendar output = (UICalendar)component;
        String id = output.getClientId(facesContext);
        Locale locale = facesContext.getViewRoot().getLocale();
        Object value = output.getValue();
        if (value instanceof Calendar) {
            calendar = (Calendar)value;
        } else {
            calendar = new GregorianCalendar();
            if (value instanceof Date) {
                calendar.setTime((Date)value);
            }
        }
        CalendarModel model = new CalendarModel(calendar);
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        writer.startElement("div", component);
        writer.writeIdAttribute(id);
        writer.writeClassAttribute(Classes.create((UIComponent)output));
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
        Style style = new Style(facesContext, (LayoutBase)output);
        writer.writeStyleAttribute(style);
        String dateInputId = (String)output.getAttributes().get("dateInputId");
        if (dateInputId != null) {
            writer.writeAttribute("data-tobago-date-input-id", dateInputId, false);
        }
        writer.writeAttribute("data-tobago-day", Integer.toString(calendar.get(1)), false);
        writer.writeAttribute("data-tobago-month", Integer.toString(1 + calendar.get(2)), false);
        writer.writeAttribute("data-tobago-year", Integer.toString(calendar.get(5)), false);
        writer.writeAttribute("data-tobago-first-day-of-week", Integer.toString(calendar.getFirstDayOfWeek()), false);
        writer.writeAttribute("data-tobago-month-names", this.getMonthNames(locale), false);
        writer.startElement("div", null);
        writer.writeClassAttribute(Classes.create((UIComponent)output, (String)"row"));
        writer.startElement("img", null);
        writer.writeClassAttribute(Classes.create((UIComponent)output, (String)"header"));
        writer.writeAttribute("alt", "", false);
        writer.writeAttribute("src", ResourceManagerUtils.getImage((FacesContext)facesContext, (String)"image/calendarFastPrev"), false);
        writer.writeAttribute("data-tobago-command", "fastPrev", false);
        writer.endElement("img");
        writer.startElement("img", null);
        writer.writeClassAttribute(Classes.create((UIComponent)output, (String)"header"));
        writer.writeAttribute("alt", "", false);
        writer.writeAttribute("src", ResourceManagerUtils.getImage((FacesContext)facesContext, (String)"image/calendarPrev"), false);
        writer.writeAttribute("data-tobago-command", "prev", false);
        writer.endElement("img");
        writer.startElement("span", null);
        writer.writeClassAttribute(Classes.create((UIComponent)output, (String)"header"));
        writer.startElement("span", null);
        writer.writeAttribute("data-tobago-command", "month", false);
        writer.writeText(new SimpleDateFormat("MMMMM", locale).format(calendar.getTime()));
        writer.endElement("span");
        writer.writeText("\u00a0");
        writer.startElement("span", null);
        writer.writeAttribute("data-tobago-command", "year", false);
        writer.writeText(new SimpleDateFormat("yyyy", locale).format(calendar.getTime()));
        writer.endElement("span");
        writer.endElement("span");
        writer.startElement("img", null);
        writer.writeClassAttribute(Classes.create((UIComponent)output, (String)"header"));
        writer.writeAttribute("alt", "", false);
        writer.writeAttribute("src", ResourceManagerUtils.getImage((FacesContext)facesContext, (String)"image/calendarNext"), false);
        writer.writeAttribute("data-tobago-command", "next", false);
        writer.endElement("img");
        writer.startElement("img", null);
        writer.writeClassAttribute(Classes.create((UIComponent)output, (String)"header"));
        writer.writeAttribute("alt", "", false);
        writer.writeAttribute("src", ResourceManagerUtils.getImage((FacesContext)facesContext, (String)"image/calendarFastNext"), false);
        writer.writeAttribute("data-tobago-command", "fastNext", false);
        writer.endElement("img");
        writer.endElement("div");
        writer.startElement("div", null);
        writer.writeClassAttribute(Classes.create((UIComponent)output, (String)"row"));
        SimpleDateFormat dayInWeekFormat = new SimpleDateFormat("E", locale);
        for (int dayIt = 0; dayIt < 7; ++dayIt) {
            DateModel date = model.getDate(0, dayIt);
            String dayName = dayInWeekFormat.format(date.getCalendar().getTime());
            if (dayName != null && dayName.length() > 2) {
                dayName = dayName.substring(0, 2);
            }
            writer.startElement("span", null);
            writer.writeClassAttribute(Classes.create((UIComponent)output, (String)"dayOfWeek"));
            writer.writeText(dayName);
            writer.endElement("span");
        }
        writer.endElement("div");
        writer.startElement("div", null);
        writer.writeClassAttribute(Classes.create((UIComponent)output, (String)"grid"));
        for (int week = 0; week < 6; ++week) {
            writer.startElement("div", null);
            writer.writeClassAttribute(Classes.create((UIComponent)output, (String)"row"));
            for (int dayIt = 0; dayIt < 7; ++dayIt) {
                DateModel date = model.getDate(week, dayIt);
                String dayDescription = String.valueOf(date.getDay());
                writer.startElement("span", null);
                writer.writeClassAttribute(Classes.create((UIComponent)output, (String)"day", (Markup)(date.getMonth() == model.getMonth() ? null : Markup.DISABLED)));
                writer.writeText(dayDescription);
                writer.endElement("span");
            }
            writer.endElement("div");
        }
        writer.endElement("div");
        writer.endElement("div");
    }

    private String getMonthNames(Locale locale) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMMMM", locale);
        StringBuilder buffer = new StringBuilder(64);
        Calendar calendar = Calendar.getInstance();
        calendar.set(2000, 0, 1);
        for (int month = 0; month < 12; ++month) {
            if (month > 0) {
                buffer.append(',');
            }
            buffer.append(dateFormat.format(calendar.getTime()));
            calendar.add(2, 1);
        }
        return buffer.toString();
    }
}

