/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.initializer.component;

import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlInputSecret;
import javax.faces.component.html.HtmlInputText;
import javax.faces.component.html.HtmlInputTextarea;
import javax.faces.component.html.HtmlSelectBooleanCheckbox;
import javax.faces.component.html.HtmlSelectManyCheckbox;
import javax.faces.component.html.HtmlSelectManyListbox;
import javax.faces.component.html.HtmlSelectManyMenu;
import javax.faces.component.html.HtmlSelectOneListbox;
import javax.faces.component.html.HtmlSelectOneMenu;
import javax.faces.component.html.HtmlSelectOneRadio;
import javax.faces.context.FacesContext;
import org.apache.myfaces.extensions.validator.core.initializer.component.ComponentInitializer;
import org.apache.myfaces.extensions.validator.internal.Priority;
import org.apache.myfaces.extensions.validator.internal.ToDo;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;
import org.apache.myfaces.extensions.validator.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.REUSE})
public abstract class AbstractHtmlCoreComponentsComponentInitializer
implements ComponentInitializer {
    @Override
    public void configureComponent(FacesContext facesContext, UIComponent uiComponent, Map<String, Object> metaData) {
        if (this.processComponent(uiComponent)) {
            if (this.validateEmptyFields() && this.isRequiredInitializationActive()) {
                this.configureRequiredAttribute(facesContext, uiComponent, metaData);
            }
            this.configureMaxLengthAttribute(facesContext, uiComponent, metaData);
        }
    }

    protected boolean validateEmptyFields() {
        return ExtValUtils.validateEmptyFields();
    }

    protected boolean isRequiredInitializationActive() {
        return ExtValUtils.isRequiredInitializationActive();
    }

    protected abstract void configureRequiredAttribute(FacesContext var1, UIComponent var2, Map<String, Object> var3);

    protected boolean processComponent(UIComponent uiComponent) {
        return uiComponent instanceof HtmlInputText || uiComponent instanceof HtmlInputSecret || uiComponent instanceof HtmlSelectBooleanCheckbox || uiComponent instanceof HtmlSelectOneListbox || uiComponent instanceof HtmlSelectOneMenu || uiComponent instanceof HtmlSelectOneRadio || uiComponent instanceof HtmlSelectManyCheckbox || uiComponent instanceof HtmlSelectManyListbox || uiComponent instanceof HtmlSelectManyMenu || uiComponent instanceof HtmlInputTextarea;
    }

    @ToDo(value=Priority.MEDIUM, description="refactor")
    protected boolean isRequiredInitializationSupported(UIComponent uiComponent) {
        boolean isReadOnly = !Boolean.FALSE.equals(ReflectionUtils.tryToInvokeMethod(uiComponent, ReflectionUtils.tryToGetMethod(uiComponent.getClass(), "isReadonly")));
        boolean isDisabled = !Boolean.FALSE.equals(ReflectionUtils.tryToInvokeMethod(uiComponent, ReflectionUtils.tryToGetMethod(uiComponent.getClass(), "isDisabled")));
        return !isReadOnly && !isDisabled;
    }

    protected void configureMaxLengthAttribute(FacesContext facesContext, UIComponent uiComponent, Map<String, Object> metaData) {
        if (metaData.containsKey("max_length")) {
            Object maxLength = metaData.get("max_length");
            if (!(maxLength instanceof Integer)) {
                return;
            }
            if (uiComponent instanceof HtmlInputText) {
                HtmlInputText htmlInputText = (HtmlInputText)uiComponent;
                htmlInputText.setMaxlength(((Integer)maxLength).intValue());
            } else if (uiComponent instanceof HtmlInputSecret) {
                HtmlInputSecret htmlInputSecret = (HtmlInputSecret)uiComponent;
                htmlInputSecret.setMaxlength(((Integer)maxLength).intValue());
            }
        }
    }
}

