/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.resource;

import jakarta.faces.context.FacesContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.config.webparameters.MyfacesConfig;
import org.apache.myfaces.resource.ResourceCachedInfo;
import org.apache.myfaces.resource.ResourceLoader;
import org.apache.myfaces.resource.ResourceMeta;
import org.apache.myfaces.util.lang.ConcurrentLRUCache;

public class ResourceHandlerCache {
    private static final Logger log = Logger.getLogger(ResourceHandlerCache.class.getName());
    private boolean _resourceCacheEnabled;
    private volatile ConcurrentLRUCache<Object, ResourceValue> _resourceCacheMap = null;
    private volatile ConcurrentLRUCache<Object, ResourceValue> _viewResourceCacheMap = null;
    private volatile ConcurrentLRUCache<Object, Boolean> _libraryExistsCacheMap = null;

    public ResourceHandlerCache() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        MyfacesConfig myfacesConfig = MyfacesConfig.getCurrentInstance(facesContext);
        this._resourceCacheEnabled = myfacesConfig.isResourceHandlerCacheEnabled();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Initializing ResourceHandlerCache; Enabled = " + this._resourceCacheEnabled);
        }
        if (this._resourceCacheEnabled) {
            int maxSize = myfacesConfig.getResourceHandlerCacheSize();
            this._resourceCacheMap = new ConcurrentLRUCache((maxSize * 4 + 3) / 3, maxSize);
            this._viewResourceCacheMap = new ConcurrentLRUCache((maxSize * 4 + 3) / 3, maxSize);
            this._libraryExistsCacheMap = new ConcurrentLRUCache((maxSize * 4 + 3) / 3, maxSize / 5);
        }
    }

    public boolean isResourceHandlerCacheEnabled() {
        return this._resourceCacheEnabled;
    }

    public ResourceValue getResource(String resourceName, String libraryName, String contentType, String localePrefix) {
        return this.getResource(resourceName, libraryName, contentType, localePrefix, null);
    }

    public ResourceValue getResource(String resourceName, String libraryName, String contentType, String localePrefix, String contractName) {
        if (!this.isResourceHandlerCacheEnabled()) {
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Attemping to get resource from cache for " + resourceName);
        }
        ResourceKey key = new ResourceKey(resourceName, libraryName, contentType, localePrefix, contractName);
        return this._resourceCacheMap.get(key);
    }

    public boolean containsResource(String resourceName, String libraryName, String contentType, String localePrefix) {
        return this.containsResource(resourceName, libraryName, contentType, localePrefix, null);
    }

    public boolean containsResource(String resourceName, String libraryName, String contentType, String localePrefix, String contractName) {
        if (!this.isResourceHandlerCacheEnabled()) {
            return false;
        }
        ResourceKey key = new ResourceKey(resourceName, libraryName, contentType, localePrefix);
        return this._resourceCacheMap.get(key) != null;
    }

    public void putResource(String resourceName, String libraryName, String contentType, String localePrefix, ResourceMeta resource, ResourceLoader loader) {
        this.putResource(resourceName, libraryName, contentType, localePrefix, null, resource, loader, null);
    }

    public void putResource(String resourceName, String libraryName, String contentType, String localePrefix, String contractName, ResourceMeta resource, ResourceLoader loader, ResourceCachedInfo info) {
        if (!this.isResourceHandlerCacheEnabled()) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Attemping to put resource to cache for " + resourceName);
        }
        this._resourceCacheMap.put(new ResourceKey(resourceName, libraryName, contentType, localePrefix, contractName), new ResourceValue(resource, loader, info));
    }

    public ResourceValue getResource(String resourceId) {
        if (!this.isResourceHandlerCacheEnabled()) {
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Attemping to get resource from cache for " + resourceId);
        }
        return this._resourceCacheMap.get(resourceId);
    }

    public ResourceValue getResource(String resourceId, String contractName) {
        if (!this.isResourceHandlerCacheEnabled()) {
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Attemping to get resource from cache for " + resourceId);
        }
        return this._resourceCacheMap.get(contractName + ":" + resourceId);
    }

    public boolean containsResource(String resourceId, String contractName) {
        if (!this.isResourceHandlerCacheEnabled()) {
            return false;
        }
        return this._resourceCacheMap.get(contractName + ":" + resourceId) != null;
    }

    public boolean containsResource(String resourceId) {
        if (!this.isResourceHandlerCacheEnabled()) {
            return false;
        }
        return this._resourceCacheMap.get(resourceId) != null;
    }

    public void putResource(String resourceId, ResourceMeta resource, ResourceLoader loader, ResourceCachedInfo info) {
        if (!this.isResourceHandlerCacheEnabled()) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Attemping to put resource to cache for " + resourceId);
        }
        if (resource.getContractName() != null) {
            this._resourceCacheMap.put(resource.getContractName() + ":" + resourceId, new ResourceValue(resource, loader));
        } else {
            this._resourceCacheMap.put(resourceId, new ResourceValue(resource, loader, info));
        }
    }

    public boolean containsViewResource(String resourceName, String contentType, String localePrefix) {
        return this.containsViewResource(resourceName, contentType, localePrefix, null);
    }

    public boolean containsViewResource(String resourceName, String contentType, String localePrefix, String contractName) {
        if (!this.isResourceHandlerCacheEnabled()) {
            return false;
        }
        ResourceKey key = new ResourceKey(resourceName, null, contentType, localePrefix, contractName);
        return this._viewResourceCacheMap.get(key) != null;
    }

    public ResourceValue getViewResource(String resourceName, String contentType, String localePrefix) {
        return this.getViewResource(resourceName, contentType, localePrefix, null);
    }

    public ResourceValue getViewResource(String resourceName, String contentType, String localePrefix, String contractName) {
        if (!this.isResourceHandlerCacheEnabled()) {
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Attemping to get resource from cache for " + resourceName);
        }
        ResourceKey key = new ResourceKey(resourceName, null, contentType, localePrefix, contractName);
        return this._viewResourceCacheMap.get(key);
    }

    public void putViewResource(String resourceName, String contentType, String localePrefix, ResourceMeta resource, ResourceLoader loader, ResourceCachedInfo info) {
        this.putViewResource(resourceName, contentType, localePrefix, null, resource, loader, info);
    }

    public void putViewResource(String resourceName, String contentType, String localePrefix, String contractName, ResourceMeta resource, ResourceLoader loader, ResourceCachedInfo info) {
        if (!this.isResourceHandlerCacheEnabled()) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Attemping to put resource to cache for " + resourceName);
        }
        this._viewResourceCacheMap.put(new ResourceKey(resourceName, null, contentType, localePrefix, contractName), new ResourceValue(resource, loader, info));
    }

    public Boolean libraryExists(String libraryName) {
        if (!this.isResourceHandlerCacheEnabled()) {
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Attemping to get libraryExists from cache for " + libraryName);
        }
        return this._libraryExistsCacheMap.get(libraryName);
    }

    public void confirmLibraryExists(String libraryName) {
        if (!this.isResourceHandlerCacheEnabled()) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Attemping to set confirmLibraryExists on cache " + libraryName);
        }
        this._libraryExistsCacheMap.put(libraryName, Boolean.TRUE);
    }

    public void confirmLibraryNotExists(String libraryName) {
        if (!this.isResourceHandlerCacheEnabled()) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Attemping to set confirmLibraryNotExists on cache " + libraryName);
        }
        this._libraryExistsCacheMap.put(libraryName, Boolean.FALSE);
    }

    public static class ResourceValue {
        private final ResourceMeta resourceMeta;
        private final ResourceLoader resourceLoader;
        private final ResourceCachedInfo info;

        public ResourceValue(ResourceMeta resourceMeta, ResourceLoader resourceLoader) {
            this.resourceMeta = resourceMeta;
            this.resourceLoader = resourceLoader;
            this.info = null;
        }

        public ResourceValue(ResourceMeta resourceMeta, ResourceLoader resourceLoader, ResourceCachedInfo info) {
            this.resourceMeta = resourceMeta;
            this.resourceLoader = resourceLoader;
            this.info = info;
        }

        public ResourceMeta getResourceMeta() {
            return this.resourceMeta;
        }

        public ResourceLoader getResourceLoader() {
            return this.resourceLoader;
        }

        public ResourceCachedInfo getCachedInfo() {
            return this.info;
        }
    }

    public static class ResourceKey {
        private final String resourceName;
        private final String libraryName;
        private final String contentType;
        private final String localePrefix;
        private final String contractName;

        public ResourceKey(String resourceName, String libraryName, String contentType, String localePrefix) {
            this(resourceName, libraryName, contentType, localePrefix, null);
        }

        public ResourceKey(String resourceName, String libraryName, String contentType, String localePrefix, String contractName) {
            this.resourceName = resourceName;
            this.libraryName = libraryName;
            this.contentType = contentType;
            this.localePrefix = localePrefix;
            this.contractName = contractName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourceKey that = (ResourceKey)o;
            if (this.contentType != null ? !this.contentType.equals(that.contentType) : that.contentType != null) {
                return false;
            }
            if (this.libraryName != null ? !this.libraryName.equals(that.libraryName) : that.libraryName != null) {
                return false;
            }
            if (this.localePrefix != null ? !this.localePrefix.equals(that.localePrefix) : that.localePrefix != null) {
                return false;
            }
            if (this.resourceName != null ? !this.resourceName.equals(that.resourceName) : that.resourceName != null) {
                return false;
            }
            return !(this.contractName != null ? !this.contractName.equals(that.contractName) : that.contractName != null);
        }

        public int hashCode() {
            int result = this.resourceName != null ? this.resourceName.hashCode() : 0;
            result = 31 * result + (this.libraryName != null ? this.libraryName.hashCode() : 0);
            result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
            result = 31 * result + (this.localePrefix != null ? this.localePrefix.hashCode() : 0);
            result = 31 * result + (this.contractName != null ? this.contractName.hashCode() : 0);
            return result;
        }
    }
}

