/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi.impl;

import jakarta.faces.FacesException;
import jakarta.faces.context.ExternalContext;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.spi.ServiceProviderFinderFactory;
import org.apache.myfaces.spi.WebConfigProvider;
import org.apache.myfaces.spi.WebConfigProviderFactory;
import org.apache.myfaces.spi.impl.DefaultWebConfigProvider;
import org.apache.myfaces.util.lang.ClassUtils;

public class DefaultWebConfigProviderFactory
extends WebConfigProviderFactory {
    public static final String WEB_CONFIG_PROVIDER = WebConfigProvider.class.getName();
    public static final String WEB_CONFIG_PROVIDER_LIST = WebConfigProvider.class.getName() + ".LIST";

    private Logger getLogger() {
        return Logger.getLogger(DefaultWebConfigProviderFactory.class.getName());
    }

    @Override
    public WebConfigProvider getWebConfigProvider(ExternalContext externalContext) {
        WebConfigProvider returnValue = null;
        ExternalContext extContext = externalContext;
        try {
            returnValue = System.getSecurityManager() != null ? (WebConfigProvider)AccessController.doPrivileged(() -> this.resolveWebXmlProviderFromService(extContext)) : this.resolveWebXmlProviderFromService(extContext);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoClassDefFoundError | InvocationTargetException e) {
            this.getLogger().log(Level.SEVERE, "", e);
        }
        catch (PrivilegedActionException e) {
            throw new FacesException(e);
        }
        if (returnValue == null) {
            returnValue = new DefaultWebConfigProvider();
        }
        return returnValue;
    }

    private WebConfigProvider resolveWebXmlProviderFromService(ExternalContext externalContext) throws ClassNotFoundException, NoClassDefFoundError, InstantiationException, IllegalAccessException, InvocationTargetException, PrivilegedActionException {
        List<String> classList = (List<String>)externalContext.getApplicationMap().get(WEB_CONFIG_PROVIDER_LIST);
        if (classList == null) {
            classList = ServiceProviderFinderFactory.getServiceProviderFinder(externalContext).getServiceProviderList(WEB_CONFIG_PROVIDER);
            externalContext.getApplicationMap().put(WEB_CONFIG_PROVIDER_LIST, classList);
        }
        return ClassUtils.buildApplicationObject(WebConfigProvider.class, classList, new DefaultWebConfigProvider());
    }
}

