/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp;

import jakarta.el.ELContextListener;
import jakarta.el.ELResolver;
import jakarta.el.ExpressionFactory;
import jakarta.faces.FactoryFinder;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.lifecycle.LifecycleFactory;
import jakarta.servlet.ServletContext;
import jakarta.servlet.jsp.JspApplicationContext;
import jakarta.servlet.jsp.JspFactory;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.el.ResolverForJSPInitializer;
import org.apache.myfaces.el.unified.ELResolverBuilder;
import org.apache.myfaces.el.unified.ResolverBuilderForJSP;
import org.apache.myfaces.el.unified.resolver.FacesCompositeELResolver;
import org.apache.myfaces.webapp.AbstractFacesInitializer;
import org.apache.myfaces.webapp.FacesELContextListener;

public class Jsp21FacesInitializer
extends AbstractFacesInitializer {
    private static final Logger log = Logger.getLogger(Jsp21FacesInitializer.class.getName());
    private JspFactory jspFactory;

    @Override
    protected void initContainerIntegration(ServletContext servletContext, ExternalContext externalContext) {
        JspApplicationContext appCtx = this.getJspFactory().getJspApplicationContext(servletContext);
        appCtx.addELContextListener((ELContextListener)new FacesELContextListener());
        ExpressionFactory expressionFactory = Jsp21FacesInitializer.getUserDefinedExpressionFactory(externalContext);
        if (expressionFactory == null) {
            expressionFactory = appCtx.getExpressionFactory();
        }
        RuntimeConfig runtimeConfig = this.buildConfiguration(servletContext, externalContext, expressionFactory);
        this.configureResolverForJSP(appCtx, runtimeConfig);
    }

    protected JspFactory getJspFactory() {
        if (this.jspFactory == null) {
            try {
                Class.forName("org.apache.jasper.compiler.JspRuntimeContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Exception ex) {
                log.log(Level.FINE, "An unexpected exception occured while loading the JspRuntimeContext.", ex);
            }
            this.jspFactory = JspFactory.getDefaultFactory();
        }
        return this.jspFactory;
    }

    protected void setJspFactory(JspFactory jspFactory) {
        this.jspFactory = jspFactory;
    }

    private void configureResolverForJSP(JspApplicationContext appCtx, RuntimeConfig runtimeConfig) {
        FacesCompositeELResolver facesCompositeELResolver = new FacesCompositeELResolver(FacesCompositeELResolver.Scope.JSP);
        appCtx.addELResolver((ELResolver)facesCompositeELResolver);
        ResolverForJSPInitializer resolverForJSPInitializer = new ResolverForJSPInitializer(this.createResolverBuilderForJSP(runtimeConfig), facesCompositeELResolver);
        LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory("jakarta.faces.lifecycle.LifecycleFactory");
        Iterator<String> iter = factory.getLifecycleIds();
        while (iter.hasNext()) {
            factory.getLifecycle(iter.next()).addPhaseListener(resolverForJSPInitializer);
        }
    }

    protected ELResolverBuilder createResolverBuilderForJSP(RuntimeConfig runtimeConfig) {
        return new ResolverBuilderForJSP(runtimeConfig);
    }
}

