/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.component.behavior;

import jakarta.faces.component.PartialStateHolder;
import jakarta.faces.component.StateHolder;
import jakarta.faces.component.behavior.Behavior;
import jakarta.faces.component.behavior._AttachedDeltaWrapper;
import jakarta.faces.component.behavior._AttachedListStateWrapper;
import jakarta.faces.component.behavior._AttachedStateWrapper;
import jakarta.faces.component.behavior._DeltaList;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.BehaviorEvent;
import jakarta.faces.event.BehaviorListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class BehaviorBase
implements Behavior,
PartialStateHolder {
    private _DeltaList<BehaviorListener> _behaviorListeners;
    private boolean _initialState;
    private transient boolean _transient;

    @Override
    public void broadcast(BehaviorEvent event) throws AbortProcessingException {
        if (event == null) {
            throw new NullPointerException("event");
        }
        if (this._behaviorListeners != null) {
            for (int i = 0; i < this._behaviorListeners.size(); ++i) {
                BehaviorListener listener = (BehaviorListener)this._behaviorListeners.get(i);
                if (!event.isAppropriateListener(listener)) continue;
                event.processListener(listener);
            }
        }
    }

    @Override
    public void clearInitialState() {
        this._initialState = false;
        if (this._behaviorListeners != null) {
            this._behaviorListeners.clearInitialState();
        }
    }

    @Override
    public boolean initialStateMarked() {
        return this._initialState;
    }

    @Override
    public boolean isTransient() {
        return this._transient;
    }

    @Override
    public void markInitialState() {
        this._initialState = true;
        if (this._behaviorListeners != null) {
            this._behaviorListeners.markInitialState();
        }
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (state == null) {
            return;
        }
        if (state instanceof _AttachedDeltaWrapper) {
            this._behaviorListeners.restoreState(context, ((_AttachedDeltaWrapper)state).getWrappedStateObject());
        } else {
            this._behaviorListeners = (_DeltaList)BehaviorBase.restoreAttachedState(context, state);
        }
    }

    @Override
    public Object saveState(FacesContext context) {
        return this.saveBehaviorListenersList(context);
    }

    private Object saveBehaviorListenersList(FacesContext facesContext) {
        _DeltaList<BehaviorListener> holder = this._behaviorListeners;
        if (this.initialStateMarked() && this._behaviorListeners != null && holder.initialStateMarked()) {
            Object attachedState = holder.saveState(facesContext);
            if (attachedState != null) {
                return new _AttachedDeltaWrapper(this._behaviorListeners.getClass(), attachedState);
            }
            return null;
        }
        return BehaviorBase.saveAttachedState(facesContext, this._behaviorListeners);
    }

    private static Object saveAttachedState(FacesContext context, Object attachedObject) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (attachedObject == null) {
            return null;
        }
        if (attachedObject instanceof StateHolder) {
            StateHolder holder = (StateHolder)attachedObject;
            if (holder.isTransient()) {
                return null;
            }
            return new _AttachedStateWrapper(attachedObject.getClass(), holder.saveState(context));
        }
        if (attachedObject instanceof List) {
            ArrayList<Object> lst = new ArrayList<Object>(((List)attachedObject).size());
            for (Object item : (List)attachedObject) {
                if (item == null) continue;
                lst.add(BehaviorBase.saveAttachedState(context, item));
            }
            return new _AttachedListStateWrapper(lst);
        }
        if (attachedObject instanceof Serializable) {
            return attachedObject;
        }
        return new _AttachedStateWrapper(attachedObject.getClass(), null);
    }

    private static Object restoreAttachedState(FacesContext context, Object stateObj) throws IllegalStateException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (stateObj == null) {
            return null;
        }
        if (stateObj instanceof _AttachedListStateWrapper) {
            List<Object> lst = ((_AttachedListStateWrapper)stateObj).getWrappedStateList();
            ArrayList<Object> restoredList = new ArrayList<Object>(lst.size());
            for (Object item : lst) {
                restoredList.add(BehaviorBase.restoreAttachedState(context, item));
            }
            return restoredList;
        }
        if (stateObj instanceof _AttachedStateWrapper) {
            Object restoredObject;
            Class<?> clazz = ((_AttachedStateWrapper)stateObj).getClazz();
            try {
                restoredObject = clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Could not restore StateHolder of type " + clazz.getName() + " (missing no-args constructor?)", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (restoredObject instanceof StateHolder) {
                _AttachedStateWrapper wrapper = (_AttachedStateWrapper)stateObj;
                Object wrappedState = wrapper.getWrappedStateObject();
                StateHolder holder = (StateHolder)restoredObject;
                holder.restoreState(context, wrappedState);
            }
            return restoredObject;
        }
        return stateObj;
    }

    @Override
    public void setTransient(boolean newTransientValue) {
        this._transient = newTransientValue;
    }

    protected void addBehaviorListener(BehaviorListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this._behaviorListeners == null) {
            this._behaviorListeners = new _DeltaList(1);
        }
        this._behaviorListeners.add(listener);
    }

    protected void removeBehaviorListener(BehaviorListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this._behaviorListeners != null) {
            this._behaviorListeners.remove(listener);
        }
    }
}

