/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0045_muc.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Room;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.RoomType;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.storage.InMemoryOccupantStorageProvider;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.storage.InMemoryRoomStorageProvider;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.storage.OccupantStorageProvider;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.storage.RoomStorageProvider;
import org.apache.vysper.xmpp.modules.servicediscovery.management.Feature;
import org.apache.vysper.xmpp.modules.servicediscovery.management.Identity;
import org.apache.vysper.xmpp.modules.servicediscovery.management.InfoElement;
import org.apache.vysper.xmpp.modules.servicediscovery.management.InfoRequest;
import org.apache.vysper.xmpp.modules.servicediscovery.management.Item;
import org.apache.vysper.xmpp.modules.servicediscovery.management.ItemRequestListener;
import org.apache.vysper.xmpp.modules.servicediscovery.management.ServerInfoRequestListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Conference
implements ServerInfoRequestListener,
ItemRequestListener {
    private String name;
    private RoomStorageProvider roomStorageProvider = new InMemoryRoomStorageProvider();
    private OccupantStorageProvider occupantStorageProvider = new InMemoryOccupantStorageProvider();

    public Conference(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("Name must not be null or empty");
        }
        this.name = name;
    }

    public void initialize() {
        this.roomStorageProvider.initialize();
        if (this.occupantStorageProvider != null) {
            this.occupantStorageProvider.initialize();
        }
    }

    public Collection<Room> getAllRooms() {
        return this.roomStorageProvider.getAllRooms();
    }

    public Room createRoom(Entity jid, String name, RoomType ... types) {
        if (this.roomStorageProvider.roomExists(jid)) {
            throw new IllegalArgumentException("Room already exists with JID: " + jid);
        }
        return this.roomStorageProvider.createRoom(jid, name, types);
    }

    public void deleteRoom(Entity jid) {
        this.roomStorageProvider.deleteRoom(jid);
    }

    public Room findRoom(Entity jid) {
        return this.roomStorageProvider.findRoom(jid);
    }

    public Room findOrCreateRoom(Entity jid, String name, RoomType ... types) {
        Room room = this.findRoom(jid);
        if (room == null) {
            room = this.createRoom(jid, name, types);
        }
        return room;
    }

    public OccupantStorageProvider getOccupantStorageProvider() {
        return this.occupantStorageProvider;
    }

    public void setOccupantStorageProvider(OccupantStorageProvider occupantStorageProvider) {
        this.occupantStorageProvider = occupantStorageProvider;
    }

    public RoomStorageProvider getRoomStorageProvider() {
        return this.roomStorageProvider;
    }

    public void setRoomStorageProvider(RoomStorageProvider roomStorageProvider) {
        this.roomStorageProvider = roomStorageProvider;
    }

    public String getName() {
        return this.name;
    }

    public List<InfoElement> getServerInfosFor(InfoRequest request) {
        if (request.getNode() != null && request.getNode().length() > 0) {
            return null;
        }
        ArrayList<InfoElement> infoElements = new ArrayList<InfoElement>();
        infoElements.add((InfoElement)new Identity("conference", "text", this.getName()));
        infoElements.add((InfoElement)new Feature("http://jabber.org/protocol/muc"));
        return infoElements;
    }

    public List<Item> getItemsFor(InfoRequest request) {
        ArrayList<Item> items = new ArrayList<Item>();
        Collection<Room> rooms = this.getAllRooms();
        for (Room room : rooms) {
            items.add(new Item(room.getJID(), room.getName()));
        }
        return items;
    }
}

