/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.server.s2s;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.SRVRecord;
import org.xbill.DNS.TextParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmppEndpointResolver {
    private static final int SERVER_PORT = 5269;

    public List<ResolvedAddress> resolveXmppServer(String domain) {
        ArrayList<ResolvedAddress> addresses = new ArrayList<ResolvedAddress>();
        try {
            Record[] records = new Lookup("_xmpp-server._tcp." + domain, 33).run();
            if (records != null) {
                for (int i = 0; i < records.length; ++i) {
                    SRVRecord srv = (SRVRecord)records[i];
                    addresses.add(new ResolvedAddress(srv.getTarget(), srv.getPort(), srv.getPriority()));
                }
                Collections.sort(addresses, new Comparator<ResolvedAddress>(){

                    @Override
                    public int compare(ResolvedAddress a1, ResolvedAddress a2) {
                        return a1.getPriority() - a2.getPriority();
                    }
                });
            } else {
                addresses.add(new ResolvedAddress(domain, 5269, 0));
            }
        }
        catch (TextParseException textParseException) {
            // empty catch block
        }
        return addresses;
    }

    public static class ResolvedAddress {
        private InetSocketAddress address;
        private int priority;

        public ResolvedAddress(Name name, int port, int priority) {
            this(name.toString(), port, priority);
        }

        public ResolvedAddress(String name, int port, int priority) {
            this.address = new InetSocketAddress(name, port);
            this.priority = priority;
        }

        public InetSocketAddress getAddress() {
            return this.address;
        }

        public int getPriority() {
            return this.priority;
        }

        public String toString() {
            return "[address=" + this.address + ", priority=" + this.priority + "]";
        }
    }
}

