/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.servicediscovery.handler;

import java.util.List;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.modules.core.base.handler.DefaultIQHandler;
import org.apache.vysper.xmpp.modules.servicediscovery.collection.ServiceCollector;
import org.apache.vysper.xmpp.modules.servicediscovery.management.InfoElement;
import org.apache.vysper.xmpp.modules.servicediscovery.management.InfoRequest;
import org.apache.vysper.xmpp.modules.servicediscovery.management.ServiceDiscoveryRequestException;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.response.ServerErrorResponses;
import org.apache.vysper.xmpp.stanza.IQStanza;
import org.apache.vysper.xmpp.stanza.IQStanzaType;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.apache.vysper.xmpp.stanza.StanzaErrorCondition;
import org.apache.vysper.xmpp.stanza.StanzaErrorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoInfoIQHandler
extends DefaultIQHandler {
    final Logger logger = LoggerFactory.getLogger(DiscoInfoIQHandler.class);

    protected boolean verifyNamespace(Stanza stanza) {
        return this.verifyInnerNamespace(stanza, "http://jabber.org/protocol/disco#info");
    }

    protected boolean verifyInnerElement(Stanza stanza) {
        return this.verifyInnerElementWorker(stanza, "query");
    }

    protected Stanza handleGet(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext) {
        ServiceCollector serviceCollector = null;
        try {
            serviceCollector = (ServiceCollector)serverRuntimeContext.getServerRuntimeContextService("discoRequestListenerRegistry");
        }
        catch (Exception e) {
            this.logger.error("error retrieving ServiceCollector service {}", (Throwable)e);
            serviceCollector = null;
        }
        if (serviceCollector == null) {
            return ServerErrorResponses.getStanzaError(StanzaErrorCondition.INTERNAL_SERVER_ERROR, stanza, StanzaErrorType.CANCEL, "cannot retrieve IQ-get-info result from internal components", this.getErrorLanguage(serverRuntimeContext, sessionContext), null);
        }
        Entity to = stanza.getTo();
        boolean isServerInfoRequest = false;
        boolean isComponentInfoRequest = false;
        Entity serviceEntity = serverRuntimeContext.getServerEnitity();
        if (to == null || to.equals(serviceEntity)) {
            isServerInfoRequest = true;
        } else if (serverRuntimeContext.getComponentStanzaProcessor(to) != null) {
            isComponentInfoRequest = true;
        } else if (!to.isNodeSet() && !(isServerInfoRequest = serviceEntity.equals(to))) {
            return ServerErrorResponses.getStanzaError(StanzaErrorCondition.ITEM_NOT_FOUND, stanza, StanzaErrorType.CANCEL, "server does not handle info query requests for " + to.getFullQualifiedName(), this.getErrorLanguage(serverRuntimeContext, sessionContext), null);
        }
        XMLElement queryElement = stanza.getFirstInnerElement();
        String node = queryElement != null ? queryElement.getAttributeValue("node") : null;
        List<InfoElement> elements = null;
        try {
            Entity from = stanza.getFrom();
            if (from == null) {
                from = sessionContext.getInitiatingEntity();
            }
            elements = isServerInfoRequest ? serviceCollector.processServerInfoRequest(new InfoRequest(from, to, node, stanza.getID())) : (isComponentInfoRequest ? serviceCollector.processComponentInfoRequest(new InfoRequest(from, to, node, stanza.getID())) : serviceCollector.processInfoRequest(new InfoRequest(from, to, node, stanza.getID())));
        }
        catch (ServiceDiscoveryRequestException e) {
            StanzaErrorCondition stanzaErrorCondition = e.getErrorCondition();
            if (stanzaErrorCondition == null) {
                stanzaErrorCondition = StanzaErrorCondition.INTERNAL_SERVER_ERROR;
            }
            return ServerErrorResponses.getStanzaError(stanzaErrorCondition, stanza, StanzaErrorType.CANCEL, "disco info request failed.", this.getErrorLanguage(serverRuntimeContext, sessionContext), null);
        }
        StanzaBuilder stanzaBuilder = (StanzaBuilder)StanzaBuilder.createIQStanza(to, stanza.getFrom(), IQStanzaType.RESULT, stanza.getID()).startInnerElement("query", "http://jabber.org/protocol/disco#info");
        if (node != null) {
            stanzaBuilder.addAttribute("node", node);
        }
        for (InfoElement infoElement : elements) {
            infoElement.insertElement(stanzaBuilder);
        }
        stanzaBuilder.endInnerElement();
        return (Stanza)stanzaBuilder.build();
    }
}

