/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.File;
import java.io.IOException;
import org.springframework.util.FileCopyUtils;

public abstract class FileSystemUtils {
    public static boolean deleteRecursively(File root) {
        if (root.exists()) {
            if (root.isDirectory()) {
                File[] children = root.listFiles();
                for (int i = 0; i < children.length; ++i) {
                    FileSystemUtils.deleteRecursively(children[i]);
                }
            }
            return root.delete();
        }
        return false;
    }

    public static void copyRecursively(File src, File dest) throws IOException {
        dest.mkdir();
        File[] entries = src.listFiles();
        for (int i = 0; i < entries.length; ++i) {
            File file = entries[i];
            File newFile = new File(dest, file.getName());
            if (file.isFile()) {
                newFile.createNewFile();
                FileCopyUtils.copy(file, newFile);
                continue;
            }
            FileSystemUtils.copyRecursively(file, newFile);
        }
    }
}

