/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.content.loremipsum;

import java.io.IOException;
import java.io.StringWriter;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LoremIpsum {
    private static final String[] DELIMITERS_SENTENCES = new String[]{".", "?", "!"};
    private static final String SENTENCE_SPLIT_REGEX = "[\\.\\?\\!]";
    private static final String[] DELIMITERS_WORDS = new String[]{".", ",", "?", "!"};
    private static final String WORD_SPLIT_REGEX = "\\s";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private Map<Integer, List<String>> words;
    private Map<WordLengthPair, List<WordInfo>> chains;
    private List<WordLengthPair> starts;
    private double sentenceMean;
    private double sentenceSigma;
    private double paragraphMean;
    private double paragraphSigma;
    private String sample = "Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim. Aliquam lorem ante, dapibus in, viverra quis, feugiat a, tellus. Phasellus viverra nulla ut metus Objectius laoreet. Quisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui.\n\nEtiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum. Nam quam nunc, blandit vel, luctus pulvinar, hendrerit id, lorem. Maecenas nec odio et ante tincidunt tempus. Donec vitae sapien ut libero venenatis faucibus. Nullam quis ante. Etiam sit amet orci eget eros faucibus tincidunt. Duis leo. Sed fringilla mauris sit amet nibh. Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc, quis gravida magna mi a libero. Fusce vulputate eleifend sapien. Vestibulum purus quam, scelerisque ut, mollis sed, nonummy id, metus. Nullam accumsan lorem in dui. Cras ultricies mi eu turpis hendrerit fringilla. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; In ac dui quis mi consectetuer lacinia.\n\nNam pretium turpis et arcu. Duis arcu tortor, suscipit eget, imperdiet nec, imperdiet iaculis, ipsum. Sed aliquam ultrices mauris. Integer ante arcu, accumsan a, consectetuer eget, posuere ut, mauris. Praesent adipiscing. Phasellus ullamcorper ipsum rutrum nunc. Nunc nonummy metus. Vestibulum volutpat pretium libero. Cras id dui. Aenean ut eros et nisl sagittis vestibulum. Nullam nulla eros, ultricies sit amet, nonummy id, imperdiet feugiat, pede. Sed lectus. Donec mollis hendrerit risus. Phasellus nec sem in justo pellentesque facilisis. Etiam imperdiet imperdiet orci. Nunc nec neque. Phasellus leo dolor, tempus non, auctor et, hendrerit quis, nisi.\n\nCurabitur ligula sapien, tincidunt non, euismod vitae, posuere imperdiet, leo. Maecenas malesuada. Praesent congue erat at massa. Sed cursus turpis vitae tortor. Donec posuere vulputate arcu. Phasellus accumsan cursus velit. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Sed aliquam, nisi quis porttitor congue, elit erat euismod orci, ac placerat dolor lectus quis orci. Phasellus consectetuer vestibulum elit. Aenean tellus metus, bibendum sed, posuere ac, mattis non, nunc. Vestibulum fringilla pede sit amet augue. In turpis. Pellentesque posuere. Praesent turpis.\n\nAenean posuere, tortor sed cursus feugiat, nunc augue blandit nunc, eu sollicitudin urna dolor sagittis lacus. Donec elit libero, sodales nec, volutpat a, suscipit non, turpis. Nullam sagittis. Suspendisse pulvinar, augue ac venenatis condimentum, sem libero volutpat nibh, nec pellentesque velit pede quis nunc. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Fusce id purus. Ut Objectius tincidunt libero. Phasellus dolor. Maecenas vestibulum mollis diam. Pellentesque ut neque. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.\n\nIn dui magna, posuere eget, vestibulum et, tempor auctor, justo. In ac felis quis tortor malesuada pretium. Pellentesque auctor neque nec urna. Proin sapien ipsum, porta a, auctor quis, euismod ut, mi. Aenean viverra rhoncus pede. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Ut non enim eleifend felis pretium feugiat. Vivamus quis mi. Phasellus a est. Phasellus magna.\n\nIn hac habitasse platea dictumst. Curabitur at lacus ac velit ornare lobortis. Curabitur a felis in nunc fringilla tristique. Morbi mattis ullamcorper velit. Phasellus gravida semper nisi. Nullam vel sem. Pellentesque libero tortor, tincidunt et, tincidunt eget, semper nec, quam. Sed hendrerit. Morbi ac felis. Nunc egestas, augue at pellentesque laoreet, felis eros vehicula leo, at malesuada velit leo quis pede. Donec interdum, metus et hendrerit aliquet, dolor diam sagittis ligula, eget egestas libero turpis vel mi. Nunc nulla. Fusce risus nisl, viverra et, tempor et, pretium in, sapien. Donec venenatis vulputate lorem.\n\nMorbi nec metus. Phasellus blandit leo ut odio. Maecenas ullamcorper, dui et placerat feugiat, eros pede Objectius nisi, condimentum viverra felis nunc et lorem. Sed magna purus, fermentum eu, tincidunt eu, Objectius ut, felis. In auctor lobortis lacus. Quisque libero metus, condimentum nec, tempor a, commodo mollis, magna. Vestibulum ullamcorper mauris at ligula. Fusce fermentum. Nullam cursus lacinia erat. Praesent blandit laoreet nibh.\n\nFusce convallis metus id felis luctus adipiscing. Pellentesque egestas, neque sit amet convallis pulvinar, justo nulla eleifend augue, ac auctor orci leo non est. Quisque id mi. Ut tincidunt tincidunt erat. Etiam feugiat lorem non metus. Vestibulum dapibus nunc ac augue. Curabitur vestibulum aliquam leo. Praesent egestas neque eu enim. In hac habitasse platea dictumst. Fusce a quam. Etiam ut purus mattis mauris sodales aliquam. Curabitur nisi. Quisque malesuada placerat nisl. Nam ipsum risus, rutrum vitae, vestibulum eu, molestie vel, lacus.\n\nSed augue ipsum, egestas nec, vestibulum et, malesuada adipiscing, dui. Vestibulum facilisis, purus nec pulvinar iaculis, ligula mi congue nunc, vitae euismod ligula urna in dolor. Mauris sollicitudin fermentum libero. Praesent nonummy mi in odio. Nunc interdum lacus sit amet orci. Vestibulum rutrum, mi nec elementum vehicula, eros quam gravida nisl, id fringilla neque ante vel mi. Morbi mollis tellus ac sapien. Phasellus volutpat, metus eget egestas mollis, lacus lacus blandit dui, id egestas quam mauris ut lacus. Fusce vel dui. Sed in libero ut nibh placerat accumsan. Proin faucibus arcu quis ante. In consectetuer turpis ut velit. Nulla sit amet est. Praesent metus tellus, elementum eu, semper a, adipiscing nec, purus. Cras risus ipsum, faucibus ut, ullamcorper id, Objectius ac, leo. Suspendisse feugiat. Suspendisse enim turpis, dictum sed, iaculis a, condimentum nec, nisi. Praesent nec nisl a purus blandit viverra. Praesent ac massa at ligula laoreet iaculis. Nulla neque dolor, sagittis eget, iaculis quis, molestie non, velit.\n\nMauris turpis nunc, blandit et, volutpat molestie, porta ut, ligula. Fusce pharetra convallis urna. Quisque ut nisi. Donec mi odio, faucibus at, scelerisque quis, convallis in, nisi. Suspendisse non nisl sit amet velit hendrerit rutrum. Ut leo. Ut a nisl id ante tempus hendrerit. Proin pretium, leo ac pellentesque mollis, felis nunc ultrices eros, sed gravida augue augue mollis justo. Suspendisse eu ligula. Nulla facilisi. Donec id justo. Praesent porttitor, nulla vitae posuere iaculis, arcu nisl dignissim dolor, a pretium mi sem ut ipsum. Curabitur suscipit suscipit tellus.\n\nPraesent vestibulum dapibus nibh. Etiam iaculis nunc ac metus. Ut id nisl quis enim dignissim sagittis. Etiam sollicitudin, ipsum eu pulvinar rutrum, tellus ipsum laoreet sapien, quis venenatis ante odio sit amet eros. Proin magna. Duis vel nibh at velit scelerisque suscipit. Curabitur turpis. Vestibulum suscipit nulla quis orci. Fusce ac felis sit amet ligula pharetra condimentum. Maecenas egestas arcu quis ligula mattis placerat. Duis lobortis massa imperdiet quam. Suspendisse potenti.\n\nPellentesque commodo eros a enim. Vestibulum turpis sem, aliquet eget, lobortis pellentesque, rutrum eu, nisl. Sed libero. Aliquam erat volutpat. Etiam vitae tortor. Morbi vestibulum volutpat enim. Aliquam eu nunc. Nunc sed turpis. Sed mollis, eros et ultrices tempus, mauris ipsum aliquam libero, non adipiscing dolor urna a orci. Nulla porta dolor. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos.\n\nPellentesque dapibus hendrerit tortor. Praesent egestas tristique nibh. Sed a libero. Cras Objectius. Donec vitae orci sed dolor rutrum auctor. Fusce egestas elit eget lorem. Suspendisse nisl elit, rhoncus eget, elementum ac, condimentum eget, diam. Nam at tortor in tellus interdum sagittis. Aliquam lobortis. Donec orci lectus, aliquam ut, faucibus non, euismod id, nulla. Curabitur blandit mollis lacus. Nam adipiscing. Vestibulum eu odio.\n\nVivamus laoreet. Nullam tincidunt adipiscing enim. Phasellus tempus. Proin viverra, ligula sit amet ultrices semper, ligula arcu tristique sapien, a accumsan nisi mauris ac eros. Fusce neque. Suspendisse faucibus, nunc et pellentesque egestas, lacus ante convallis tellus, vitae iaculis lacus elit id tortor. Vivamus aliquet elit ac nisl. Fusce fermentum odio nec arcu. Vivamus euismod mauris. In ut quam vitae odio lacinia tincidunt. Praesent ut ligula non mi Objectius sagittis. Cras sagittis. Praesent ac sem eget est egestas volutpat. Vivamus consectetuer hendrerit lacus. Cras non dolor. Vivamus in erat ut urna cursus vestibulum. Fusce commodo aliquam arcu. Nam commodo suscipit quam. Quisque id odio. Praesent venenatis metus at tortor pulvinar varius.\n\n";
    private String dictionary = "a ac accumsan ad adipiscing aenean aliquam aliquet amet ante aptent arcu at auctor augue bibendum blandit class commodo condimentum congue consectetuer consequat conubia convallis cras cubilia cum curabitur curae cursus dapibus diam dictum dictumst dignissim dis dolor donec dui duis egestas eget eleifend elementum elit eni enim erat eros est et etiam eu euismod facilisi facilisis fames faucibus felis fermentum feugiat fringilla fusce gravida habitant habitasse hac hendrerit hymenaeos iaculis id imperdiet in inceptos integer interdum ipsum justo lacinia lacus laoreet lectus leo libero ligula litora lobortis lorem luctus maecenas magna magnis malesuada massa mattis mauris metus mi molestie mollis montes morbi mus nam nascetur natoque nec neque netus nibh nisi nisl non nonummy nostra nulla nullam nunc odio orci ornare parturient pede pellentesque penatibus per pharetra phasellus placerat platea porta porttitor posuere potenti praesent pretium primis proin pulvinar purus quam quis quisque rhoncus ridiculus risus rutrum sagittis sapien scelerisque sed sem semper senectus sit sociis sociosqu sodales sollicitudin suscipit suspendisse taciti tellus tempor tempus tincidunt torquent tortor tristique turpis ullamcorper ultrices ultricies urna ut Objectius ve vehicula vel velit venenatis vestibulum vitae vivamus viverra volutpat vulputate";
    private SecureRandom randomGenerator = new SecureRandom();
    private static final double NV_MAGICCONST_ = 4.0 * Math.exp(-0.5) / Math.sqrt(2.0);
    private static final String DICT = "a ac accumsan ad adipiscing aenean aliquam aliquet amet ante aptent arcu at auctor augue bibendum blandit class commodo condimentum congue consectetuer consequat conubia convallis cras cubilia cum curabitur curae cursus dapibus diam dictum dictumst dignissim dis dolor donec dui duis egestas eget eleifend elementum elit eni enim erat eros est et etiam eu euismod facilisi facilisis fames faucibus felis fermentum feugiat fringilla fusce gravida habitant habitasse hac hendrerit hymenaeos iaculis id imperdiet in inceptos integer interdum ipsum justo lacinia lacus laoreet lectus leo libero ligula litora lobortis lorem luctus maecenas magna magnis malesuada massa mattis mauris metus mi molestie mollis montes morbi mus nam nascetur natoque nec neque netus nibh nisi nisl non nonummy nostra nulla nullam nunc odio orci ornare parturient pede pellentesque penatibus per pharetra phasellus placerat platea porta porttitor posuere potenti praesent pretium primis proin pulvinar purus quam quis quisque rhoncus ridiculus risus rutrum sagittis sapien scelerisque sed sem semper senectus sit sociis sociosqu sodales sollicitudin suscipit suspendisse taciti tellus tempor tempus tincidunt torquent tortor tristique turpis ullamcorper ultrices ultricies urna ut Objectius ve vehicula vel velit venenatis vestibulum vitae vivamus viverra volutpat vulputate";
    private static final String SAMPLE = "Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim. Aliquam lorem ante, dapibus in, viverra quis, feugiat a, tellus. Phasellus viverra nulla ut metus Objectius laoreet. Quisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui.\n\nEtiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum. Nam quam nunc, blandit vel, luctus pulvinar, hendrerit id, lorem. Maecenas nec odio et ante tincidunt tempus. Donec vitae sapien ut libero venenatis faucibus. Nullam quis ante. Etiam sit amet orci eget eros faucibus tincidunt. Duis leo. Sed fringilla mauris sit amet nibh. Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc, quis gravida magna mi a libero. Fusce vulputate eleifend sapien. Vestibulum purus quam, scelerisque ut, mollis sed, nonummy id, metus. Nullam accumsan lorem in dui. Cras ultricies mi eu turpis hendrerit fringilla. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; In ac dui quis mi consectetuer lacinia.\n\nNam pretium turpis et arcu. Duis arcu tortor, suscipit eget, imperdiet nec, imperdiet iaculis, ipsum. Sed aliquam ultrices mauris. Integer ante arcu, accumsan a, consectetuer eget, posuere ut, mauris. Praesent adipiscing. Phasellus ullamcorper ipsum rutrum nunc. Nunc nonummy metus. Vestibulum volutpat pretium libero. Cras id dui. Aenean ut eros et nisl sagittis vestibulum. Nullam nulla eros, ultricies sit amet, nonummy id, imperdiet feugiat, pede. Sed lectus. Donec mollis hendrerit risus. Phasellus nec sem in justo pellentesque facilisis. Etiam imperdiet imperdiet orci. Nunc nec neque. Phasellus leo dolor, tempus non, auctor et, hendrerit quis, nisi.\n\nCurabitur ligula sapien, tincidunt non, euismod vitae, posuere imperdiet, leo. Maecenas malesuada. Praesent congue erat at massa. Sed cursus turpis vitae tortor. Donec posuere vulputate arcu. Phasellus accumsan cursus velit. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Sed aliquam, nisi quis porttitor congue, elit erat euismod orci, ac placerat dolor lectus quis orci. Phasellus consectetuer vestibulum elit. Aenean tellus metus, bibendum sed, posuere ac, mattis non, nunc. Vestibulum fringilla pede sit amet augue. In turpis. Pellentesque posuere. Praesent turpis.\n\nAenean posuere, tortor sed cursus feugiat, nunc augue blandit nunc, eu sollicitudin urna dolor sagittis lacus. Donec elit libero, sodales nec, volutpat a, suscipit non, turpis. Nullam sagittis. Suspendisse pulvinar, augue ac venenatis condimentum, sem libero volutpat nibh, nec pellentesque velit pede quis nunc. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Fusce id purus. Ut Objectius tincidunt libero. Phasellus dolor. Maecenas vestibulum mollis diam. Pellentesque ut neque. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.\n\nIn dui magna, posuere eget, vestibulum et, tempor auctor, justo. In ac felis quis tortor malesuada pretium. Pellentesque auctor neque nec urna. Proin sapien ipsum, porta a, auctor quis, euismod ut, mi. Aenean viverra rhoncus pede. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Ut non enim eleifend felis pretium feugiat. Vivamus quis mi. Phasellus a est. Phasellus magna.\n\nIn hac habitasse platea dictumst. Curabitur at lacus ac velit ornare lobortis. Curabitur a felis in nunc fringilla tristique. Morbi mattis ullamcorper velit. Phasellus gravida semper nisi. Nullam vel sem. Pellentesque libero tortor, tincidunt et, tincidunt eget, semper nec, quam. Sed hendrerit. Morbi ac felis. Nunc egestas, augue at pellentesque laoreet, felis eros vehicula leo, at malesuada velit leo quis pede. Donec interdum, metus et hendrerit aliquet, dolor diam sagittis ligula, eget egestas libero turpis vel mi. Nunc nulla. Fusce risus nisl, viverra et, tempor et, pretium in, sapien. Donec venenatis vulputate lorem.\n\nMorbi nec metus. Phasellus blandit leo ut odio. Maecenas ullamcorper, dui et placerat feugiat, eros pede Objectius nisi, condimentum viverra felis nunc et lorem. Sed magna purus, fermentum eu, tincidunt eu, Objectius ut, felis. In auctor lobortis lacus. Quisque libero metus, condimentum nec, tempor a, commodo mollis, magna. Vestibulum ullamcorper mauris at ligula. Fusce fermentum. Nullam cursus lacinia erat. Praesent blandit laoreet nibh.\n\nFusce convallis metus id felis luctus adipiscing. Pellentesque egestas, neque sit amet convallis pulvinar, justo nulla eleifend augue, ac auctor orci leo non est. Quisque id mi. Ut tincidunt tincidunt erat. Etiam feugiat lorem non metus. Vestibulum dapibus nunc ac augue. Curabitur vestibulum aliquam leo. Praesent egestas neque eu enim. In hac habitasse platea dictumst. Fusce a quam. Etiam ut purus mattis mauris sodales aliquam. Curabitur nisi. Quisque malesuada placerat nisl. Nam ipsum risus, rutrum vitae, vestibulum eu, molestie vel, lacus.\n\nSed augue ipsum, egestas nec, vestibulum et, malesuada adipiscing, dui. Vestibulum facilisis, purus nec pulvinar iaculis, ligula mi congue nunc, vitae euismod ligula urna in dolor. Mauris sollicitudin fermentum libero. Praesent nonummy mi in odio. Nunc interdum lacus sit amet orci. Vestibulum rutrum, mi nec elementum vehicula, eros quam gravida nisl, id fringilla neque ante vel mi. Morbi mollis tellus ac sapien. Phasellus volutpat, metus eget egestas mollis, lacus lacus blandit dui, id egestas quam mauris ut lacus. Fusce vel dui. Sed in libero ut nibh placerat accumsan. Proin faucibus arcu quis ante. In consectetuer turpis ut velit. Nulla sit amet est. Praesent metus tellus, elementum eu, semper a, adipiscing nec, purus. Cras risus ipsum, faucibus ut, ullamcorper id, Objectius ac, leo. Suspendisse feugiat. Suspendisse enim turpis, dictum sed, iaculis a, condimentum nec, nisi. Praesent nec nisl a purus blandit viverra. Praesent ac massa at ligula laoreet iaculis. Nulla neque dolor, sagittis eget, iaculis quis, molestie non, velit.\n\nMauris turpis nunc, blandit et, volutpat molestie, porta ut, ligula. Fusce pharetra convallis urna. Quisque ut nisi. Donec mi odio, faucibus at, scelerisque quis, convallis in, nisi. Suspendisse non nisl sit amet velit hendrerit rutrum. Ut leo. Ut a nisl id ante tempus hendrerit. Proin pretium, leo ac pellentesque mollis, felis nunc ultrices eros, sed gravida augue augue mollis justo. Suspendisse eu ligula. Nulla facilisi. Donec id justo. Praesent porttitor, nulla vitae posuere iaculis, arcu nisl dignissim dolor, a pretium mi sem ut ipsum. Curabitur suscipit suscipit tellus.\n\nPraesent vestibulum dapibus nibh. Etiam iaculis nunc ac metus. Ut id nisl quis enim dignissim sagittis. Etiam sollicitudin, ipsum eu pulvinar rutrum, tellus ipsum laoreet sapien, quis venenatis ante odio sit amet eros. Proin magna. Duis vel nibh at velit scelerisque suscipit. Curabitur turpis. Vestibulum suscipit nulla quis orci. Fusce ac felis sit amet ligula pharetra condimentum. Maecenas egestas arcu quis ligula mattis placerat. Duis lobortis massa imperdiet quam. Suspendisse potenti.\n\nPellentesque commodo eros a enim. Vestibulum turpis sem, aliquet eget, lobortis pellentesque, rutrum eu, nisl. Sed libero. Aliquam erat volutpat. Etiam vitae tortor. Morbi vestibulum volutpat enim. Aliquam eu nunc. Nunc sed turpis. Sed mollis, eros et ultrices tempus, mauris ipsum aliquam libero, non adipiscing dolor urna a orci. Nulla porta dolor. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos.\n\nPellentesque dapibus hendrerit tortor. Praesent egestas tristique nibh. Sed a libero. Cras Objectius. Donec vitae orci sed dolor rutrum auctor. Fusce egestas elit eget lorem. Suspendisse nisl elit, rhoncus eget, elementum ac, condimentum eget, diam. Nam at tortor in tellus interdum sagittis. Aliquam lobortis. Donec orci lectus, aliquam ut, faucibus non, euismod id, nulla. Curabitur blandit mollis lacus. Nam adipiscing. Vestibulum eu odio.\n\nVivamus laoreet. Nullam tincidunt adipiscing enim. Phasellus tempus. Proin viverra, ligula sit amet ultrices semper, ligula arcu tristique sapien, a accumsan nisi mauris ac eros. Fusce neque. Suspendisse faucibus, nunc et pellentesque egestas, lacus ante convallis tellus, vitae iaculis lacus elit id tortor. Vivamus aliquet elit ac nisl. Fusce fermentum odio nec arcu. Vivamus euismod mauris. In ut quam vitae odio lacinia tincidunt. Praesent ut ligula non mi Objectius sagittis. Cras sagittis. Praesent ac sem eget est egestas volutpat. Vivamus consectetuer hendrerit lacus. Cras non dolor. Vivamus in erat ut urna cursus vestibulum. Fusce commodo aliquam arcu. Nam commodo suscipit quam. Quisque id odio. Praesent venenatis metus at tortor pulvinar varius.\n\n";

    private WordInfo randomChoice(WordInfo[] array) {
        return array[this.randomInt(array.length)];
    }

    private String randomChoice(String[] array) {
        return array[this.randomInt(array.length)];
    }

    private int randomInt(int length) {
        return this.randomGenerator.nextInt(length);
    }

    public LoremIpsum() {
        this.generateChains(this.sample);
        this.generateStatistics(this.sample);
        this.initializeDictionary(this.dictionary);
    }

    public LoremIpsum(String sample, String dictionary) {
        this.sample = sample;
        this.dictionary = dictionary;
        this.generateChains(this.sample);
        this.generateStatistics(this.sample);
        this.initializeDictionary(this.dictionary);
    }

    public LoremIpsum(String sample, String[] newDictionary) {
        this.sample = sample;
        this.dictionary = null;
        this.generateChains(this.sample);
        this.generateStatistics(this.sample);
        this.initializeDictionary(newDictionary);
    }

    public LoremIpsum(String sample) {
        this.sample = sample;
        Object[] dictWords = LoremIpsum.filterNotEmptyOrWhiteSpace(sample.split("[^\\p{L}]")).toArray(new String[0]);
        HashSet<String> dict = new HashSet<String>(Arrays.asList(dictWords));
        dictWords = dict.toArray(new String[0]);
        Arrays.sort(dictWords);
        this.generateChains(this.sample);
        this.generateStatistics(this.sample);
        this.initializeDictionary((String[])dictWords);
    }

    public String generateParagraph(boolean optStartWithLorem) {
        Double paragraphLengthDbl = LoremIpsum.randomNormal(this.paragraphMean, this.paragraphSigma);
        int paragraphLength = Math.max((int)Math.floor(paragraphLengthDbl), 1);
        ArrayList<String> paragraph = new ArrayList<String>();
        boolean startWithLorem = optStartWithLorem;
        while (paragraph.size() < paragraphLength) {
            String sentence = this.generateSentence(startWithLorem);
            paragraph.add(sentence);
            startWithLorem = false;
        }
        StringBuffer result = new StringBuffer();
        for (String sentence : paragraph) {
            result.append(sentence);
            result.append(" ");
        }
        return result.toString();
    }

    public String generateSentence(boolean optStartWithLorem) {
        ArrayList<Object> sentence;
        if (this.chains.size() == 0 || this.starts.size() == 0) {
            throw new RuntimeException("No chains created (Invalid sample text?)");
        }
        if (this.words.size() == 0) {
            throw new RuntimeException("No dictionary");
        }
        double sentenceLengthDbl = LoremIpsum.randomNormal(this.sentenceMean, this.sentenceSigma);
        int sentenceLength = Math.max((int)Math.floor(sentenceLengthDbl), 1);
        String wordDelimiter = "";
        if (optStartWithLorem) {
            String lastWord;
            String lastChar;
            String lorem = "lorem ipsum dolor sit amet, consecteteur adipiscing elit";
            sentence = new ArrayList<String>(Arrays.asList(LoremIpsum.splitWords(lorem)));
            if (sentence.size() > sentenceLength) {
                sentence.subList(0, sentenceLength);
            }
            if (LoremIpsum.contains(DELIMITERS_WORDS, lastChar = (lastWord = (String)sentence.get(sentence.size() - 1)).substring(lastWord.length() - 1))) {
                wordDelimiter = lastChar;
            }
        } else {
            sentence = new ArrayList();
        }
        WordLengthPair previous = new WordLengthPair(0, 0);
        while (sentence.size() < sentenceLength) {
            if (!this.chains.containsKey(previous)) {
                previous = this.chooseRandomStart_();
            }
            WordInfo chain = this.randomChoice(this.chains.get(previous).toArray(new WordInfo[0]));
            int wordLength = chain.len;
            wordDelimiter = LoremIpsum.contains(DELIMITERS_SENTENCES, chain.delim) ? "" : chain.delim;
            int n = LoremIpsum.chooseClosest(this.words.keySet().toArray(new Integer[0]), wordLength);
            String word = this.randomChoice(this.words.get(n).toArray(new String[0]));
            sentence.add(word + wordDelimiter);
            previous = new WordLengthPair(previous.len2, wordLength);
        }
        StringBuffer result = new StringBuffer();
        for (String string : sentence) {
            result.append(string);
            result.append(" ");
        }
        result.deleteCharAt(result.length() - 1);
        result.replace(0, 1, result.substring(0, 1).toUpperCase());
        int strLen = result.length() - 1;
        if (wordDelimiter.length() > 0 && wordDelimiter.charAt(0) == result.charAt(strLen)) {
            result.deleteCharAt(strLen);
        }
        result.append(".");
        return result.toString();
    }

    public String getSample() {
        return this.sample;
    }

    public void setSample(String sample) {
        this.sample = sample;
        this.generateChains(this.sample);
        this.generateStatistics(this.sample);
    }

    public String getDictionary() {
        return this.dictionary;
    }

    public void setDictionary(String dictionary) {
        this.dictionary = dictionary;
        this.initializeDictionary(this.dictionary);
    }

    private String generateMarkupParagraphs(String begin, String end, String between, int quantity, boolean startWithLorem) {
        StringBuffer text = new StringBuffer();
        text.append(begin);
        String para = this.generateParagraph(startWithLorem);
        text.append(para);
        while (text.length() < quantity) {
            para = this.generateParagraph(false);
            text.append(para);
            if (text.length() >= quantity) continue;
            text.append(between);
        }
        text.append(end);
        return text.toString();
    }

    private void generateMarkupParagraphs(Appendable writer, String begin, String end, String between, int quantity, boolean startWithLorem) throws IOException {
        int len = begin.length();
        writer.append(begin);
        String para = this.generateParagraph(startWithLorem);
        len += para.length();
        writer.append(para);
        while (len < quantity) {
            para = this.generateParagraph(false);
            writer.append(para);
            if ((len += para.length()) >= quantity) continue;
            writer.append(between);
            len += para.length();
        }
        writer.append(end);
    }

    private String generateMarkupSentences(String begin, String end, String between, int quantity, boolean startWithLorem) {
        StringBuffer text = new StringBuffer();
        text.append(begin);
        String sentence = this.generateSentence(startWithLorem);
        text.append(sentence);
        while (text.length() < quantity) {
            sentence = this.generateSentence(false);
            text.append(sentence);
            if (text.length() >= quantity) continue;
            text.append(between);
        }
        text.append(end);
        return text.toString();
    }

    private void generateChains(String sample) {
        String[] words = LoremIpsum.splitWords(sample);
        WordInfo[] wordInfos = LoremIpsum.generateWordInfo(words);
        WordLengthPair previous = new WordLengthPair(0, 0);
        ArrayList<WordLengthPair> starts = new ArrayList<WordLengthPair>();
        List<String> delimList = Arrays.asList(DELIMITERS_SENTENCES);
        HashMap<WordLengthPair, List<WordInfo>> chains = new HashMap<WordLengthPair, List<WordInfo>>();
        for (WordInfo wi : wordInfos) {
            if (wi.len == 0) continue;
            List value = (List)chains.get(previous);
            if (null == value) {
                chains.put(previous, new ArrayList());
            } else {
                ((List)chains.get(previous)).add(wi);
            }
            if (delimList.contains(wi.delim)) {
                starts.add(previous);
            }
            previous.len1 = previous.len2;
            previous.len2 = wi.len;
        }
        if (chains.isEmpty()) {
            throw new RuntimeException("Invalid sample text.");
        }
        this.chains = chains;
        this.starts = starts;
    }

    private void generateStatistics(String sample) {
        this.generateSentenceStatistics(sample);
        this.generateParagraphStatistics(sample);
    }

    private void generateSentenceStatistics(String sample) {
        List<String> sentences = LoremIpsum.filterNotEmptyOrWhiteSpace(LoremIpsum.splitSentences(sample));
        int[] sentenceLengths = new int[sentences.size()];
        for (int i = 0; i < sentences.size(); ++i) {
            String[] words = LoremIpsum.splitWords(sentences.get(i));
            sentenceLengths[i] = words.length;
        }
        this.sentenceMean = LoremIpsum.mean(sentenceLengths);
        this.sentenceSigma = LoremIpsum.sigma(sentenceLengths);
    }

    private void generateParagraphStatistics(String sample) {
        List<String> paragraphs = LoremIpsum.filterNotEmptyOrWhiteSpace(LoremIpsum.splitParagraphs(sample));
        int[] paragraphLengths = new int[paragraphs.size()];
        for (int i = 0; i < paragraphs.size(); ++i) {
            String[] sentences = LoremIpsum.splitSentences(paragraphs.get(i));
            paragraphLengths[i] = sentences.length;
        }
        this.paragraphMean = LoremIpsum.mean(paragraphLengths);
        this.paragraphSigma = LoremIpsum.sigma(paragraphLengths);
    }

    private void initializeDictionary(String dictionary) {
        String[] dictionaryWords = LoremIpsum.splitWords(dictionary);
        this.initializeDictionary(dictionaryWords);
    }

    private void initializeDictionary(String[] dictionaryWords) {
        this.words = new HashMap<Integer, List<String>>();
        for (String word : dictionaryWords) {
            List<String> wordWithLen = this.words.get(word.length());
            if (null == wordWithLen) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(word);
                this.words.put(word.length(), list);
                continue;
            }
            wordWithLen.add(word);
        }
        if (this.words.size() == 0) {
            throw new RuntimeException("Invalid dictionary.");
        }
    }

    private WordLengthPair chooseRandomStart_() {
        Set<WordLengthPair> keys = this.chains.keySet();
        HashSet<WordLengthPair> validStarts = new HashSet<WordLengthPair>(this.starts);
        validStarts.retainAll(keys);
        int index = this.randomInt(validStarts.size());
        WordLengthPair wlPair = validStarts.toArray(new WordLengthPair[0])[index];
        return wlPair;
    }

    static String[] splitParagraphs(String text) {
        return LoremIpsum.filterNotEmptyOrWhiteSpace(text.split("\n")).toArray(new String[0]);
    }

    static String[] splitSentences(String text) {
        return LoremIpsum.filterNotEmptyOrWhiteSpace(text.split(SENTENCE_SPLIT_REGEX)).toArray(new String[0]);
    }

    static String[] splitWords(String text) {
        return LoremIpsum.filterNotEmptyOrWhiteSpace(text.split(WORD_SPLIT_REGEX)).toArray(new String[0]);
    }

    static int chooseClosest(Integer[] values, int target) {
        int closest = values[0];
        Integer[] integerArray = values;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int value = integerArray[i];
            if (Math.abs(target - value) >= Math.abs(target - closest)) continue;
            closest = value;
        }
        return closest;
    }

    private static WordInfo getWordInfo(String word) {
        WordInfo ret = new WordInfo();
        for (String delim : DELIMITERS_WORDS) {
            if (!word.endsWith(delim)) continue;
            ret.len = word.length() - delim.length();
            ret.delim = delim;
            return ret;
        }
        ret.len = word.length();
        ret.delim = "";
        return ret;
    }

    private static WordInfo[] generateWordInfo(String[] words) {
        WordInfo[] result = new WordInfo[words.length];
        int i = 0;
        for (String word : words) {
            result[i++] = LoremIpsum.getWordInfo(word);
        }
        return result;
    }

    private static double randomNormal(double mu, double sigma) {
        double u2;
        double u1;
        double zz;
        SecureRandom rnd = new SecureRandom();
        double z = 0.0;
        while (!((zz = (z = NV_MAGICCONST_ * ((u1 = rnd.nextDouble()) - 0.5) / (u2 = 1.0 - rnd.nextDouble())) * z / 4.0) <= -Math.log(u2))) {
        }
        return mu + z * sigma;
    }

    private static List<String> filterNotEmptyOrWhiteSpace(String[] arr) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : arr) {
            String trims = s.trim();
            if (trims.length() <= 0) continue;
            result.add(trims);
        }
        return result;
    }

    public static double mean(int[] values) {
        return (double)LoremIpsum.sum(values) / (double)Math.max(values.length, 1);
    }

    public static double mean(double[] values) {
        return LoremIpsum.sum(values) / (double)Math.max(values.length, 1);
    }

    public static double variance(double[] values) {
        double[] squared = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            squared[i] = values[i] * values[i];
        }
        double meanVal = LoremIpsum.mean(values);
        return LoremIpsum.mean(squared) - meanVal * meanVal;
    }

    public static double sigma(int[] values) {
        double[] d = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            d[i] = values[i];
        }
        return LoremIpsum.sigma(d);
    }

    public static double sigma(double[] values) {
        return Math.sqrt(LoremIpsum.variance(values));
    }

    public static int sum(int[] values) {
        int sum = 0;
        for (int val : values) {
            sum += val;
        }
        return sum;
    }

    public static double sum(double[] values) {
        double sum = 0.0;
        for (double val : values) {
            sum += val;
        }
        return sum;
    }

    public static boolean contains(String[] array, String val) {
        for (String s : array) {
            if (!s.equals(val)) continue;
            return true;
        }
        return false;
    }

    double getSentenceMean() {
        return this.sentenceMean;
    }

    double getSentenceSigma() {
        return this.sentenceSigma;
    }

    double getParagraphMean() {
        return this.paragraphMean;
    }

    double getParagraphSigma() {
        return this.paragraphSigma;
    }

    public String generateParagraphsHtml(int quantity, boolean startWithLorem) {
        return this.generateMarkupParagraphs("<p>" + LINE_SEPARATOR + "\t", LINE_SEPARATOR + "</p>", LINE_SEPARATOR + "</p>" + LINE_SEPARATOR + "<p>" + LINE_SEPARATOR + "\t", quantity, startWithLorem);
    }

    public void generateParagraphsHtml(Appendable writer, int quantity, boolean startWithLorem) throws IOException {
        this.generateMarkupParagraphs(writer, "<p>" + LINE_SEPARATOR + "\t", LINE_SEPARATOR + "</p>", LINE_SEPARATOR + "</p>" + LINE_SEPARATOR + "<p>" + LINE_SEPARATOR + "\t", quantity, startWithLorem);
    }

    public String generateOneParagraphHtml(int quantity, boolean startWithLorem) {
        return this.generateMarkupSentences("<p>" + LINE_SEPARATOR + "\t", LINE_SEPARATOR + "</p>", LINE_SEPARATOR, quantity, startWithLorem);
    }

    public String generateParagraphsFullHtml(int quantity, boolean startWithLorem) {
        String prefix = "<html>" + LINE_SEPARATOR + "<header>" + LINE_SEPARATOR + "<title>Lorem Ipsum</title>" + LINE_SEPARATOR + "</header>" + LINE_SEPARATOR + LINE_SEPARATOR + "<body>";
        String postfix = "</body>" + LINE_SEPARATOR + "</html>" + LINE_SEPARATOR;
        return this.generateMarkupParagraphs(prefix + LINE_SEPARATOR + "<p>" + LINE_SEPARATOR + "\t", LINE_SEPARATOR + "</p>" + LINE_SEPARATOR + postfix, LINE_SEPARATOR + "</p>" + LINE_SEPARATOR + "<p>" + LINE_SEPARATOR + "\t", quantity, startWithLorem);
    }

    public void generateParagraphsFullHtml(Appendable writer, int quantity, boolean startWithLorem) throws IOException {
        String prefix = "<html>" + LINE_SEPARATOR + "<header>" + LINE_SEPARATOR + "<title>Lorem Ipsum</title>" + LINE_SEPARATOR + "</header>" + LINE_SEPARATOR + LINE_SEPARATOR + "<body>";
        String postfix = "</body>" + LINE_SEPARATOR + "</html>" + LINE_SEPARATOR;
        this.generateMarkupParagraphs(writer, prefix + LINE_SEPARATOR + "<p>" + LINE_SEPARATOR + "\t", LINE_SEPARATOR + "</p>" + LINE_SEPARATOR + postfix, LINE_SEPARATOR + "</p>" + LINE_SEPARATOR + "<p>" + LINE_SEPARATOR + "\t", quantity, startWithLorem);
    }

    public String generateParagraphsPlainText(int quantity, boolean startWithLorem) {
        return this.generateMarkupParagraphs("", "", LINE_SEPARATOR + LINE_SEPARATOR, quantity, startWithLorem);
    }

    public void generateParagraphsPlainText(Appendable writer, int quantity, boolean startWithLorem) throws IOException {
        this.generateMarkupParagraphs(writer, "", "", LINE_SEPARATOR + LINE_SEPARATOR, quantity, startWithLorem);
    }

    public String generateParagraphsPlainText(int quantity, int maxCols, boolean startWithLorem) {
        StringWriter writer = new StringWriter(quantity + 512);
        try {
            this.generateParagraphsPlainText(writer, quantity, maxCols, startWithLorem);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    public void generateParagraphsPlainText(Appendable writer, int quantity, int maxCols, boolean startWithLorem) throws IOException {
        String delims = " .,?!";
        String unformatted = this.generateMarkupParagraphs("", "", LINE_SEPARATOR + LINE_SEPARATOR, quantity, startWithLorem);
        int len = unformatted.length();
        if (maxCols <= 0) {
            writer.append(unformatted);
        } else {
            int startPos = 0;
            while (startPos < len - 1) {
                int endPos = Math.min(startPos + maxCols, len - 1);
                boolean shift = true;
                for (int i = startPos; i < endPos; ++i) {
                    if (unformatted.charAt(i) != '\n') continue;
                    shift = false;
                    endPos = i;
                }
                char ch = unformatted.charAt(endPos);
                while (shift) {
                    for (int i = 0; i < delims.length(); ++i) {
                        if (ch != delims.charAt(i)) continue;
                        shift = false;
                        break;
                    }
                    if (!shift) continue;
                    ch = unformatted.charAt(--endPos);
                    shift = endPos > startPos;
                }
                writer.append(unformatted.substring(startPos, endPos + 1));
                if (unformatted.charAt(endPos) != '\n') {
                    writer.append(LINE_SEPARATOR);
                }
                startPos = endPos + 1;
            }
        }
    }

    private static class WordInfo {
        int len;
        String delim;

        private WordInfo() {
        }
    }

    private static class WordLengthPair {
        public int len1;
        public int len2;

        public WordLengthPair(int len1, int len2) {
            this.len1 = len1;
            this.len2 = len2;
        }

        public String toString() {
            return "WordLengthPair: len1: " + this.len1 + ", len2: " + this.len2;
        }

        public boolean equals(Object other) {
            if (this == null || other == null) {
                return false;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            return this.len1 == ((WordLengthPair)other).len1 && this.len2 == ((WordLengthPair)other).len2;
        }

        public int hashCode() {
            return this.len1 ^ this.len2;
        }
    }
}

