/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.BinaryExpression;
import com.github.sommeri.less4j.core.ast.BinaryExpressionOperator;
import com.github.sommeri.less4j.core.ast.ColorExpression;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FaultyExpression;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.BugHappened;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;

class ColorsCalculator {
    private final ProblemsHandler problemsHandler;
    private static final int MIN = 0;
    private static final int MAX = 255;
    private static final double ALPHA_MIN = 0.0;
    private static final double ALPHA_MAX = 1.0;
    private static final double ALPHA_EPSILON = 1.0E-16;

    public ColorsCalculator(ProblemsHandler problemsHandler) {
        this.problemsHandler = problemsHandler;
    }

    public Expression evalute(BinaryExpression originalExpression, Expression first, Expression second) {
        double red1 = this.calcRed(first);
        double green1 = this.calcGreen(first);
        double blue1 = this.calcBlue(first);
        double alpha1 = this.calcAlpha(first);
        double red2 = this.calcRed(second);
        double green2 = this.calcGreen(second);
        double blue2 = this.calcBlue(second);
        double alpha2 = this.calcAlpha(second);
        BinaryExpressionOperator operator = originalExpression.getOperator();
        switch (operator.getOperator()) {
            case SOLIDUS: {
                return this.divide(first, red1, green1, blue1, alpha1, red2, green2, blue2, alpha2, originalExpression.getUnderlyingStructure());
            }
            case STAR: {
                return this.multiply(red1, green1, blue1, alpha1, red2, green2, blue2, alpha2, originalExpression.getUnderlyingStructure());
            }
            case MINUS: {
                return this.subtract(first, red1, green1, blue1, alpha1, red2, green2, blue2, alpha2, originalExpression.getUnderlyingStructure());
            }
            case PLUS: {
                return this.add(red1, green1, blue1, alpha1, red2, green2, blue2, alpha2, originalExpression.getUnderlyingStructure());
            }
        }
        throw new BugHappened("Unknown operator.", (ASTCssNode)operator);
    }

    private Expression subtract(Expression first, double red1, double green1, double blue1, double alpha1, double red2, double green2, double blue2, double alpha2, HiddenTokenAwareTree parentToken) {
        if (first.getType() == ASTCssNodeType.NUMBER) {
            this.problemsHandler.subtractOrDiveColorFromNumber(first);
            return new FaultyExpression(first);
        }
        return this.createResultColor(parentToken, this.round(red1 - red2), this.round(green1 - green2), this.round(blue1 - blue2), alpha1, alpha2);
    }

    private ColorExpression multiply(double red1, double green1, double blue1, double alpha1, double red2, double green2, double blue2, double alpha2, HiddenTokenAwareTree parentToken) {
        return this.createResultColor(parentToken, this.round(red1 * red2), this.round(green1 * green2), this.round(blue1 * blue2), alpha1, alpha2);
    }

    private Expression divide(Expression first, double red1, double green1, double blue1, double alpha1, double red2, double green2, double blue2, double alpha2, HiddenTokenAwareTree parentToken) {
        if (first.getType() == ASTCssNodeType.NUMBER) {
            this.problemsHandler.subtractOrDiveColorFromNumber(first);
            return new FaultyExpression(first);
        }
        return this.createResultColor(parentToken, this.round(red1 / red2), this.round(green1 / green2), this.round(blue1 / blue2), alpha1, alpha2);
    }

    private ColorExpression add(double red1, double green1, double blue1, double alpha1, double red2, double green2, double blue2, double alpha2, HiddenTokenAwareTree parentToken) {
        return this.createResultColor(parentToken, this.round(red1 + red2), this.round(green1 + green2), this.round(blue1 + blue2), alpha1, alpha2);
    }

    private int round(double number) {
        if (number > 255.0) {
            return 255;
        }
        return number < 0.0 ? 0 : (int)Math.round(number);
    }

    private double combineAlpha(double alpha1, double alpha2) {
        double alpha = alpha1 * (1.0 - alpha2) + alpha2;
        if (alpha > 1.0) {
            return 1.0;
        }
        return alpha < 0.0 ? 0.0 : alpha;
    }

    private ColorExpression createResultColor(HiddenTokenAwareTree parentToken, double red, double green, double blue, double alpha1, double alpha2) {
        double roundAlpha = this.combineAlpha(alpha1, alpha2);
        if (roundAlpha < 0.9999999999999999) {
            return new ColorExpression.ColorWithAlphaExpression(parentToken, this.round(red), (double)this.round(green), (double)this.round(blue), roundAlpha);
        }
        return new ColorExpression(parentToken, this.round(red), this.round(green), this.round(blue));
    }

    public boolean accepts(BinaryExpressionOperator operator, Expression first, Expression second) {
        return this.acceptedOperand(first, second);
    }

    private boolean acceptedOperand(Expression first, Expression second) {
        if (first.getType() != ASTCssNodeType.COLOR_EXPRESSION && first.getType() != ASTCssNodeType.NUMBER) {
            return false;
        }
        if (second.getType() != ASTCssNodeType.COLOR_EXPRESSION && second.getType() != ASTCssNodeType.NUMBER) {
            return false;
        }
        return first.getType() == ASTCssNodeType.COLOR_EXPRESSION || second.getType() == ASTCssNodeType.COLOR_EXPRESSION;
    }

    private double calcRed(Expression value) {
        if (value instanceof ColorExpression) {
            return ((ColorExpression)value).getRed();
        }
        return ((NumberExpression)value).getValueAsDouble();
    }

    private double calcGreen(Expression value) {
        if (value instanceof ColorExpression) {
            return ((ColorExpression)value).getGreen();
        }
        return ((NumberExpression)value).getValueAsDouble();
    }

    private double calcBlue(Expression value) {
        if (value instanceof ColorExpression) {
            return ((ColorExpression)value).getBlue();
        }
        return ((NumberExpression)value).getValueAsDouble();
    }

    private double calcAlpha(Expression value) {
        if (value instanceof ColorExpression) {
            return ((ColorExpression)value).getAlpha();
        }
        return Double.POSITIVE_INFINITY;
    }
}

