/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.solr.common.IteratorWriter;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.TextWriter;

public interface JsonTextWriter
extends TextWriter {
    public static final char[] hexdigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final String JSON_NL_MAP = "map";
    public static final String JSON_NL_FLAT = "flat";
    public static final String JSON_NL_ARROFARR = "arrarr";
    public static final String JSON_NL_ARROFMAP = "arrmap";
    public static final String JSON_NL_ARROFNTV = "arrntv";
    public static final String JSON_NL_STYLE = "json.nl";

    public String getNamedListStyle();

    public void _writeChar(char var1) throws IOException;

    public void _writeStr(String var1) throws IOException;

    default public void writeMapOpener(int size) throws IOException, IllegalArgumentException {
        this._writeChar('{');
    }

    default public void writeMapSeparator() throws IOException {
        this._writeChar(',');
    }

    default public void writeMapCloser() throws IOException {
        this._writeChar('}');
    }

    default public void writeArrayOpener(int size) throws IOException, IllegalArgumentException {
        this._writeChar('[');
    }

    default public void writeArraySeparator() throws IOException {
        this._writeChar(',');
    }

    default public void writeArrayCloser() throws IOException {
        this._writeChar(']');
    }

    @Override
    default public void writeStrRaw(String name, String val) throws IOException {
        this._writeStr(val);
    }

    @Override
    default public void writeStr(String name, String val, boolean needsEscaping) throws IOException {
        if (needsEscaping) {
            this._writeChar('\"');
            block9: for (int i = 0; i < val.length(); ++i) {
                char ch = val.charAt(i);
                if (ch > '#' && ch != '\\' && ch < '\u2028' || ch == ' ') {
                    this._writeChar(ch);
                    continue;
                }
                switch (ch) {
                    case '\"': 
                    case '\\': {
                        this._writeChar('\\');
                        this._writeChar(ch);
                        continue block9;
                    }
                    case '\r': {
                        this._writeChar('\\');
                        this._writeChar('r');
                        continue block9;
                    }
                    case '\n': {
                        this._writeChar('\\');
                        this._writeChar('n');
                        continue block9;
                    }
                    case '\t': {
                        this._writeChar('\\');
                        this._writeChar('t');
                        continue block9;
                    }
                    case '\b': {
                        this._writeChar('\\');
                        this._writeChar('b');
                        continue block9;
                    }
                    case '\f': {
                        this._writeChar('\\');
                        this._writeChar('f');
                        continue block9;
                    }
                    case '\u2028': 
                    case '\u2029': {
                        this.unicodeEscape(this.getWriter(), ch);
                        continue block9;
                    }
                    default: {
                        if (ch <= '\u001f') {
                            this.unicodeEscape(this.getWriter(), ch);
                            continue block9;
                        }
                        this._writeChar(ch);
                    }
                }
            }
            this._writeChar('\"');
        } else {
            this._writeChar('\"');
            this._writeStr(val);
            this._writeChar('\"');
        }
    }

    @Override
    default public void writeIterator(IteratorWriter val) throws IOException {
        this.writeArrayOpener(-1);
        this.incLevel();
        val.writeIter(new IteratorWriter.ItemWriter(){
            boolean first = true;

            @Override
            public IteratorWriter.ItemWriter add(Object o) throws IOException {
                if (!this.first) {
                    JsonTextWriter.this.indent();
                    JsonTextWriter.this.writeArraySeparator();
                }
                JsonTextWriter.this.writeVal(null, o);
                this.first = false;
                return this;
            }
        });
        this.decLevel();
        this.writeArrayCloser();
    }

    @Override
    default public void writeMap(MapWriter val) throws IOException {
        this.writeMapOpener(-1);
        this.incLevel();
        val.writeMap(new MapWriter.EntryWriter(){
            boolean isFirst = true;

            @Override
            public MapWriter.EntryWriter put(CharSequence k, Object v) throws IOException {
                if (this.isFirst) {
                    this.isFirst = false;
                } else {
                    JsonTextWriter.this.writeMapSeparator();
                }
                JsonTextWriter.this.indent();
                JsonTextWriter.this.writeKey(k.toString(), true);
                JsonTextWriter.this.writeVal(k.toString(), v);
                return this;
            }
        });
        this.decLevel();
        this.writeMapCloser();
    }

    default public void writeKey(String fname, boolean needsEscaping) throws IOException {
        this.writeStr(null, fname, needsEscaping);
        this._writeChar(':');
    }

    default public void writeJsonIter(Iterator<?> val, boolean raw) throws IOException {
        this.incLevel();
        boolean first = true;
        while (val.hasNext()) {
            if (!first) {
                this.indent();
            }
            this.writeVal(null, val.next(), raw);
            if (val.hasNext()) {
                this.writeArraySeparator();
            }
            first = false;
        }
        this.decLevel();
    }

    @Override
    default public void writeNull(String name) throws IOException {
        this._writeStr("null");
    }

    @Override
    default public void writeInt(String name, String val) throws IOException {
        this._writeStr(val);
    }

    @Override
    default public void writeLong(String name, String val) throws IOException {
        this._writeStr(val);
    }

    @Override
    default public void writeBool(String name, String val) throws IOException {
        this._writeStr(val);
    }

    @Override
    default public void writeFloat(String name, String val) throws IOException {
        this._writeStr(val);
    }

    @Override
    default public void writeDouble(String name, String val) throws IOException {
        this._writeStr(val);
    }

    @Override
    default public void writeDate(String name, String val) throws IOException {
        this.writeStr(name, val, false);
    }

    @Override
    default public void writeMap(String name, Map<?, ?> val, boolean excludeOuter, boolean isFirstVal) throws IOException {
        if (!excludeOuter) {
            this.writeMapOpener(val.size());
            this.incLevel();
            isFirstVal = true;
        }
        boolean doIndent = excludeOuter || val.size() > 1;
        for (Map.Entry<?, ?> entry : val.entrySet()) {
            Object e = entry.getKey();
            String k = e == null ? "" : e.toString();
            Object v = entry.getValue();
            if (isFirstVal) {
                isFirstVal = false;
            } else {
                this.writeMapSeparator();
            }
            if (doIndent) {
                this.indent();
            }
            this.writeKey(k, true);
            this.writeVal(k, v);
        }
        if (!excludeOuter) {
            this.decLevel();
            this.writeMapCloser();
        }
    }

    @Override
    default public void writeArray(String name, List<?> l, boolean raw) throws IOException {
        this.writeArrayOpener(l.size());
        this.writeJsonIter(l.iterator(), raw);
        this.writeArrayCloser();
    }

    @Override
    default public void writeArray(String name, Iterator<?> val, boolean raw) throws IOException {
        this.writeArrayOpener(-1);
        this.writeJsonIter(val, raw);
        this.writeArrayCloser();
    }

    default public void unicodeEscape(Appendable out, int ch) throws IOException {
        out.append('\\');
        out.append('u');
        out.append(hexdigits[ch >>> 12]);
        out.append(hexdigits[ch >>> 8 & 0xF]);
        out.append(hexdigits[ch >>> 4 & 0xF]);
        out.append(hexdigits[ch & 0xF]);
    }

    @Override
    default public void writeNamedList(String name, NamedList<?> val) throws IOException {
        String namedListStyle = this.getNamedListStyle();
        if (val instanceof SimpleOrderedMap) {
            this.writeNamedListAsMapWithDups(name, val);
        } else if (Objects.equals(namedListStyle, JSON_NL_FLAT)) {
            this.writeNamedListAsFlat(name, val);
        } else if (Objects.equals(namedListStyle, JSON_NL_MAP)) {
            this.writeNamedListAsMapWithDups(name, val);
        } else if (Objects.equals(namedListStyle, JSON_NL_ARROFARR)) {
            this.writeNamedListAsArrArr(name, val);
        } else if (Objects.equals(namedListStyle, JSON_NL_ARROFMAP)) {
            this.writeNamedListAsArrMap(name, val);
        } else if (Objects.equals(namedListStyle, JSON_NL_ARROFNTV)) {
            throw new UnsupportedOperationException(namedListStyle + " namedListStyle must only be used with ArrayOfNameTypeValueJSONWriter");
        }
    }

    default public void writeNamedListAsMapMangled(String name, NamedList<?> val) throws IOException {
        int sz = val.size();
        this.writeMapOpener(sz);
        this.incLevel();
        HashMap<String, Integer> repeats = new HashMap<String, Integer>(4);
        boolean first = true;
        for (int i = 0; i < sz; ++i) {
            Object key = val.getName(i);
            if (key == null) {
                key = "";
            }
            if (first) {
                first = false;
                repeats.put((String)key, 0);
            } else {
                this.writeMapSeparator();
                Integer repeatCount = (Integer)repeats.get(key);
                if (repeatCount == null) {
                    repeats.put((String)key, 0);
                } else {
                    Object newKey = key;
                    int newCount = repeatCount;
                    while ((repeatCount = (Integer)repeats.get(newKey = (String)key + " " + ++newCount)) != null) {
                    }
                    repeats.put((String)key, newCount);
                    key = newKey;
                }
            }
            this.indent();
            this.writeKey((String)key, true);
            this.writeVal((String)key, val.getVal(i));
        }
        this.decLevel();
        this.writeMapCloser();
    }

    default public void writeNamedListAsMapWithDups(String name, NamedList<?> val) throws IOException {
        int sz = val.size();
        this.writeMapOpener(sz);
        this.incLevel();
        for (int i = 0; i < sz; ++i) {
            String key;
            if (i != 0) {
                this.writeMapSeparator();
            }
            if ((key = val.getName(i)) == null) {
                key = "";
            }
            this.indent();
            this.writeKey(key, true);
            this.writeVal(key, val.getVal(i));
        }
        this.decLevel();
        this.writeMapCloser();
    }

    default public void writeNamedListAsArrMap(String name, NamedList<?> val) throws IOException {
        int sz = val.size();
        this.indent();
        this.writeArrayOpener(sz);
        this.incLevel();
        boolean first = true;
        for (int i = 0; i < sz; ++i) {
            String key = val.getName(i);
            if (first) {
                first = false;
            } else {
                this.writeArraySeparator();
            }
            this.indent();
            if (key == null) {
                this.writeVal(null, val.getVal(i));
                continue;
            }
            this.writeMapOpener(1);
            this.writeKey(key, true);
            this.writeVal(key, val.getVal(i));
            this.writeMapCloser();
        }
        this.decLevel();
        this.writeArrayCloser();
    }

    default public void writeNamedListAsArrArr(String name, NamedList<?> val) throws IOException {
        int sz = val.size();
        this.indent();
        this.writeArrayOpener(sz);
        this.incLevel();
        boolean first = true;
        for (int i = 0; i < sz; ++i) {
            String key = val.getName(i);
            if (first) {
                first = false;
            } else {
                this.writeArraySeparator();
            }
            this.indent();
            this.writeArrayOpener(1);
            this.incLevel();
            if (key == null) {
                this.writeNull(null);
            } else {
                this.writeStr(null, key, true);
            }
            this.writeArraySeparator();
            this.writeVal(key, val.getVal(i));
            this.decLevel();
            this.writeArrayCloser();
        }
        this.decLevel();
        this.writeArrayCloser();
    }

    default public void writeNamedListAsFlat(String name, NamedList<?> val) throws IOException {
        int sz = val.size();
        this.writeArrayOpener(sz * 2);
        this.incLevel();
        for (int i = 0; i < sz; ++i) {
            if (i != 0) {
                this.writeArraySeparator();
            }
            String key = val.getName(i);
            this.indent();
            if (key == null) {
                this.writeNull(null);
            } else {
                this.writeStr(null, key, true);
            }
            this.writeArraySeparator();
            this.writeVal(key, val.getVal(i));
        }
        this.decLevel();
        this.writeArrayCloser();
    }
}

