/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas_data.impl;

import org.apache.uima.cas.impl.XCASParsingException;
import org.apache.uima.cas_data.CasData;
import org.apache.uima.cas_data.PrimitiveArrayFS;
import org.apache.uima.cas_data.ReferenceArrayFS;
import org.apache.uima.cas_data.impl.FeatureStructureImpl;
import org.apache.uima.cas_data.impl.PrimitiveArrayFSImpl;
import org.apache.uima.cas_data.impl.PrimitiveValueImpl;
import org.apache.uima.cas_data.impl.ReferenceArrayFSImpl;
import org.apache.uima.cas_data.impl.ReferenceValueImpl;
import org.apache.uima.internal.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XCasToCasDataSaxHandler
extends DefaultHandler {
    private static final int DOC_STATE = 0;
    private static final int FS_STATE = 1;
    private static final int FEAT_STATE = 2;
    private static final int CONTENT_STATE = 3;
    private static final int FEAT_CONTENT_STATE = 4;
    private static final int ARRAY_ELE_CONTENT_STATE = 5;
    private static final int ARRAY_ELE_STATE = 6;
    private static final String reservedAttrPrefix = "_";
    private static final String unknownXMLSource = "<unknown>";
    private static final String DEFAULT_CONTENT_FEATURE = "value";
    private Locator locator;
    private CasData cas;
    private int state;
    private StringBuffer buffer = new StringBuffer();
    private FeatureStructureImpl currentFS;
    private String currentContentFeat;
    private int arrayPos;
    private int arrayType;
    private static final int INT_TYPE = 0;
    private static final int FLOAT_TYPE = 1;
    private static final int STRING_TYPE = 2;
    private static final int FS_TYPE = 3;

    public XCasToCasDataSaxHandler(CasData aCasData) {
        this.cas = aCasData;
    }

    private final void resetBuffer() {
        this.buffer = new StringBuffer();
    }

    @Override
    public void startDocument() throws SAXException {
        this.state = 0;
    }

    @Override
    public void startElement(String nameSpaceURI, String localName, String qualifiedName, Attributes attrs) throws SAXException {
        this.resetBuffer();
        switch (this.state) {
            case 0: {
                if (!qualifiedName.equals("CAS")) {
                    throw this.createException(0, qualifiedName);
                }
                this.state = 1;
                break;
            }
            case 1: {
                this.currentContentFeat = DEFAULT_CONTENT_FEATURE;
                this.readFS(qualifiedName, attrs);
                break;
            }
            case 6: {
                this.readArrayElement(qualifiedName, attrs);
                break;
            }
            default: {
                throw this.createException(1, qualifiedName);
            }
        }
    }

    private void readArrayElement(String eleName, Attributes attrs) throws SAXParseException {
        if (!eleName.equals("i")) {
            throw this.createException(2, eleName);
        }
        if (attrs.getLength() > 0) {
            throw this.createException(3);
        }
        this.state = 5;
        this.resetBuffer();
    }

    private void readFS(String qualifiedName, Attributes attrs) throws SAXParseException {
        if (this.isArrayType(qualifiedName)) {
            this.readArray(qualifiedName, attrs);
        } else {
            this.currentFS = new FeatureStructureImpl();
            this.currentFS.setType(this.getCasTypeName(qualifiedName));
            this.readFS(this.currentFS, attrs);
        }
        this.cas.addFeatureStructure(this.currentFS);
    }

    private String getCasTypeName(String aTagName) {
        return StringUtils.replaceAll(StringUtils.replaceAll(aTagName, ":", "_colon_"), "-", "_dash_");
    }

    private void readFS(FeatureStructureImpl fsImpl, Attributes attrs) throws SAXParseException {
        for (int i = 0; i < attrs.getLength(); ++i) {
            String attrName = attrs.getQName(i);
            String attrValue = attrs.getValue(i);
            if (attrName.startsWith(reservedAttrPrefix)) {
                if (attrName.equals("_id")) {
                    fsImpl.setId(attrValue);
                    continue;
                }
                if (attrName.equals("_content")) {
                    this.currentContentFeat = attrValue;
                    continue;
                }
                if (attrName.equals("_indexed")) {
                    if (attrValue.equals("true")) {
                        fsImpl.setIndexed(new int[]{1});
                        continue;
                    }
                    if (attrValue.equals("false")) continue;
                    fsImpl.setIndexed(this.parseIntArray(attrValue));
                    continue;
                }
                this.handleFeature(fsImpl, attrName, attrValue);
                continue;
            }
            this.handleFeature(fsImpl, attrName, attrValue);
        }
        this.state = 3;
    }

    private int[] parseIntArray(String val) {
        String[] strVals = "".equals(val = val.trim()) ? new String[]{} : val.split("\\s+");
        int[] intVals = new int[strVals.length];
        for (int i = 0; i < strVals.length; ++i) {
            intVals[i] = Integer.parseInt(strVals[i]);
        }
        return intVals;
    }

    private void readArray(String type, Attributes attrs) throws SAXParseException {
        int[] indexed = new int[]{};
        int size = 0;
        String id = null;
        for (int i = 0; i < attrs.getLength(); ++i) {
            String attrName = attrs.getQName(i);
            String attrVal = attrs.getValue(i);
            if (attrName.equals("_id")) {
                id = attrVal;
                continue;
            }
            if (attrName.equals("size")) {
                try {
                    size = Integer.parseInt(attrVal);
                    if (size >= 0) continue;
                    throw this.createException(6, attrVal);
                }
                catch (NumberFormatException e) {
                    throw this.createException(9, attrVal);
                }
            }
            if (attrName.equals("_indexed")) {
                if (attrVal.equals("true")) {
                    indexed = new int[]{1};
                    continue;
                }
                if (attrVal.equals("false")) continue;
                indexed = this.parseIntArray(attrVal);
                continue;
            }
            throw this.createException(7, attrName);
        }
        this.arrayPos = 0;
        if ("uima.cas.IntegerArray".equals(type)) {
            this.currentFS = new PrimitiveArrayFSImpl(new int[size]);
            this.arrayType = 0;
        } else if ("uima.cas.FloatArray".equals(type)) {
            this.currentFS = new PrimitiveArrayFSImpl(new float[size]);
            this.arrayType = 1;
        } else if ("uima.cas.StringArray".equals(type)) {
            this.currentFS = new PrimitiveArrayFSImpl(new String[size]);
            this.arrayType = 2;
        } else {
            this.currentFS = new ReferenceArrayFSImpl(new String[size]);
            this.arrayType = 3;
        }
        this.currentFS.setId(id);
        this.currentFS.setType(type);
        this.currentFS.setIndexed(indexed);
        this.currentFS.setFeatureValue("size", new PrimitiveValueImpl(size));
        this.state = 6;
    }

    private final boolean emptyVal(String val) {
        return val == null || val.length() == 0;
    }

    private void handleFeature(FeatureStructureImpl fsImpl, String featName, String featVal) throws SAXParseException {
        if (featName.startsWith("_ref_")) {
            String realFeatName = featName.substring("_ref_".length());
            fsImpl.setFeatureValue(realFeatName, new ReferenceValueImpl(featVal));
        } else {
            fsImpl.setFeatureValue(featName, new PrimitiveValueImpl(featVal));
        }
    }

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        if (this.state == 3 || this.state == 5 || this.state == 4) {
            this.buffer.append(chars, start, length);
        }
    }

    @Override
    public void endElement(String nsURI, String localName, String qualifiedName) throws SAXException {
        switch (this.state) {
            case 0: {
                break;
            }
            case 1: {
                this.state = 0;
                break;
            }
            case 2: {
                this.state = 1;
                break;
            }
            case 3: {
                if (!this.isAllWhitespace(this.buffer)) {
                    this.handleFeature(this.currentFS, this.currentContentFeat, this.buffer.toString());
                }
                this.state = 1;
                break;
            }
            case 4: {
                this.handleFeature(this.currentFS, qualifiedName, this.buffer.toString());
                this.state = 2;
                break;
            }
            case 5: {
                this.addArrayElement(this.buffer.toString());
                this.state = 6;
                break;
            }
            case 6: {
                this.state = 1;
            }
        }
    }

    boolean isAllWhitespace(StringBuffer b) {
        int len = b.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(b.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void addArrayElement(String content) throws SAXParseException {
        switch (this.arrayType) {
            case 0: {
                if (this.emptyVal(content)) break;
                try {
                    ((PrimitiveArrayFS)((Object)this.currentFS)).toIntArray()[this.arrayPos] = Integer.parseInt(content);
                    break;
                }
                catch (NumberFormatException e) {
                    throw this.createException(9, content);
                }
            }
            case 1: {
                if (this.emptyVal(content)) break;
                try {
                    ((PrimitiveArrayFS)((Object)this.currentFS)).toFloatArray()[this.arrayPos] = Float.parseFloat(content);
                    break;
                }
                catch (NumberFormatException e) {
                    throw this.createException(10, content);
                }
            }
            case 2: {
                ((PrimitiveArrayFS)((Object)this.currentFS)).toStringArray()[this.arrayPos] = content;
                break;
            }
            case 3: {
                if (this.emptyVal(content)) break;
                ((ReferenceArrayFS)((Object)this.currentFS)).getIdRefArray()[this.arrayPos] = content;
            }
        }
        ++this.arrayPos;
    }

    @Override
    public void endDocument() throws SAXException {
    }

    private XCASParsingException createException(int code) {
        XCASParsingException e = new XCASParsingException(code);
        String source = unknownXMLSource;
        String line = unknownXMLSource;
        String col = unknownXMLSource;
        if (this.locator != null) {
            source = this.locator.getSystemId();
            if (source == null) {
                source = this.locator.getPublicId();
            }
            if (source == null) {
                source = unknownXMLSource;
            }
            line = Integer.toString(this.locator.getLineNumber());
            col = Integer.toString(this.locator.getColumnNumber());
        }
        e.addArgument(source);
        e.addArgument(line);
        e.addArgument(col);
        return e;
    }

    private XCASParsingException createException(int code, String arg) {
        XCASParsingException e = this.createException(code);
        e.addArgument(arg);
        return e;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator loc) {
        this.locator = loc;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        throw e;
    }

    private boolean isArrayType(String typeName) {
        return "uima.cas.IntegerArray".equals(typeName) || "uima.cas.FloatArray".equals(typeName) || "uima.cas.StringArray".equals(typeName) || "uima.cas.FSArray".equals(typeName);
    }
}

