/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pkg;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.compress.MemoryLimitException;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.deflate.DeflateCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipUtils;
import org.apache.commons.compress.compressors.lzma.LZMACompressorInputStream;
import org.apache.commons.compress.compressors.pack200.Pack200CompressorInputStream;
import org.apache.commons.compress.compressors.snappy.FramedSnappyCompressorInputStream;
import org.apache.commons.compress.compressors.snappy.SnappyCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.z.ZCompressorInputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.config.Field;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.TikaMemoryLimitException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.pkg.CompressorParserOptions;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CompressorParser
extends AbstractParser {
    private static final long serialVersionUID = 2793565792967222459L;
    private static final MediaType BROTLI = MediaType.application((String)"x-brotli");
    private static final MediaType LZ4_BLOCK = MediaType.application((String)"x-lz4-block");
    private static final MediaType SNAPPY_RAW = MediaType.application((String)"x-snappy-raw");
    private static final MediaType BZIP = MediaType.application((String)"x-bzip");
    private static final MediaType BZIP2 = MediaType.application((String)"x-bzip2");
    private static final MediaType GZIP = MediaType.application((String)"gzip");
    private static final MediaType GZIP_ALT = MediaType.application((String)"x-gzip");
    private static final MediaType COMPRESS = MediaType.application((String)"x-compress");
    private static final MediaType XZ = MediaType.application((String)"x-xz");
    private static final MediaType PACK = MediaType.application((String)"x-java-pack200");
    private static final MediaType SNAPPY_FRAMED = MediaType.application((String)"x-snappy");
    private static final MediaType ZLIB = MediaType.application((String)"zlib");
    private static final MediaType LZMA = MediaType.application((String)"x-lzma");
    private static final MediaType LZ4_FRAMED = MediaType.application((String)"x-lz4");
    private static final MediaType ZSTD = MediaType.application((String)"zstd");
    private static final MediaType DEFLATE64 = MediaType.application((String)"deflate64");
    private static Set<MediaType> SUPPORTED_TYPES;
    private static Map<String, String> MIMES_TO_NAME;
    private int memoryLimitInKb = 100000;

    @Deprecated
    static MediaType getMediaType(CompressorInputStream stream) {
        if (stream instanceof BZip2CompressorInputStream) {
            return BZIP2;
        }
        if (stream instanceof GzipCompressorInputStream) {
            return GZIP;
        }
        if (stream instanceof XZCompressorInputStream) {
            return XZ;
        }
        if (stream instanceof DeflateCompressorInputStream) {
            return ZLIB;
        }
        if (stream instanceof ZCompressorInputStream) {
            return COMPRESS;
        }
        if (stream instanceof Pack200CompressorInputStream) {
            return PACK;
        }
        if (stream instanceof FramedSnappyCompressorInputStream || stream instanceof SnappyCompressorInputStream) {
            return SNAPPY_FRAMED;
        }
        if (stream instanceof LZMACompressorInputStream) {
            return LZMA;
        }
        return MediaType.OCTET_STREAM;
    }

    static MediaType getMediaType(String name) {
        if ("br".equals(name)) {
            return BROTLI;
        }
        if ("lz4-block".equals(name)) {
            return LZ4_BLOCK;
        }
        if ("lz4-framed".equals(name)) {
            return LZ4_FRAMED;
        }
        if ("bzip2".equals(name)) {
            return BZIP2;
        }
        if ("gz".equals(name)) {
            return GZIP;
        }
        if ("xz".equals(name)) {
            return XZ;
        }
        if ("deflate".equals(name)) {
            return ZLIB;
        }
        if ("z".equals(name)) {
            return COMPRESS;
        }
        if ("pack200".equals(name)) {
            return PACK;
        }
        if ("snappy-framed".equals(name)) {
            return SNAPPY_FRAMED;
        }
        if ("snappy-raw".equals(name)) {
            return SNAPPY_RAW;
        }
        if ("lzma".equals(name)) {
            return LZMA;
        }
        if ("zstd".equals(name)) {
            return ZSTD;
        }
        if ("deflate64".equals(name)) {
            return DEFLATE64;
        }
        return MediaType.OCTET_STREAM;
    }

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        CompressorInputStream cis;
        String name;
        stream = stream.markSupported() ? new CloseShieldInputStream(stream) : new BufferedInputStream((InputStream)new CloseShieldInputStream(stream));
        try {
            CompressorParserOptions options = (CompressorParserOptions)context.get(CompressorParserOptions.class, (Object)new CompressorParserOptions(){

                @Override
                public boolean decompressConcatenated(Metadata metadata) {
                    return false;
                }
            });
            CompressorStreamFactory factory = new CompressorStreamFactory(options.decompressConcatenated(metadata), this.memoryLimitInKb);
            name = this.getStreamName(metadata);
            if (name != null) {
                cis = factory.createCompressorInputStream(name, stream);
            } else {
                cis = factory.createCompressorInputStream(stream);
                MediaType type = CompressorParser.getMediaType(cis);
                if (!type.equals((Object)MediaType.OCTET_STREAM)) {
                    metadata.set("Content-Type", type.toString());
                }
            }
        }
        catch (CompressorException e) {
            if (e.getCause() != null && e.getCause() instanceof MemoryLimitException) {
                throw new TikaMemoryLimitException(e.getMessage());
            }
            throw new TikaException("Unable to uncompress document stream", (Throwable)e);
        }
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        try {
            EmbeddedDocumentExtractor extractor;
            Metadata entrydata = new Metadata();
            name = metadata.get("resourceName");
            if (name != null) {
                if (name.endsWith(".tbz")) {
                    name = name.substring(0, name.length() - 4) + ".tar";
                } else if (name.endsWith(".tbz2")) {
                    name = name.substring(0, name.length() - 5) + ".tar";
                } else if (name.endsWith(".bz")) {
                    name = name.substring(0, name.length() - 3);
                } else if (name.endsWith(".bz2")) {
                    name = name.substring(0, name.length() - 4);
                } else if (name.endsWith(".xz")) {
                    name = name.substring(0, name.length() - 3);
                } else if (name.endsWith(".zlib")) {
                    name = name.substring(0, name.length() - 5);
                } else if (name.endsWith(".pack")) {
                    name = name.substring(0, name.length() - 5);
                } else if (name.endsWith(".br")) {
                    name = name.substring(0, name.length() - 3);
                } else if (name.length() > 0) {
                    name = GzipUtils.getUncompressedFilename((String)name);
                }
                entrydata.set("resourceName", name);
            }
            if ((extractor = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor((ParseContext)context)).shouldParseEmbedded(entrydata)) {
                extractor.parseEmbedded((InputStream)cis, (ContentHandler)xhtml, entrydata, true);
            }
        }
        finally {
            cis.close();
        }
        xhtml.endDocument();
    }

    private String getStreamName(Metadata metadata) {
        String mimeString = metadata.get("Content-Type");
        if (mimeString == null) {
            return null;
        }
        return MIMES_TO_NAME.get(mimeString);
    }

    @Field
    public void setMemoryLimitInKb(int memoryLimitInKb) {
        this.memoryLimitInKb = memoryLimitInKb;
    }

    static {
        HashSet<MediaType> TMP_SET = new HashSet<MediaType>();
        TMP_SET.addAll(MediaType.set((MediaType[])new MediaType[]{BZIP, BZIP2, DEFLATE64, GZIP, GZIP_ALT, LZ4_FRAMED, COMPRESS, XZ, PACK, SNAPPY_FRAMED, ZLIB, LZMA}));
        try {
            Class.forName("org.brotli.dec.BrotliInputStream");
            TMP_SET.add(BROTLI);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            // empty catch block
        }
        try {
            Class.forName("com.github.luben.zstd.ZstdInputStream");
            TMP_SET.add(ZSTD);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            // empty catch block
        }
        SUPPORTED_TYPES = Collections.unmodifiableSet(TMP_SET);
        HashMap<String, String> tmpMimesToName = new HashMap<String, String>();
        tmpMimesToName.put(BZIP2.toString(), "bzip2");
        tmpMimesToName.put(GZIP.toString(), "gz");
        tmpMimesToName.put(LZ4_FRAMED.toString(), "lz4-framed");
        tmpMimesToName.put(LZ4_BLOCK.toString(), "lz4-block");
        tmpMimesToName.put(XZ.toString(), "xz");
        tmpMimesToName.put(PACK.toString(), "pack200");
        tmpMimesToName.put(SNAPPY_FRAMED.toString(), "snappy-framed");
        tmpMimesToName.put(ZLIB.toString(), "deflate");
        tmpMimesToName.put(COMPRESS.toString(), "z");
        tmpMimesToName.put(LZMA.toString(), "lzma");
        tmpMimesToName.put(BROTLI.toString(), "br");
        tmpMimesToName.put(ZSTD.toString(), "zstd");
        MIMES_TO_NAME = Collections.unmodifiableMap(tmpMimesToName);
    }
}

