/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.provider;

import java.security.SecureRandom;
import org.apache.commons.codec.binary.Hex;
import org.opensaml.SAMLException;
import org.opensaml.SAMLIdentifier;

public class SecureRandomIDProvider
implements SAMLIdentifier {
    private static SecureRandom random = new SecureRandom();

    public synchronized String getIdentifier() throws SAMLException {
        byte[] byArray = new byte[16];
        random.nextBytes(byArray);
        return "_".concat(new String(Hex.encodeHex((byte[])byArray)));
    }

    public byte[] generateRandomBytes(SecureRandom secureRandom, int n) {
        byte[] byArray = new byte[n];
        secureRandom.nextBytes(byArray);
        return byArray;
    }

    public synchronized byte[] generateRandomBytes(int n) {
        return this.generateRandomBytes(random, n);
    }
}

