/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.lockmanager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.lockmanager.BaseLockManager;
import org.apache.manifoldcf.core.lockmanager.FileLockObjectFactory;
import org.apache.manifoldcf.core.lockmanager.LockPool;
import org.apache.manifoldcf.core.system.ManifoldCF;

public class FileLockManager
extends BaseLockManager {
    public static final String _rcsid = "@(#)$Id: FileLockManager.java 1545624 2013-11-26 11:45:53Z kwright $";
    public static final String synchDirectoryProperty = "org.apache.manifoldcf.synchdirectory";
    protected static final Integer lockPoolInitialization = new Integer(0);
    protected static LockPool myFileLocks = null;
    protected File synchDirectory = null;
    protected static final int BASE_SIZE = 128;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileLockManager(File synchDirectory) throws ManifoldCFException {
        this.synchDirectory = synchDirectory;
        if (synchDirectory == null) {
            throw new ManifoldCFException("Synch directory cannot be null");
        }
        if (!synchDirectory.isDirectory()) {
            throw new ManifoldCFException("Synch directory must point to an existing, writeable directory!", 3);
        }
        Integer n = lockPoolInitialization;
        synchronized (n) {
            if (myFileLocks == null) {
                myFileLocks = new LockPool(new FileLockObjectFactory(synchDirectory));
            }
        }
    }

    public FileLockManager() throws ManifoldCFException {
        this(FileLockManager.getSynchDirectoryProperty());
    }

    public static File getSynchDirectoryProperty() throws ManifoldCFException {
        return ManifoldCF.getFileProperty(synchDirectoryProperty);
    }

    protected static String getFlagResourceName(String flagName) {
        return "flag-" + flagName;
    }

    @Override
    public void setGlobalFlag(String flagName) throws ManifoldCFException {
        String resourceName = FileLockManager.getFlagResourceName(flagName);
        String path = this.makeFilePath(resourceName);
        new File(path).mkdirs();
        File f = new File(path, ManifoldCF.safeFileName(resourceName));
        try {
            f.createNewFile();
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException(e.getMessage(), e);
        }
    }

    @Override
    public void clearGlobalFlag(String flagName) throws ManifoldCFException {
        String resourceName = FileLockManager.getFlagResourceName(flagName);
        File f = new File(this.makeFilePath(resourceName), ManifoldCF.safeFileName(resourceName));
        f.delete();
    }

    @Override
    public boolean checkGlobalFlag(String flagName) throws ManifoldCFException {
        String resourceName = FileLockManager.getFlagResourceName(flagName);
        File f = new File(this.makeFilePath(resourceName), ManifoldCF.safeFileName(resourceName));
        return f.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readData(String resourceName) throws ManifoldCFException {
        byte[] byArray;
        File f = new File(this.makeFilePath(resourceName), ManifoldCF.safeFileName(resourceName));
        FileInputStream is = new FileInputStream(f);
        try {
            int x;
            ByteArrayBuffer bab = new ByteArrayBuffer();
            while ((x = ((InputStream)is).read()) != -1) {
                bab.add((byte)x);
            }
            byArray = bab.toArray();
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)is).close();
                throw throwable;
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (InterruptedIOException e) {
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), e, 2);
            }
            catch (IOException e) {
                throw new ManifoldCFException("IO exception: " + e.getMessage(), e);
            }
        }
        ((InputStream)is).close();
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeData(String resourceName, byte[] data) throws ManifoldCFException {
        try {
            String path = this.makeFilePath(resourceName);
            new File(path).mkdirs();
            File f = new File(path, ManifoldCF.safeFileName(resourceName));
            if (data == null) {
                f.delete();
                return;
            }
            try (FileOutputStream os = new FileOutputStream(f);){
                os.write(data, 0, data.length);
            }
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO exception: " + e.getMessage(), e);
        }
    }

    @Override
    protected LockPool getGlobalLockPool() {
        return myFileLocks;
    }

    protected String makeFilePath(String key) {
        int hashcode = key.hashCode();
        int outerDirNumber = hashcode & 0x3FF;
        int innerDirNumber = hashcode >> 10 & 0x3FF;
        Object fullDir = this.synchDirectory.toString();
        if (((String)fullDir).length() == 0 || !((String)fullDir).endsWith("/")) {
            fullDir = (String)fullDir + "/";
        }
        fullDir = (String)fullDir + Integer.toString(outerDirNumber) + "/" + Integer.toString(innerDirNumber);
        return fullDir;
    }

    protected static class ByteArrayBuffer {
        protected byte[] buffer = new byte[128];
        protected int length = 0;

        public void add(byte b) {
            if (this.length == this.buffer.length) {
                byte[] oldbuffer = this.buffer;
                this.buffer = new byte[this.length * 2];
                System.arraycopy(oldbuffer, 0, this.buffer, 0, this.length);
            }
            this.buffer[this.length++] = b;
        }

        public byte[] toArray() {
            byte[] rval = new byte[this.length];
            System.arraycopy(this.buffer, 0, rval, 0, this.length);
            return rval;
        }
    }
}

