/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents;

import org.apache.manifoldcf.agents.BaseAgentsInitializationCommand;
import org.apache.manifoldcf.agents.interfaces.AgentManagerFactory;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnectionManager;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnectorManager;
import org.apache.manifoldcf.agents.interfaces.TransformationConnectionManagerFactory;
import org.apache.manifoldcf.agents.interfaces.TransformationConnectorManagerFactory;
import org.apache.manifoldcf.agents.system.Logging;
import org.apache.manifoldcf.agents.system.ManifoldCF;
import org.apache.manifoldcf.core.interfaces.DBInterfaceFactory;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class UnRegisterAllTransformations
extends BaseAgentsInitializationCommand {
    public static final String _rcsid = "@(#)$Id: UnRegisterAllTransformations.java 1601529 2014-06-09 23:19:08Z kwright $";

    @Override
    protected void doExecute(IThreadContext tc) throws ManifoldCFException {
        IDBInterface database = DBInterfaceFactory.make((IThreadContext)tc, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
        ITransformationConnectorManager mgr = TransformationConnectorManagerFactory.make(tc);
        ITransformationConnectionManager connManager = TransformationConnectionManagerFactory.make(tc);
        IResultSet classNames = mgr.getConnectors();
        int i = 0;
        while (i < classNames.getRowCount()) {
            IResultRow row = classNames.getRow(i++);
            String className = (String)row.getValue("classname");
            database.beginTransaction();
            try {
                String[] connectionNames = connManager.findConnectionsForConnector(className);
                AgentManagerFactory.noteTransformationConnectorDeregistration(tc, connectionNames);
                mgr.unregisterConnector(className);
            }
            catch (ManifoldCFException e) {
                database.signalRollback();
                throw e;
            }
            catch (Error e) {
                database.signalRollback();
                throw e;
            }
            finally {
                database.endTransaction();
            }
        }
        Logging.root.info((Object)"Successfully unregistered all transformation connectors");
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            System.err.println("Usage: UnRegisterAllTransformations");
            System.exit(1);
        }
        try {
            UnRegisterAllTransformations unRegisterAllTransformations = new UnRegisterAllTransformations();
            unRegisterAllTransformations.execute();
            System.err.println("Successfully unregistered all transformation connectors");
        }
        catch (ManifoldCFException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

