/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices;

import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.Holder;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractPortProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractWebServicesService;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.WSConverter;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertiesType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumIncludeRelationships;
import org.apache.chemistry.opencmis.commons.impl.jaxb.VersioningServicePort;
import org.apache.chemistry.opencmis.commons.spi.VersioningService;

public class VersioningServiceImpl
extends AbstractWebServicesService
implements VersioningService {
    private final AbstractPortProvider portProvider;

    public VersioningServiceImpl(BindingSession session, AbstractPortProvider portProvider) {
        this.setSession(session);
        this.portProvider = portProvider;
    }

    public void checkOut(String repositoryId, org.apache.chemistry.opencmis.commons.spi.Holder<String> objectId, ExtensionsData extension, org.apache.chemistry.opencmis.commons.spi.Holder<Boolean> contentCopied) {
        VersioningServicePort port = this.portProvider.getVersioningServicePort(this.getCmisVersion(repositoryId), "checkOut");
        try {
            Holder portObjectId = WSConverter.convertHolder(objectId);
            Holder portContentCopied = new Holder();
            Holder portExtension = WSConverter.convertExtensionHolder((ExtensionsData)extension);
            port.checkOut(repositoryId, portObjectId, portExtension, portContentCopied);
            WSConverter.setHolderValue((Holder)portObjectId, objectId);
            WSConverter.setHolderValue((Holder)portContentCopied, contentCopied);
            WSConverter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public void cancelCheckOut(String repositoryId, String objectId, ExtensionsData extension) {
        VersioningServicePort port = this.portProvider.getVersioningServicePort(this.getCmisVersion(repositoryId), "cancelCheckOut");
        try {
            Holder portExtension = WSConverter.convertExtensionHolder((ExtensionsData)extension);
            port.cancelCheckOut(repositoryId, objectId, portExtension);
            WSConverter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public void checkIn(String repositoryId, org.apache.chemistry.opencmis.commons.spi.Holder<String> objectId, Boolean major, Properties properties, ContentStream contentStream, String checkinComment, List<String> policies, Acl addACEs, Acl removeACEs, ExtensionsData extension) {
        VersioningServicePort port = this.portProvider.getVersioningServicePort(this.getCmisVersion(repositoryId), "checkIn");
        try {
            Holder portObjectId = WSConverter.convertHolder(objectId);
            Holder portExtension = WSConverter.convertExtensionHolder((ExtensionsData)extension);
            port.checkIn(repositoryId, portObjectId, major, WSConverter.convert((Properties)properties), WSConverter.convert((ContentStream)contentStream, (boolean)false), checkinComment, policies, WSConverter.convert((Acl)addACEs), WSConverter.convert((Acl)removeACEs), portExtension);
            WSConverter.setHolderValue((Holder)portObjectId, objectId);
            WSConverter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public List<ObjectData> getAllVersions(String repositoryId, String objectId, String versionSeriesId, String filter, Boolean includeAllowableActions, ExtensionsData extension) {
        VersioningServicePort port = this.portProvider.getVersioningServicePort(this.getCmisVersion(repositoryId), "getAllVersions");
        try {
            List versionList = port.getAllVersions(repositoryId, versionSeriesId, filter, includeAllowableActions, WSConverter.convert((ExtensionsData)extension));
            if (versionList == null) {
                List<ObjectData> list = null;
                return list;
            }
            ArrayList<ObjectData> result = new ArrayList<ObjectData>();
            for (CmisObjectType version : versionList) {
                result.add(WSConverter.convert((CmisObjectType)version));
            }
            ArrayList<ObjectData> arrayList = result;
            return arrayList;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public ObjectData getObjectOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeACL, ExtensionsData extension) {
        VersioningServicePort port = this.portProvider.getVersioningServicePort(this.getCmisVersion(repositoryId), "getObjectOfLatestVersion");
        try {
            ObjectData objectData = WSConverter.convert((CmisObjectType)port.getObjectOfLatestVersion(repositoryId, versionSeriesId, major, filter, includeAllowableActions, (EnumIncludeRelationships)WSConverter.convert(EnumIncludeRelationships.class, (Enum)includeRelationships), renditionFilter, includePolicyIds, includeACL, WSConverter.convert((ExtensionsData)extension)));
            return objectData;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public Properties getPropertiesOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, ExtensionsData extension) {
        VersioningServicePort port = this.portProvider.getVersioningServicePort(this.getCmisVersion(repositoryId), "getPropertiesOfLatestVersion");
        try {
            Properties properties = WSConverter.convert((CmisPropertiesType)port.getPropertiesOfLatestVersion(repositoryId, versionSeriesId, major, filter, WSConverter.convert((ExtensionsData)extension)));
            return properties;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }
}

