/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range.ipv4;

import java.util.regex.Pattern;
import org.elasticsearch.search.aggregations.bucket.range.AbstractRangeBuilder;
import org.elasticsearch.search.aggregations.bucket.range.ipv4.InternalIPv4Range;
import org.elasticsearch.search.builder.SearchSourceBuilderException;

public class IPv4RangeBuilder
extends AbstractRangeBuilder<IPv4RangeBuilder> {
    private static final Pattern MASK_PATTERN = Pattern.compile("[\\.|/]");

    public IPv4RangeBuilder(String name) {
        super(name, InternalIPv4Range.TYPE.name());
    }

    public IPv4RangeBuilder addRange(String key, String from, String to) {
        this.ranges.add(new AbstractRangeBuilder.Range(key, from, to));
        return this;
    }

    public IPv4RangeBuilder addMaskRange(String mask) {
        return this.addMaskRange(mask, mask);
    }

    public IPv4RangeBuilder addMaskRange(String key, String mask) {
        long[] fromTo = IPv4RangeBuilder.cidrMaskToMinMax(mask);
        if (fromTo == null) {
            throw new SearchSourceBuilderException("invalid CIDR mask [" + mask + "] in ip_range aggregation [" + this.name + "]");
        }
        this.ranges.add(new AbstractRangeBuilder.Range(key, fromTo[0] < 0L ? null : Long.valueOf(fromTo[0]), fromTo[1] < 0L ? null : Long.valueOf(fromTo[1])));
        return this;
    }

    public IPv4RangeBuilder addRange(String from, String to) {
        return this.addRange(null, from, to);
    }

    public IPv4RangeBuilder addUnboundedTo(String key, String to) {
        this.ranges.add(new AbstractRangeBuilder.Range(key, null, to));
        return this;
    }

    public IPv4RangeBuilder addUnboundedTo(String to) {
        return this.addUnboundedTo(null, to);
    }

    public IPv4RangeBuilder addUnboundedFrom(String key, String from) {
        this.ranges.add(new AbstractRangeBuilder.Range(key, from, null));
        return this;
    }

    public IPv4RangeBuilder addUnboundedFrom(String from) {
        return this.addUnboundedFrom(null, from);
    }

    static long[] cidrMaskToMinMax(String cidr) {
        int to;
        long longTo;
        int mask;
        String[] parts = MASK_PATTERN.split(cidr);
        if (parts.length != 5) {
            return null;
        }
        int addr = Integer.parseInt(parts[0]) << 24 & 0xFF000000 | Integer.parseInt(parts[1]) << 16 & 0xFF0000 | Integer.parseInt(parts[2]) << 8 & 0xFF00 | Integer.parseInt(parts[3]) & 0xFF;
        int from = addr & (mask = -1 << 32 - Integer.parseInt(parts[4]));
        long longFrom = IPv4RangeBuilder.intIpToLongIp(from);
        if (longFrom == 0L) {
            longFrom = -1L;
        }
        if ((longTo = IPv4RangeBuilder.intIpToLongIp(to = from + ~mask) + 1L) == 0x100000000L) {
            longTo = -1L;
        }
        return new long[]{longFrom, longTo};
    }

    public static long intIpToLongIp(int i) {
        long p1 = (long)(i >> 24 & 0xFF) << 24;
        int p2 = (i >> 16 & 0xFF) << 16;
        int p3 = (i >> 8 & 0xFF) << 8;
        int p4 = i & 0xFF;
        return p1 + (long)p2 + (long)p3 + (long)p4;
    }
}

