/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster.reroute;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.reroute.ClusterRerouteRequest;
import org.elasticsearch.action.admin.cluster.reroute.ClusterRerouteResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.AcknowledgedRestResponseActionListener;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.XContentThrowableRestResponse;

public class RestClusterRerouteAction
extends BaseRestHandler {
    private final SettingsFilter settingsFilter;

    @Inject
    public RestClusterRerouteAction(Settings settings, Client client, RestController controller, SettingsFilter settingsFilter) {
        super(settings, client);
        this.settingsFilter = settingsFilter;
        controller.registerHandler(RestRequest.Method.POST, "/_cluster/reroute", this);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel) {
        ClusterRerouteRequest clusterRerouteRequest = Requests.clusterRerouteRequest();
        clusterRerouteRequest.listenerThreaded(false);
        clusterRerouteRequest.dryRun(request.paramAsBoolean("dry_run", clusterRerouteRequest.dryRun()));
        clusterRerouteRequest.timeout(request.paramAsTime("timeout", clusterRerouteRequest.timeout()));
        clusterRerouteRequest.masterNodeTimeout(request.paramAsTime("master_timeout", clusterRerouteRequest.masterNodeTimeout()));
        if (request.hasContent()) {
            try {
                clusterRerouteRequest.source(request.content());
            }
            catch (Exception e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    this.logger.warn("Failed to send response", e1, new Object[0]);
                }
                return;
            }
        }
        this.client.admin().cluster().reroute(clusterRerouteRequest, (ActionListener<ClusterRerouteResponse>)new AcknowledgedRestResponseActionListener<ClusterRerouteResponse>(request, channel, this.logger){

            @Override
            protected void addCustomFields(XContentBuilder builder, ClusterRerouteResponse response) throws IOException {
                builder.startObject("state");
                if (this.request.param("filter_metadata") == null) {
                    this.request.params().put("filter_metadata", "true");
                }
                response.getState().settingsFilter(RestClusterRerouteAction.this.settingsFilter).toXContent(builder, this.request);
                builder.endObject();
            }

            @Override
            public void onFailure(Throwable e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("failed to handle cluster reroute", e, new Object[0]);
                }
                super.onFailure(e);
            }
        });
    }
}

