/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.jackson.dataformat.smile;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.elasticsearch.common.jackson.core.JsonEncoding;
import org.elasticsearch.common.jackson.core.JsonFactory;
import org.elasticsearch.common.jackson.core.JsonGenerationException;
import org.elasticsearch.common.jackson.core.JsonGenerator;
import org.elasticsearch.common.jackson.core.JsonParseException;
import org.elasticsearch.common.jackson.core.JsonParser;
import org.elasticsearch.common.jackson.core.ObjectCodec;
import org.elasticsearch.common.jackson.core.Version;
import org.elasticsearch.common.jackson.core.format.InputAccessor;
import org.elasticsearch.common.jackson.core.format.MatchStrength;
import org.elasticsearch.common.jackson.core.io.IOContext;
import org.elasticsearch.common.jackson.dataformat.smile.PackageVersion;
import org.elasticsearch.common.jackson.dataformat.smile.SmileGenerator;
import org.elasticsearch.common.jackson.dataformat.smile.SmileParser;
import org.elasticsearch.common.jackson.dataformat.smile.SmileParserBootstrapper;

public class SmileFactory
extends JsonFactory {
    private static final long serialVersionUID = -1696783009312472365L;
    public static final String FORMAT_NAME_SMILE = "Smile";
    static final int DEFAULT_SMILE_PARSER_FEATURE_FLAGS = SmileParser.Feature.collectDefaults();
    static final int DEFAULT_SMILE_GENERATOR_FEATURE_FLAGS = SmileGenerator.Feature.collectDefaults();
    protected boolean _cfgDelegateToTextual;
    protected int _smileParserFeatures;
    protected int _smileGeneratorFeatures;

    public SmileFactory() {
        this(null);
    }

    public SmileFactory(ObjectCodec objectCodec) {
        super(objectCodec);
        this._smileParserFeatures = DEFAULT_SMILE_PARSER_FEATURE_FLAGS;
        this._smileGeneratorFeatures = DEFAULT_SMILE_GENERATOR_FEATURE_FLAGS;
    }

    public SmileFactory(SmileFactory smileFactory, ObjectCodec objectCodec) {
        super(smileFactory, objectCodec);
        this._cfgDelegateToTextual = smileFactory._cfgDelegateToTextual;
        this._smileParserFeatures = smileFactory._smileParserFeatures;
        this._smileGeneratorFeatures = smileFactory._smileGeneratorFeatures;
    }

    @Override
    public SmileFactory copy() {
        this._checkInvalidCopy(SmileFactory.class);
        return new SmileFactory(this, null);
    }

    public void delegateToTextual(boolean bl) {
        this._cfgDelegateToTextual = bl;
    }

    @Override
    protected Object readResolve() {
        return new SmileFactory(this, this._objectCodec);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public String getFormatName() {
        return FORMAT_NAME_SMILE;
    }

    @Override
    public MatchStrength hasFormat(InputAccessor inputAccessor) throws IOException {
        return SmileParserBootstrapper.hasSmileFormat(inputAccessor);
    }

    @Override
    public boolean canHandleBinaryNatively() {
        return true;
    }

    public final SmileFactory configure(SmileParser.Feature feature, boolean bl) {
        if (bl) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public SmileFactory enable(SmileParser.Feature feature) {
        this._smileParserFeatures |= feature.getMask();
        return this;
    }

    public SmileFactory disable(SmileParser.Feature feature) {
        this._smileParserFeatures &= ~feature.getMask();
        return this;
    }

    public final boolean isEnabled(SmileParser.Feature feature) {
        return (this._smileParserFeatures & feature.getMask()) != 0;
    }

    public final SmileFactory configure(SmileGenerator.Feature feature, boolean bl) {
        if (bl) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public SmileFactory enable(SmileGenerator.Feature feature) {
        this._smileGeneratorFeatures |= feature.getMask();
        return this;
    }

    public SmileFactory disable(SmileGenerator.Feature feature) {
        this._smileGeneratorFeatures &= ~feature.getMask();
        return this;
    }

    public final boolean isEnabled(SmileGenerator.Feature feature) {
        return (this._smileGeneratorFeatures & feature.getMask()) != 0;
    }

    @Override
    public SmileParser createParser(File file) throws IOException, JsonParseException {
        return this._createParser(new FileInputStream(file), this._createContext(file, true));
    }

    @Override
    public SmileParser createParser(URL uRL) throws IOException, JsonParseException {
        return this._createParser(this._optimizedStreamFromURL(uRL), this._createContext(uRL, true));
    }

    @Override
    public SmileParser createParser(InputStream inputStream) throws IOException, JsonParseException {
        return this._createParser(inputStream, this._createContext(inputStream, false));
    }

    @Override
    public SmileParser createParser(byte[] byArray) throws IOException, JsonParseException {
        IOContext iOContext = this._createContext(byArray, true);
        return this._createParser(byArray, 0, byArray.length, iOContext);
    }

    @Override
    public SmileParser createParser(byte[] byArray, int n, int n2) throws IOException, JsonParseException {
        return this._createParser(byArray, n, n2, this._createContext(byArray, true));
    }

    @Override
    @Deprecated
    public SmileParser createJsonParser(File file) throws IOException, JsonParseException {
        return this._createParser(new FileInputStream(file), this._createContext(file, true));
    }

    @Override
    @Deprecated
    public SmileParser createJsonParser(URL uRL) throws IOException, JsonParseException {
        return this._createParser(this._optimizedStreamFromURL(uRL), this._createContext(uRL, true));
    }

    @Override
    @Deprecated
    public SmileParser createJsonParser(InputStream inputStream) throws IOException, JsonParseException {
        return this._createParser(inputStream, this._createContext(inputStream, false));
    }

    @Override
    @Deprecated
    public SmileParser createJsonParser(byte[] byArray) throws IOException, JsonParseException {
        IOContext iOContext = this._createContext(byArray, true);
        return this._createParser(byArray, 0, byArray.length, iOContext);
    }

    @Override
    @Deprecated
    public SmileParser createJsonParser(byte[] byArray, int n, int n2) throws IOException, JsonParseException {
        return this._createParser(byArray, n, n2, this._createContext(byArray, true));
    }

    @Override
    public SmileGenerator createGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) throws IOException {
        return this._createGenerator(outputStream, this._createContext(outputStream, false));
    }

    @Override
    public SmileGenerator createGenerator(OutputStream outputStream) throws IOException {
        return this._createGenerator(outputStream, this._createContext(outputStream, false));
    }

    @Override
    @Deprecated
    public SmileGenerator createJsonGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) throws IOException {
        return this._createGenerator(outputStream, this._createContext(outputStream, false));
    }

    @Override
    @Deprecated
    public SmileGenerator createJsonGenerator(OutputStream outputStream) throws IOException {
        IOContext iOContext = this._createContext(outputStream, false);
        return this._createGenerator(outputStream, iOContext);
    }

    @Override
    @Deprecated
    protected SmileGenerator _createUTF8JsonGenerator(OutputStream outputStream, IOContext iOContext) throws IOException {
        return this._createGenerator(outputStream, iOContext);
    }

    @Override
    protected SmileParser _createParser(InputStream inputStream, IOContext iOContext) throws IOException, JsonParseException {
        return new SmileParserBootstrapper(iOContext, inputStream).constructParser(this._parserFeatures, this._smileParserFeatures, this.isEnabled(JsonFactory.Feature.INTERN_FIELD_NAMES), this._objectCodec, this._rootByteSymbols);
    }

    @Override
    protected JsonParser _createParser(Reader reader, IOContext iOContext) throws IOException, JsonParseException {
        if (this._cfgDelegateToTextual) {
            return super._createParser(reader, iOContext);
        }
        throw new UnsupportedOperationException("Can not create generator for non-byte-based target");
    }

    @Override
    protected SmileParser _createParser(byte[] byArray, int n, int n2, IOContext iOContext) throws IOException, JsonParseException {
        return new SmileParserBootstrapper(iOContext, byArray, n, n2).constructParser(this._parserFeatures, this._smileParserFeatures, this.isEnabled(JsonFactory.Feature.INTERN_FIELD_NAMES), this._objectCodec, this._rootByteSymbols);
    }

    @Override
    protected JsonGenerator _createGenerator(Writer writer, IOContext iOContext) throws IOException {
        if (this._cfgDelegateToTextual) {
            return super._createGenerator(writer, iOContext);
        }
        throw new UnsupportedOperationException("Can not create generator for non-byte-based target");
    }

    @Override
    protected JsonGenerator _createUTF8Generator(OutputStream outputStream, IOContext iOContext) throws IOException {
        return this._createGenerator(outputStream, iOContext);
    }

    @Override
    protected Writer _createWriter(OutputStream outputStream, JsonEncoding jsonEncoding, IOContext iOContext) throws IOException {
        if (this._cfgDelegateToTextual) {
            return super._createWriter(outputStream, jsonEncoding, iOContext);
        }
        throw new UnsupportedOperationException("Can not create generator for non-byte-based target");
    }

    protected SmileGenerator _createGenerator(OutputStream outputStream, IOContext iOContext) throws IOException {
        int n = this._smileGeneratorFeatures;
        SmileGenerator smileGenerator = new SmileGenerator(iOContext, this._generatorFeatures, n, this._objectCodec, outputStream);
        if ((n & SmileGenerator.Feature.WRITE_HEADER.getMask()) != 0) {
            smileGenerator.writeHeader();
        } else {
            if ((n & SmileGenerator.Feature.CHECK_SHARED_STRING_VALUES.getMask()) != 0) {
                throw new JsonGenerationException("Inconsistent settings: WRITE_HEADER disabled, but CHECK_SHARED_STRING_VALUES enabled; can not construct generator due to possible data loss (either enable WRITE_HEADER, or disable CHECK_SHARED_STRING_VALUES to resolve)");
            }
            if ((n & SmileGenerator.Feature.ENCODE_BINARY_AS_7BIT.getMask()) == 0) {
                throw new JsonGenerationException("Inconsistent settings: WRITE_HEADER disabled, but ENCODE_BINARY_AS_7BIT disabled; can not construct generator due to possible data loss (either enable WRITE_HEADER, or ENCODE_BINARY_AS_7BIT to resolve)");
            }
        }
        return smileGenerator;
    }
}

